/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.transsion.appupdate.R;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.entity.AppDownloadTaskData;
import com.transsion.appupdate.media.MediaManager;
import com.transsion.appupdate.reportBean.RecordStateData;
import com.transsion.appupdate.service.DataSyncService;
import com.transsion.appupdate.utils.DateUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.NotifyUtils;
import com.transsion.appupdate.utils.PrivacyPolicyUtil;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.common.bean.AppDetailInfo;
import com.transsion.common.bean.ImgInfo;
import com.transsion.common.bean.SdkAppConfig;
import com.transsion.common.log.CS;
import com.transsion.common.utils.IntentUtil;
import com.transsion.commonlib.config.CSLib;
import com.transsion.commonlib.util.SpUtil;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.NewPhoneRecommendManager;
import com.transsion.osupdate.util.OSDownLoadStateUtil;
import java.util.ArrayList;
import java.util.List;

public class AppUpdateService
extends Service {
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.recordLastStartTime();
        this.UpdateJob();
        return super.onStartCommand(intent, flags, startId);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void recordLastStartTime() {
        SpUtil.getSP().putLong("app_update_service_last_start_time", System.currentTimeMillis());
    }

    private void UpdateJob() {
        CS.log.v("TMS_APP", "-----------------------------  UpdateService: START !!!  ---------------------------");
        CS.log.v("TMS_APP", "--------  UpdateService: storage Check!!!");
        if (StorageUtils.isLessThanUsagePercent(5L)) {
            CS.log.d("TMS_APP", "UpdateService: storage Check STOP !!!");
            return;
        }
        if (CSLib.GDPR_OPEN) {
            this.checkPrivacyPolicy();
        }
        this.startPushService(CoreUtil.getContext());
        this.reportDailyActive();
        this.checkAppUpdateDownloadTask(CoreUtil.getContext());
        if (CSLib.OS_UPDATE) {
            AppUpdateService.startOSDownLoadService(CoreUtil.getContext());
        }
        CS.log.v("TMS_APP", "--------  UpdateService: syncMedia !!!");
        MediaManager.getInstance().syncMedia();
        CS.log.v("TMS_APP", "--------   UpdateService: FREQUENCY_RESET !!!");
        if (!DateUtil.isSameDay("FREQUENCY_RESET")) {
            CS.log.v("TMS_APP", "is not same day, reset Frequency & AppDetail!!!");
            DBManager.getInstance().resetCreativeUsedFrequency();
            this.clearInvalidAppDetailInfo();
        }
        CS.log.v("TMS_APP", "--------    UpdateService: Tracker !!!");
        CS.log.v("TMS_APP", "--------  UpdateService: Awake !!!");
        this.awakeSDKApps();
        CS.log.v("TMS_APP", "-------- UpdateService: NewPhoneRecommend job !!!");
        NewPhoneRecommendManager.backgroundWork();
        CS.log.v("TMS_APP", "-----------------------------  UpdateService: END !!!  ---------------------------");
    }

    private void clearInvalidAppDetailInfo() {
        List<AppDetailInfo> invalidAppDetailList = DBManager.getInstance().getInvalidAppDetailList();
        if (invalidAppDetailList != null && !invalidAppDetailList.isEmpty()) {
            ArrayList<AppDownLoadTask> invalidTaskList = new ArrayList<AppDownLoadTask>();
            for (AppDetailInfo info : invalidAppDetailList) {
                if (info == null) continue;
                AppDownLoadTask task = new AppDownLoadTask(info.getDownloadUrl(), info.getMd5(), info.getSize(), FileUtil.createApkDownloadPath(CoreUtil.getContext(), info.getDownloadUrl()), DownloadState.INITIAL, info.getPkgName(), info.getIcon().getUrl(), info.getTitle(), info.getAppId(), true, info.getVersionName(), info.getVersionCode(), 2, info.getDescription(), this.getImgUrl(info));
                invalidTaskList.add(task);
            }
            if (!invalidTaskList.isEmpty()) {
                AppDownloadTaskData data = new AppDownloadTaskData();
                data.setTaskList(invalidTaskList);
                String jsonData = Tson.toJson((Object)data);
                Context context = CoreUtil.getContext();
                Intent intent = new Intent(context, DataSyncService.class);
                intent.putExtra("media", 3);
                intent.putExtra("taskList", jsonData);
                try {
                    context.startService(intent);
                }
                catch (Exception e) {
                    CS.log.e("TMS_APP", e.getMessage());
                }
            }
        }
        DBManager.getInstance().clearInvalidAppDetail();
    }

    private void checkPrivacyPolicy() {
        RecordStateData recordStateData = FileUtil.readRecordStateData(CoreUtil.getContext());
        if (recordStateData == null) {
            recordStateData = new RecordStateData();
        }
        if (recordStateData.getInitTime() <= 0L) {
            recordStateData.setInitTime(System.currentTimeMillis());
            FileUtil.saveRecordStateData(CoreUtil.getContext(), recordStateData);
        }
        PrivacyPolicyUtil.resetReportStateByPrivacyPolicy();
    }

    public static void startOSDownLoadService(Context context) {
        try {
            boolean state = OSDownLoadStateUtil.getState((Context)context);
            CS.log.v("TMS_OS_UPDATE", "\u5f00\u542f" + state);
            if (state) {
                Intent intent = new Intent();
                intent.setComponent(new ComponentName(context.getPackageName(), "com.transsion.osupdate.service.OSDownLoadService"));
                IntentUtil.startService((Context)context, (Intent)intent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startPushService(Context ctx) {
        try {
            Intent intent = new Intent();
            intent.putExtra("source", 1);
            intent.putExtra("IS_LOG_OPEN", CS.DEBUG_LOG);
            intent.putExtra("IS_DEBUG_SERVER", CSLib.SERVE_DEBUG);
            intent.setComponent(new ComponentName(ctx.getPackageName(), "com.android.hundsup.PushService"));
            IntentUtil.startService((Context)ctx, (Intent)intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void awakeSDKApps() {
        List<SdkAppConfig> sdkAppConfigList = DBManager.getInstance().getAllSdkAppConfig();
        ArrayList<SdkAppConfig> awakeSdkAppConfigList = new ArrayList<SdkAppConfig>();
        if (null != sdkAppConfigList && sdkAppConfigList.size() > 0) {
            for (SdkAppConfig config : sdkAppConfigList) {
                if (0 == config.getAwakeInterval()) continue;
                long curTime = System.currentTimeMillis();
                CS.log.v("TMS_APP", "AwakeLastTime : " + config.getAwakeLastTime());
                CS.log.v("TMS_APP", "AwakeUpdateTime : " + Math.abs(System.currentTimeMillis() - config.getAwakeLastTime()));
                CS.log.v("TMS_APP", "AwakeIntervalTime : " + config.getAwakeInterval() * 60 * 60 * 1000);
                if (curTime < config.getAwakeStartDateRange() || curTime > config.getaWakeEndDateRange() || Math.abs(System.currentTimeMillis() - config.getAwakeLastTime()) <= (long)(config.getAwakeInterval() * 60 * 60 * 1000)) continue;
                config.setAwakeLastTime(System.currentTimeMillis());
                awakeSdkAppConfigList.add(config);
            }
            if (awakeSdkAppConfigList.size() > 0) {
                DBManager.getInstance().saveOrUpdateSdkAppConfigList(awakeSdkAppConfigList);
            }
        }
    }

    private void checkAppUpdateDownloadTask(Context context) {
        if (context == null) {
            return;
        }
        long lastEnterAppUpdateTime = SpUtil.getSP().getLong("LAST_ENTER_APP_UPDATE_TIME", 0L);
        if (System.currentTimeMillis() - lastEnterAppUpdateTime <= 86400000L) {
            return;
        }
        int appAmount = 0;
        List<AppDownLoadTask> taskList = AppDownloadTaskManager.getInstance(context).getAllDownloadTask(AppDownLoadTask.obtain());
        if (taskList != null) {
            for (AppDownLoadTask task : taskList) {
                if (task == null) continue;
                switch (task.apkType) {
                    case 1: {
                        ++appAmount;
                        break;
                    }
                    case 2: {
                        if (task.downloadState != DownloadState.DOWNLOADING && task.downloadState != DownloadState.PAUSE && task.downloadState != DownloadState.WAITING) break;
                        ++appAmount;
                        break;
                    }
                }
            }
        }
        if (appAmount > 0) {
            this.sendNotification(context, appAmount);
        }
    }

    private void sendNotification(Context context, int appAmount) {
        if (context == null || appAmount <= 0) {
            return;
        }
        CS.log.d("TMS_APP", "send app update notification");
        String title = context.getString(R.string.notification_app_update_title, new Object[]{appAmount});
        String text = context.getString(R.string.notification_app_update_content);
        NotifyUtils.sendNormalNotification(context, title, text, 11);
    }

    private void reportDailyActive() {
        if (!DateUtil.isSameDay("TMS")) {
            Tracker.track(Tracker.TID.TMS_ACTIVE, null);
        }
    }

    private String getImgUrl(AppDetailInfo info) {
        if (info == null || info.getImages() == null || info.getImages().size() <= 0) {
            return null;
        }
        return ((ImgInfo)info.getImages().get(0)).getUrl();
    }
}

