/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.IntentService;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.transsion.appupdate.download.DownloadHelper;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.entity.AppDownloadTaskData;
import com.transsion.common.log.CS;
import com.transsion.json.Tson;
import java.util.List;

public class DataSyncService
extends IntentService {
    public DataSyncService() {
        super("DataSyncService");
    }

    protected void onHandleIntent(@Nullable Intent intent) {
        CS.log.d("TMS_APP", "DataSyncService onHandleIntent");
        if (intent != null) {
            AppDownloadTaskData appDownloadTaskData;
            int media = intent.getIntExtra("media", 0);
            String appDownloadTaskDataJson = intent.getStringExtra("taskList");
            if (!TextUtils.isEmpty((CharSequence)appDownloadTaskDataJson) && (appDownloadTaskData = (AppDownloadTaskData)Tson.fromJson((String)appDownloadTaskDataJson, AppDownloadTaskData.class)) != null && appDownloadTaskData.getTaskList() != null && !appDownloadTaskData.getTaskList().isEmpty()) {
                switch (media) {
                    case 1: {
                        this.addAppDownloadTaskList(appDownloadTaskData.getTaskList(), true);
                        break;
                    }
                    case 2: {
                        this.addAppDownloadTaskList(appDownloadTaskData.getTaskList(), false);
                        break;
                    }
                    case 3: {
                        this.deleteAppDownloadTaskList(appDownloadTaskData.getTaskList());
                        break;
                    }
                }
            }
        }
    }

    private void addAppDownloadTaskList(List<AppDownLoadTask> taskList, boolean onlyMedia) {
        if (taskList != null) {
            CS.log.d("TMS_APP", "add taskList size = " + taskList.size() + ", onlyMedia = " + onlyMedia);
            for (AppDownLoadTask task : taskList) {
                if (onlyMedia) {
                    DownloadHelper.getInstance().addAppDownload(task, onlyMedia);
                    continue;
                }
                DownloadHelper.getInstance().addAppDownload(task);
            }
        }
    }

    private void deleteAppDownloadTaskList(List<AppDownLoadTask> taskList) {
        if (taskList != null) {
            CS.log.d("TMS_APP", "delete taskList size = " + taskList.size());
            for (AppDownLoadTask task : taskList) {
                DownloadHelper.getInstance().deleteAppDownload(task);
            }
        }
    }
}

