/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.data.Callback;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.CoreDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.IDownloadListener;
import com.transsion.appupdate.download.task.ImgCacheTask;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.reportBean.ImgCacheEvent;
import com.transsion.appupdate.utils.AppExecutors;
import com.transsion.appupdate.utils.FileProviderUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.NetworkUtil;
import com.transsion.common.bean.ImgInfoDL;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ImageCacheJobService
extends JobService {
    public static final int ENFORCE_JOB_ID = 357;
    private static long INTERVAL = CSLib.TEST_MODE ? 300000L : 1800000L;
    private IDownloadListener imageCacheLister = new IDownloadListener<ImgCacheTask>(){

        @Override
        public void updateDownloadStatus(ImgCacheTask task) {
            CS.log.d("TMS_DOWNLOAD", "\u56fe\u7247task\uff1a" + task.url + " : " + task.finishedSize + "/" + task.totalSize);
            switch (task.downloadState) {
                case FINISHED: {
                    CS.log.d("TMS_DOWNLOAD", "onCallbackSuccess  : task =" + task.filePath);
                    String fileProviderPath = FileProviderUtil.getUriByPath(CoreUtil.getContext(), task.filePath);
                    CS.log.d("TMS_DOWNLOAD", "path=" + fileProviderPath);
                    DBManager.getInstance().updateImageCachedFilePath(task.url, fileProviderPath);
                    CoreDownloadTaskManager.getInstance(CoreUtil.getContext()).deleteDownload(task);
                    ArrayList<Bundle> trackImgEventList = new ArrayList<Bundle>();
                    ImgCacheEvent imgCacheEvent = new ImgCacheEvent(task.CID, task.url, 1, task.reDownloadTimes);
                    trackImgEventList.add(imgCacheEvent.getBundle());
                    Tracker.trackList(Tracker.TID.TMS_IMG_CACHE_STATUS, trackImgEventList);
                    break;
                }
                case FAILED: {
                    CS.log.d("TMS_DOWNLOAD", "onCallbackFailed  : task =" + task.url);
                    if (task.reDownloadTimes < task.reDownloadMaxTimes) break;
                    ArrayList<Bundle> trackImgEventList = new ArrayList<Bundle>();
                    ImgCacheEvent imgCacheEvent = new ImgCacheEvent(task.CID, task.url, -3, task.reDownloadTimes);
                    trackImgEventList.add(imgCacheEvent.getBundle());
                    Tracker.trackList(Tracker.TID.TMS_IMG_CACHE_STATUS, trackImgEventList);
                    CoreDownloadTaskManager.getInstance(CoreUtil.getContext()).deleteDownload(task);
                    DBManager.getInstance().deleteCreativeByImageUrl(task.url);
                    break;
                }
                case DOWNLOADING: {
                    CS.log.d("TMS_DOWNLOAD", "onLoading  : task =" + task.url + " : " + task.finishedSize + "/" + task.totalSize);
                    break;
                }
                case PAUSE: {
                    break;
                }
            }
        }
    };

    public static void startJob(Context context) {
        INTERVAL = CSLib.TEST_MODE ? 300000L : 1800000L;
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        if (js != null) {
            CS.log.d("TMS_APP", " ---> call startJob  ImageCacheJobService ...");
            js.schedule(new JobInfo.Builder(357, new ComponentName(context, ImageCacheJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(INTERVAL * 2L).build());
        }
    }

    public boolean onStopJob(JobParameters params) {
        CS.log.d("TMS_UPDATE", "onStopJob Id: " + params.getJobId());
        return false;
    }

    public boolean onStartJob(JobParameters params) {
        CS.log.d("TMS_APP", "===== onStartJob  ImageCacheJobService ... INTERVAL->" + INTERVAL);
        this.imageCacheJob();
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(357, new ComponentName((Context)this, ImageCacheJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(INTERVAL * 2L).setPersisted(true).setMinimumLatency(INTERVAL).build());
        }
        return false;
    }

    void imageCacheJob() {
        this.loadImageCache(imgCacheList -> {
            if (imgCacheList.size() > 0) {
                this.imgDownload((List<ImgCacheTask>)imgCacheList);
            }
        });
    }

    public void loadImageCache(Callback<List<ImgCacheTask>> callback) {
        AppExecutors.getInstance().work().execute(() -> {
            List<ImgCacheTask> imgCacheTaskList = this.getCreativeCacheImages();
            AppExecutors.getInstance().ui().execute(() -> {
                if (callback != null) {
                    callback.onCallback(imgCacheTaskList);
                }
            });
        });
    }

    private List<ImgCacheTask> getCreativeCacheImages() {
        ArrayList<ImgCacheTask> imgCacheTaskList = new ArrayList<ImgCacheTask>();
        List<ImgCacheTask> imgDownloadingCachedTaskList = CoreDownloadTaskManager.getInstance(CoreUtil.getContext()).getAllDownloadTask(ImgCacheTask.obtain());
        HashMap<String, ImgCacheTask> taskMap = new HashMap<String, ImgCacheTask>();
        for (ImgCacheTask task : imgDownloadingCachedTaskList) {
            if (task == null || TextUtils.isEmpty((CharSequence)task.url)) continue;
            if (DownloadState.WAITING == task.downloadState || DownloadState.DOWNLOADING == task.downloadState) {
                CoreDownloadTaskManager.getInstance(CoreUtil.getContext()).pauseDownloadTask(task);
            }
            taskMap.put(task.url, task);
        }
        List<ImgInfoDL> imgInfoList = DBManager.getInstance().getNotCachedImgInfoListByWeight();
        if (null != imgInfoList && 0 < imgInfoList.size()) {
            for (ImgInfoDL imgInfo : imgInfoList) {
                if (imgInfo == null || TextUtils.isEmpty((CharSequence)imgInfo.getUrl()) || !NetworkUtil.isAllowNetWork(imgInfo.getNetwork())) continue;
                ImgCacheTask task = (ImgCacheTask)taskMap.get(imgInfo.getUrl());
                if (task == null) {
                    task = new ImgCacheTask(imgInfo.getUrl(), imgInfo.getMd5(), imgInfo.getCID(), 0L, FileUtil.createImgDownloadPath(CoreUtil.getContext(), imgInfo.getUrl()), DownloadState.WAITING, imgInfo.getNetwork(), ConfigInfoManager.getInstance().getImageDownloadRetryTimes());
                }
                imgCacheTaskList.add(task);
            }
        }
        return imgCacheTaskList;
    }

    private void imgDownload(List<ImgCacheTask> imgCacheTaskList) {
        CoreDownloadTaskManager downloadTaskManager = CoreDownloadTaskManager.getInstance(this.getApplicationContext());
        downloadTaskManager.registerDownloadCallback(this.imageCacheLister, ImgCacheTask.class);
        ArrayList<Bundle> imgCacheEventList = new ArrayList<Bundle>();
        for (ImgCacheTask task : imgCacheTaskList) {
            int result = downloadTaskManager.startDownload(task);
            ImgCacheEvent imgCacheEvent = new ImgCacheEvent(task.CID, task.url, result, task.reDownloadTimes);
            imgCacheEventList.add(imgCacheEvent.getBundle());
        }
        if (!imgCacheEventList.isEmpty()) {
            Tracker.trackList(Tracker.TID.TMS_IMG_CACHE_START_STATUS, imgCacheEventList);
        }
    }
}

