/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.service;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.reportBean.AppTaskData;
import com.transsion.appupdate.reportBean.CIDStatusData;
import com.transsion.common.bean.CreativeIndex;
import com.transsion.common.bean.CreativeInfo;
import com.transsion.common.log.CS;
import com.transsion.commonlib.config.CSLib;
import com.transsion.core.CoreUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TrackerJobService
extends JobService {
    public static final int ENFORCE_JOB_ID = 345;
    public static final long DEFAULT_INTERVAL = CSLib.TEST_MODE ? 300000L : 3600000L;

    public static void startJob(Context context) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        if (js != null) {
            CS.log.d("TMS_APP", " ---> call startJob  TrackerJobService ...");
            js.schedule(new JobInfo.Builder(345, new ComponentName(context, TrackerJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(DEFAULT_INTERVAL * 2L).build());
        }
    }

    public boolean onStopJob(JobParameters params) {
        CS.log.d("TMS_UPDATE", "onStopJob Id: " + params.getJobId());
        return false;
    }

    public boolean onStartJob(JobParameters params) {
        long interval = ConfigInfoManager.getInstance().getTrackerReportInterval();
        if (0L != interval) {
            try {
                this.trackerJob();
            }
            catch (Exception e) {
                CS.log.v("TMS_TRACKER", "TrackerJobService trackerJob Exception ->" + e.toString());
            }
            if ((interval *= 1000L) < DEFAULT_INTERVAL && !CSLib.TEST_MODE) {
                interval = DEFAULT_INTERVAL;
            }
        } else {
            interval = DEFAULT_INTERVAL;
        }
        CS.log.d("TMS_APP", "===== onStartJob  TrackerJobService ... INTERVAL->" + interval);
        JobScheduler js = (JobScheduler)this.getSystemService("jobscheduler");
        if (js != null) {
            js.schedule(new JobInfo.Builder(345, new ComponentName((Context)this, TrackerJobService.class)).setRequiredNetworkType(1).setOverrideDeadline(interval * 2L).setPersisted(true).setMinimumLatency(interval).build());
        }
        return false;
    }

    void trackerJob() {
        List<AppDownLoadTask> list;
        List<CreativeIndex> list2;
        List<CreativeInfo> creativeInfoList;
        HashMap<Integer, CIDStatusData> cidStatusMap = new HashMap<Integer, CIDStatusData>();
        List<CreativeIndex> creativeIndexList = DBManager.getInstance().getAllCachedCreativeIndex();
        if (null != creativeIndexList && creativeIndexList.size() > 0) {
            for (CreativeIndex creativeIndex : creativeIndexList) {
                CIDStatusData cIDStatusData = new CIDStatusData(creativeIndex.getCreativeID(), creativeIndex.getCreativeVersion(), -1);
                cidStatusMap.put(creativeIndex.getCreativeID(), cIDStatusData);
            }
        }
        if (null != (creativeInfoList = DBManager.getInstance().getAllCachedCreativeInfo(0)) && creativeInfoList.size() > 0) {
            for (CreativeInfo creativeInfo : creativeInfoList) {
                CIDStatusData cidStatusData = (CIDStatusData)cidStatusMap.get(creativeInfo.getCreativeIndex().getCreativeID());
                if (null == cidStatusData) continue;
                cidStatusData.setType(1);
            }
        }
        if (null != (list2 = DBManager.getInstance().getDeleteCreativeList(20)) && list2.size() > 0) {
            for (CreativeIndex creativeIndex : list2) {
                CIDStatusData cidStatusData = new CIDStatusData(creativeIndex.getCreativeID(), creativeIndex.getCreativeVersion(), -2);
                cidStatusMap.put(creativeIndex.getCreativeID(), cidStatusData);
            }
        }
        if (!cidStatusMap.isEmpty()) {
            ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
            for (CIDStatusData cidStatusData : cidStatusMap.values()) {
                arrayList.add(cidStatusData.getBundle());
            }
            Tracker.trackList(Tracker.TID.TMS_CID_STATUS, arrayList);
        }
        if (null != (list = AppDownloadTaskManager.getInstance(CoreUtil.getContext()).getAllDownloadTask(AppDownLoadTask.obtain())) && list.size() > 0) {
            ArrayList<Bundle> appTaskDataList = new ArrayList<Bundle>();
            for (AppDownLoadTask task : list) {
                AppTaskData appTaskData = new AppTaskData();
                appTaskData.setAppId(task.appId);
                appTaskData.setAppVersion(task.appVersionCode);
                appTaskData.setAppPkg(task.pkgName);
                appTaskData.setAppType(this.convertApkTypeToTrackApkType(task.apkType));
                appTaskData.setState(task.downloadState.toString());
                appTaskData.setTimes(task.reDownloadTimes);
                appTaskDataList.add(appTaskData.getBundle());
            }
            if (!appTaskDataList.isEmpty()) {
                Tracker.trackList(Tracker.TID.TMS_APP_TASK_STATUS, appTaskDataList);
            }
        }
    }

    private int convertApkTypeToTrackApkType(int apkType) {
        int trackApkType = -1;
        switch (apkType) {
            case 0: {
                trackApkType = 1;
                break;
            }
            case 1: {
                trackApkType = 2;
                break;
            }
            case 2: {
                trackApkType = 3;
                break;
            }
        }
        return trackApkType;
    }
}

