/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.tmsServer;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.tms.common.ITmsAidl;
import com.android.tms.common.ITmsCreativesCallback;
import com.transsion.appupdate.Tracker;
import com.transsion.appupdate.database.DBManager;
import com.transsion.appupdate.download.AppDownloadTaskManager;
import com.transsion.appupdate.download.DownloadState;
import com.transsion.appupdate.download.task.AppDownLoadTask;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.http.HttpTool;
import com.transsion.appupdate.manager.ConfigInfoManager;
import com.transsion.appupdate.reportBean.TmsActionData;
import com.transsion.appupdate.reportBean.TmsCreativeActionData;
import com.transsion.appupdate.reportBean.TmsGetCreativeActionData;
import com.transsion.appupdate.ui.detail.AppUpdateDetailActivity;
import com.transsion.appupdate.ui.main.AppUpdateActivity;
import com.transsion.appupdate.ui.main.SelfWebViewActivity;
import com.transsion.appupdate.utils.ContantUtil;
import com.transsion.appupdate.utils.DateUtil;
import com.transsion.appupdate.utils.FileProviderUtil;
import com.transsion.appupdate.utils.FileUtil;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.common.bean.AppDetailInfo;
import com.transsion.common.bean.CreativeInfo;
import com.transsion.common.bean.CreativeListAidl;
import com.transsion.common.bean.ImgInfo;
import com.transsion.common.bean.SdkAppConfig;
import com.transsion.common.bean.SdkAppID;
import com.transsion.common.log.CS;
import com.transsion.commonlib.model.UsageAppCollection;
import com.transsion.commonlib.util.LimitCountUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.json.Tson;
import java.util.ArrayList;
import java.util.List;

public class TmsService
extends Service {
    private ITmsAidl.Stub tmsInterface = new ITmsAidl.Stub(){

        private boolean checkEnable(String pkgName) {
            if (null != pkgName) {
                String sha1 = PackageUtil.getSignWrap(TmsService.this.getApplicationContext(), pkgName);
                SdkAppConfig sdkAppConfig = DBManager.getInstance().getSdkAppConfigByPkgName(pkgName, sha1);
                if (null != sdkAppConfig && !TextUtils.isEmpty((CharSequence)sdkAppConfig.getPidList())) {
                    CS.log.v("TMS_SERVER", "Server ->  checkEnable : Enable !!!");
                    return true;
                }
                TmsActionData tmsActionData = new TmsActionData();
                tmsActionData.setAction(3);
                tmsActionData.setSdkAppPkgName(pkgName);
                Tracker.track(Tracker.TID.TMS_SDK_ACTION, tmsActionData.getBundle());
            }
            CS.log.v("TMS_SERVER", "Server ->  checkEnable : NOT Enable !!!");
            return false;
        }

        public boolean isEnable(String pkgName) {
            return true;
        }

        public void getCreativeList(final String pkgName, final String placementID, final int creativeType, final int count, final ITmsCreativesCallback callback) {
            CS.log.d("TMS_SERVER", "Server->\u5f00\u59cb\u83b7\u53d6\u521b\u610f\uff0cplacementID:" + placementID + ", creativeType:" + creativeType + ", count:" + count);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (TextUtils.isEmpty((CharSequence)pkgName)) {
                            return;
                        }
                        String sha1 = PackageUtil.getSignWrap(TmsService.this.getApplicationContext(), pkgName);
                        CS.log.v("TMS_SERVER", "Server -> strKey :" + pkgName + sha1);
                        SdkAppConfig sdkAppConfig = DBManager.getInstance().getSdkAppConfigByPkgName(pkgName, sha1);
                        if (null == sdkAppConfig) {
                            CS.log.v("TMS_SERVER", "Server ->  onBind : No record, get more info next network connect!!!");
                            ArrayList<SdkAppConfig> sdkAppConfigList = new ArrayList<SdkAppConfig>(1);
                            SdkAppID sdkAppID = new SdkAppID(pkgName, sha1);
                            sdkAppConfig = new SdkAppConfig(sdkAppID);
                            sdkAppConfigList.add(sdkAppConfig);
                            DBManager.getInstance().saveOrUpdateSdkAppConfigList(sdkAppConfigList);
                            callback.onFail("sdkAppConfig NOT EXIST!!!");
                            CS.log.d("TMS_SERVER", " sdkAppConfig NOT EXIST!!!");
                            TmsActionData tmsActionData = new TmsActionData();
                            tmsActionData.setAction(3);
                            tmsActionData.setSdkAppPkgName(pkgName);
                            Tracker.track(Tracker.TID.TMS_SDK_ACTION, tmsActionData.getBundle());
                            return;
                        }
                        if (TextUtils.isEmpty((CharSequence)sdkAppConfig.getPidList()) || 10 != placementID.length() || !sdkAppConfig.getPidList().contains(placementID)) {
                            callback.onFail("PID NOT EXIST!!!");
                            CS.log.d("TMS_SERVER", " PID NOT EXIST!!!");
                            TmsActionData tmsActionData = new TmsActionData();
                            tmsActionData.setAction(3);
                            tmsActionData.setSdkAppPkgName(pkgName);
                            Tracker.track(Tracker.TID.TMS_SDK_ACTION, tmsActionData.getBundle());
                            return;
                        }
                        List<CreativeInfo> creativeInfoList = DBManager.getInstance().getAllCachedCreativeInfo(creativeType);
                        ArrayList<CreativeInfo> creativeInfoListFilter = new ArrayList<CreativeInfo>();
                        if (creativeInfoList != null) {
                            for (CreativeInfo creativeInfo : creativeInfoList) {
                                long curTime;
                                int limit = creativeInfo.getFrequencyLimitCount();
                                if (0 != limit && creativeInfo.getFrequencyUsedTime() >= limit) {
                                    CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- FrequencyLimit :" + limit + "/" + creativeInfo.getFrequencyUsedTime());
                                    continue;
                                }
                                String blacklist = creativeInfo.getBlacklist();
                                if (TextUtils.isEmpty((CharSequence)blacklist)) {
                                    String whitelist = creativeInfo.getWhitelist();
                                    if (TextUtils.isEmpty((CharSequence)whitelist) || !whitelist.equalsIgnoreCase("all") && !whitelist.contains(placementID)) {
                                        CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- placementID :" + placementID + "/whitelist:" + whitelist);
                                        continue;
                                    }
                                } else if (blacklist.contains(placementID)) {
                                    CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- placementID :" + placementID + "/blacklist:" + blacklist);
                                    continue;
                                }
                                if ((curTime = System.currentTimeMillis()) <= creativeInfo.getValidStartTime() || curTime >= creativeInfo.getValidEndTime()) {
                                    CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- ValidTime :" + curTime + "/" + creativeInfo.getValidStartTime() + "/" + creativeInfo.getValidEndTime());
                                    continue;
                                }
                                if (!creativeInfo.getGrayStartTime().equals(creativeInfo.getGrayEndTime()) && DateUtil.isInvalidTime(creativeInfo.getGrayStartTime(), creativeInfo.getGrayEndTime())) {
                                    CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- GrayTime :" + curTime + "/" + creativeInfo.getGrayStartTime() + "/" + creativeInfo.getGrayEndTime());
                                    continue;
                                }
                                long updateTime = ConfigInfoManager.getInstance().getImpressionInterval() * 1000L;
                                long lastTime = creativeInfo.getLastShowTime();
                                if (Math.abs(System.currentTimeMillis() - lastTime) < updateTime) {
                                    CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- LastShowTime :" + lastTime + ", < impression interval: " + updateTime);
                                    continue;
                                }
                                if (1 == creativeInfo.getCreativeType()) {
                                    if (creativeInfo.getAppId() <= 0 || TextUtils.isEmpty((CharSequence)creativeInfo.getPkgName())) {
                                        CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- no find app detail info:" + creativeInfo.getAppId());
                                        continue;
                                    }
                                    boolean isAppExist = PackageUtil.checkApkExist(TmsService.this.getApplicationContext(), creativeInfo.getPkgName(), creativeInfo.getVersionCode());
                                    if (isAppExist) {
                                        CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- app is existed, " + creativeInfo.getPkgName() + "/" + creativeInfo.getVersionCode());
                                        continue;
                                    }
                                }
                                CS.log.v("TMS_SERVER", creativeInfo.getCreativeIndex().getCreativeID() + "-- Add List");
                                creativeInfoListFilter.add(creativeInfo);
                                if (creativeInfoListFilter.size() < count) continue;
                                break;
                            }
                        }
                        if (creativeInfoListFilter.size() > 0) {
                            for (CreativeInfo creativeInfo : creativeInfoListFilter) {
                                ImgInfo icon = creativeInfo.getIcon();
                                ImgInfo logo = creativeInfo.getLogo();
                                ImgInfo anonymousIcon = creativeInfo.getAnonymousIcon();
                                if (icon != null) {
                                    FileProviderUtil.grantUriPermission(CoreUtil.getContext(), Uri.parse((String)icon.getCachedFilePath()), pkgName);
                                }
                                if (logo != null) {
                                    FileProviderUtil.grantUriPermission(CoreUtil.getContext(), Uri.parse((String)logo.getCachedFilePath()), pkgName);
                                }
                                if (anonymousIcon != null) {
                                    FileProviderUtil.grantUriPermission(CoreUtil.getContext(), Uri.parse((String)anonymousIcon.getCachedFilePath()), pkgName);
                                }
                                List images = creativeInfo.getImages();
                                List screenshots = creativeInfo.getScreenShot();
                                if (images != null) {
                                    for (ImgInfo image : images) {
                                        FileProviderUtil.grantUriPermission(CoreUtil.getContext(), Uri.parse((String)image.getCachedFilePath()), pkgName);
                                    }
                                }
                                if (screenshots != null) {
                                    for (ImgInfo screenshot : screenshots) {
                                        FileProviderUtil.grantUriPermission(CoreUtil.getContext(), Uri.parse((String)screenshot.getCachedFilePath()), pkgName);
                                    }
                                }
                                TmsGetCreativeActionData getCreativeActionData = new TmsGetCreativeActionData();
                                getCreativeActionData.setAction(4);
                                getCreativeActionData.setSdkAppPkgName(pkgName);
                                getCreativeActionData.setCreativeId(creativeInfo.getCreativeIndex().getCreativeID());
                                getCreativeActionData.setPlacementId(placementID);
                                getCreativeActionData.setCount(count);
                                Tracker.track(Tracker.TID.TMS_SDK_ACTION, getCreativeActionData.getBundle());
                            }
                        }
                        for (CreativeInfo creativeInfo : creativeInfoListFilter) {
                            CS.log.d("TMS_SERVER", "\u54cd\u5e94\uff1a " + creativeInfo.getCreativeIndex().getCreativeID() + " : " + Tson.toJson((Object)creativeInfo));
                        }
                        CreativeListAidl creativeListAidl = new CreativeListAidl(creativeInfoListFilter);
                        String data = Tson.toJson((Object)creativeListAidl);
                        callback.onSuccess(data);
                    }
                    catch (Exception e) {
                        try {
                            callback.onFail("Exception :" + e.toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            TmsService.this.handleRunnable(r);
        }

        public void onShow(final int creativeID, final String pkgName) {
            CS.log.d("TMS_SERVER", "Server-> \u663e\u793aonShow\uff0c creativeId:" + creativeID + ", pkgName:" + pkgName);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!this.checkEnable(pkgName)) {
                        return;
                    }
                    DBManager.getInstance().increaseCreativeUsedFrequency(creativeID, 1);
                    DBManager.getInstance().updateCreativeLastShowTimeById(creativeID);
                    CreativeInfo creativeInfo = DBManager.getInstance().getCreativeInfoById(creativeID);
                    if (creativeInfo != null) {
                        if (!TextUtils.isEmpty((CharSequence)creativeInfo.getImpressionTracker())) {
                            List trackerList = (List)Tson.fromJson((String)creativeInfo.getImpressionTracker(), List.class);
                            for (String tracker : trackerList) {
                                CS.log.v("TMS_SERVER", "onShow tracker -> " + tracker);
                                HttpTool.getTool().tracker(tracker);
                            }
                        }
                        TmsCreativeActionData creativeActionData = new TmsCreativeActionData();
                        creativeActionData.setAction(5);
                        creativeActionData.setSdkAppPkgName(pkgName);
                        creativeActionData.setCreativeId(creativeInfo.getCreativeIndex().getCreativeID());
                        Tracker.track(Tracker.TID.TMS_SDK_ACTION, creativeActionData.getBundle());
                    }
                }
            };
            TmsService.this.handleRunnable(r);
        }

        public void onClick(final int creativeID, final String pkgName) {
            CS.log.d("TMS_SERVER", "Server-> \u70b9\u51fbonClick\uff0c creativeId:" + creativeID + ", pkgName:" + pkgName);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!this.checkEnable(pkgName)) {
                        return;
                    }
                    CreativeInfo creativeInfo = DBManager.getInstance().getCreativeInfoById(creativeID);
                    if (creativeInfo != null) {
                        Intent intent;
                        if (1 == creativeInfo.getCreativeType()) {
                            AppDetailInfo appDetailInfo = DBManager.getInstance().getAppDetailInfobyAppId(String.valueOf(creativeInfo.getAppId()));
                            if (appDetailInfo != null) {
                                if (!PackageUtil.checkApkExist(TmsService.this.getApplicationContext(), appDetailInfo.getPkgName(), appDetailInfo.getVersionCode())) {
                                    this.toDownloadDetail(appDetailInfo, creativeID, pkgName);
                                } else {
                                    this.launchAppDetail(appDetailInfo);
                                }
                            }
                        } else if (2 == creativeInfo.getCreativeType() && (intent = ContantUtil.createIntent(TmsService.this.getApplicationContext(), creativeInfo.getDeepLink(), creativeInfo.getClickThroughUrl(), creativeInfo.getOpenBrowser(), SelfWebViewActivity.class)) != null) {
                            try {
                                intent.putExtra("cid", creativeInfo.getCreativeIndex().getCreativeID());
                                intent.putExtra("cv", creativeInfo.getCreativeIndex().getCreativeVersion());
                                TmsService.this.startActivity(intent);
                            }
                            catch (Exception e) {
                                CS.log.e("TMS_SERVER", e.toString());
                                try {
                                    intent = ContantUtil.createIntent(TmsService.this.getApplicationContext(), creativeInfo.getDeepLink(), creativeInfo.getClickThroughUrl(), "webView", SelfWebViewActivity.class);
                                    intent.putExtra("cid", creativeInfo.getCreativeIndex().getCreativeID());
                                    intent.putExtra("cv", creativeInfo.getCreativeIndex().getCreativeVersion());
                                    TmsService.this.startActivity(intent);
                                }
                                catch (Exception e2) {
                                    CS.log.e("TMS_SERVER", e2.toString());
                                }
                            }
                        }
                        DBManager.getInstance().increaseCreativeUsedFrequency(creativeID, 2);
                        if (!TextUtils.isEmpty((CharSequence)creativeInfo.getClickTracker())) {
                            List trackerList = (List)Tson.fromJson((String)creativeInfo.getClickTracker(), List.class);
                            for (String tracker : trackerList) {
                                CS.log.v("TMS_SERVER", "onClick tracker -> " + tracker);
                                HttpTool.getTool().tracker(tracker);
                            }
                        }
                        TmsCreativeActionData creativeActionData = new TmsCreativeActionData();
                        creativeActionData.setAction(6);
                        creativeActionData.setSdkAppPkgName(pkgName);
                        creativeActionData.setCreativeId(creativeInfo.getCreativeIndex().getCreativeID());
                        Tracker.track(Tracker.TID.TMS_SDK_ACTION, creativeActionData.getBundle());
                    } else {
                        try {
                            Intent intent = new Intent((Context)TmsService.this, AppUpdateActivity.class);
                            TmsService.this.startActivity(intent);
                        }
                        catch (Exception e) {
                            CS.log.e("TMS_SERVER", e.getLocalizedMessage());
                        }
                    }
                }
            };
            TmsService.this.handleRunnable(r);
        }

        public void reportData(final String pkgList, String data) {
            CS.log.d("TMS_SERVER", "------------------reportData--------------");
            if (!TextUtils.isEmpty((CharSequence)pkgList)) {
                CS.log.d("TMS_SERVER", "Server recent app usage info -> " + pkgList);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        String preStr = FileUtil.readRecordData("recent_app_usage_file", TmsService.this.getApplicationContext());
                        UsageAppCollection rstUsageAppCollection = new UsageAppCollection();
                        if (!TextUtils.isEmpty((CharSequence)preStr)) {
                            CS.log.d("TMS_SERVER", "pre str not null");
                            UsageAppCollection preUsageAppCollection = (UsageAppCollection)Tson.fromJson((String)preStr, UsageAppCollection.class);
                            rstUsageAppCollection.data.addAll(preUsageAppCollection.data);
                        }
                        UsageAppCollection currUsageAppCollection = (UsageAppCollection)Tson.fromJson((String)pkgList, UsageAppCollection.class);
                        currUsageAppCollection.filterPackageInfo();
                        rstUsageAppCollection.data.addAll(currUsageAppCollection.data);
                        String rstJson = Tson.toJson((Object)rstUsageAppCollection);
                        CS.log.d("TMS_SERVER", "final rst json --> " + rstJson);
                        FileUtil.saveRecordData("recent_app_usage_file", rstJson, TmsService.this.getApplicationContext());
                    }
                };
                TmsService.this.handleRunnable(r);
            }
        }

        private void toDownloadDetail(AppDetailInfo info, int creativeID, String mediaPkgName) {
            AppItem item = new AppItem();
            item.pkgName = info.getPkgName();
            item.appName = info.getTitle();
            item.appIconUrl = info.getIcon().getUrl();
            item.appVersionName = info.getVersionName();
            item.appVersionCode = info.getVersionCode();
            item.apkUrl = info.getDownloadUrl();
            item.apkPath = FileUtil.createApkDownloadPath(TmsService.this.getApplicationContext(), info.getDownloadUrl());
            item.apkSize = String.valueOf(info.getSize());
            item.allSize = (int)info.getSize();
            item.state = DownloadState.INITIAL.name();
            item.md5 = info.getMd5();
            item.type = PackageUtil.checkApkExist(TmsService.this.getApplicationContext(), info.getPkgName()) ? 1 : 2;
            item.appId = info.getAppId();
            item.description = info.getDescription();
            item.imgUrl = this.getImgUrl(info);
            item.isSilentInstall = true;
            item.creativeID = creativeID;
            item.mediaPkgName = mediaPkgName;
            AppDownLoadTask task = AppDownloadTaskManager.getInstance(TmsService.this.getApplicationContext()).queryByAppId(new AppDownLoadTask(), item.appId);
            if (null != task) {
                item.downloadSize = (int)task.finishedSize;
            }
            Intent intent = new Intent(TmsService.this.getApplicationContext(), AppUpdateDetailActivity.class);
            intent.setFlags(0x10000000);
            Bundle bundle = new Bundle();
            bundle.putParcelable("item_info", (Parcelable)item);
            bundle.putBoolean("from_tms_service", true);
            intent.putExtras(bundle);
            TmsService.this.startActivity(intent);
        }

        private String getImgUrl(AppDetailInfo info) {
            if (info == null || info.getImages() == null || info.getImages().size() <= 0) {
                return null;
            }
            return ((ImgInfo)info.getImages().get(0)).getUrl();
        }

        private void launchAppDetail(AppDetailInfo appDetailInfo) {
            PackageUtil.startApp((Context)TmsService.this, appDetailInfo.getPkgName());
        }
    };

    private void handleRunnable(Runnable r) {
        if (r == null) {
            return;
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            TranssionPoolManager.getInstance().addTask(r);
        } else {
            r.run();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        CS.log.d("TMS_SERVER", "Server-> \u5f00\u59cb onStartCommand ");
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        CS.log.d("TMS_SERVER", "Server->  onBind ...  ");
        final String sdkPkgName = intent.getStringExtra("package_name");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (null != sdkPkgName && !LimitCountUtil.isLimit((String)"TMS_BIND", (int)20, (int)1440)) {
                    TmsActionData tmsActionData = new TmsActionData();
                    tmsActionData.setAction(1);
                    tmsActionData.setSdkAppPkgName(sdkPkgName);
                    Tracker.track(Tracker.TID.TMS_SDK_ACTION, tmsActionData.getBundle());
                }
            }
        };
        this.handleRunnable(r);
        return this.tmsInterface;
    }

    public boolean onUnbind(Intent intent) {
        CS.log.d("TMS_SERVER", "Server-> \u89e3\u7ed1\u5b9a onUnbind ");
        String sdkPkgName = intent.getStringExtra("package_name");
        if (!LimitCountUtil.isLimit((String)"TMS_UNBIND", (int)20, (int)1440)) {
            TmsActionData tmsActionData = new TmsActionData();
            tmsActionData.setAction(2);
            tmsActionData.setSdkAppPkgName(sdkPkgName);
            Tracker.track(Tracker.TID.TMS_SDK_ACTION, tmsActionData.getBundle());
        }
        return super.onUnbind(intent);
    }
}

