/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main;

import android.content.Context;
import android.os.Build;
import android.support.v7.app.AppCompatDelegate;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.application.GlideApp;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.utils.StorageUtils;
import com.transsion.appupdate.utils.UpdateConstants;
import com.transsion.common.log.CS;

public class AppItemView
extends RelativeLayout {
    private ImageView mIconView;
    private ImageButton mStateBtn;
    private TextView mNameView;
    private ProgressBar mProgressBar;
    private TextView mDetailView;

    public AppItemView(Context context) {
        this(context, null);
    }

    public AppItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (Build.VERSION.SDK_INT >= 28 && AppCompatDelegate.getDefaultNightMode() == -1) {
            this.setBackgroundColor(this.getResources().getColor(R.color.colorPrimary, null));
        }
        this.setPaddingMinHeight();
        LayoutInflater.from((Context)context).inflate(R.layout.app_item_layout, (ViewGroup)this);
        this.initView();
    }

    private void setPaddingMinHeight() {
        int paddingTopBottom = this.getResources().getDimensionPixelSize(R.dimen.app_item_padding_top_bottom);
        this.setPadding(this.getResources().getDimensionPixelSize(R.dimen.app_item_padding_start), paddingTopBottom, this.getResources().getDimensionPixelSize(R.dimen.app_item_padding_end), paddingTopBottom);
        this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.app_item_min_height));
    }

    private void initView() {
        this.mIconView = (ImageView)this.findViewById(R.id.img_app_icon);
        this.mStateBtn = (ImageButton)this.findViewById(R.id.btn_app_action);
        this.mNameView = (TextView)this.findViewById(R.id.text_app_name);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progress_app_bar);
        this.mProgressBar.setMax(100);
        this.mDetailView = (TextView)this.findViewById(R.id.text_app_detail);
    }

    public ImageButton getStateBtn() {
        return this.mStateBtn;
    }

    public void bindView(AppItem item) {
        this.mNameView.setText((CharSequence)item.appName);
        GlideApp.with(this.getContext()).load(item.appIconUrl).placeholder(R.drawable.ic_application_vector).error(R.drawable.ic_application_vector).into(this.mIconView);
        this.setState(item);
    }

    public void setState(AppItem item) {
        CS.log.d("TMS_UPDATE", "setState:" + item.toString());
        if (UpdateConstants.STATE_INITIAL.equals(item.state)) {
            this.setInitial(item);
        } else if (UpdateConstants.STATE_WAITING.equals(item.state)) {
            this.setWaiting(item);
        } else if (UpdateConstants.STATE_DOWNLOADING.equals(item.state)) {
            this.setDownloading(item);
        } else if (UpdateConstants.STATE_PAUSED.equals(item.state)) {
            this.setPaused(item);
        } else if (!UpdateConstants.STATE_FINISHED.equals(item.state)) {
            if (UpdateConstants.STATE_INSTALLING.equals(item.state)) {
                this.setInstalling();
            } else if (UpdateConstants.STATE_INSTALLED.equals(item.state)) {
                this.setInstalled();
            } else if (UpdateConstants.STATE_FAILED.equals(item.state)) {
                this.setError(item);
            } else if (UpdateConstants.STATE_OPEN.equals(item.state)) {
                // empty if block
            }
        }
    }

    private void setVisibility(View view, boolean isVisibility) {
        if (view.getVisibility() == 0 != isVisibility) {
            view.setVisibility(isVisibility ? 0 : 8);
        }
    }

    private int getPercent(int downloadSize, int allSize) {
        if (allSize != 0) {
            return (int)((long)downloadSize * 100L / (long)allSize);
        }
        return 0;
    }

    private void setInitial(AppItem item) {
        this.setVisibility((View)this.mProgressBar, false);
        this.setVisibility((View)this.mStateBtn, true);
        this.setProgressAndBtnState(true);
        this.mDetailView.setText((CharSequence)this.getContext().getString(R.string.new_version, new Object[]{item.appVersionName, StorageUtils.convertFromByte(item.allSize)}));
        this.mStateBtn.setImageResource(R.drawable.ic_install_vector);
    }

    private void setWaiting(AppItem item) {
        this.setVisibility((View)this.mProgressBar, true);
        this.setVisibility((View)this.mStateBtn, true);
        this.setProgressAndBtnState(true);
        this.mDetailView.setText((CharSequence)this.getContext().getString(R.string.waiting));
        this.mProgressBar.setProgress(this.getPercent(item.downloadSize, item.allSize));
        this.mStateBtn.setImageResource(R.drawable.ic_waiting_vector);
    }

    private void setDownloading(AppItem item) {
        this.setVisibility((View)this.mProgressBar, true);
        this.setVisibility((View)this.mStateBtn, true);
        this.setProgressAndBtnState(true);
        String progressInfo = StorageUtils.convertFromByte(item.downloadSize) + "/" + StorageUtils.convertFromByte(item.allSize);
        this.mDetailView.setText((CharSequence)progressInfo);
        this.mProgressBar.setProgress(this.getPercent(item.downloadSize, item.allSize));
        this.mStateBtn.setImageResource(R.drawable.ic_pause_vector);
    }

    private void setPaused(AppItem item) {
        this.setVisibility((View)this.mProgressBar, true);
        this.setVisibility((View)this.mStateBtn, true);
        this.setProgressAndBtnState(true);
        this.mDetailView.setText((CharSequence)this.getContext().getString(R.string.paused));
        this.mProgressBar.setProgress(this.getPercent(item.downloadSize, item.allSize));
        this.mStateBtn.setImageResource(R.drawable.ic_install_vector);
    }

    private void setInstalling() {
        this.setVisibility((View)this.mProgressBar, true);
        this.setVisibility((View)this.mStateBtn, true);
        this.setProgressAndBtnState(false);
        this.mDetailView.setText((CharSequence)this.getContext().getString(R.string.installing));
        this.mStateBtn.setImageResource(R.drawable.ic_pause_vector);
    }

    private void setInstalled() {
        this.setVisibility((View)this.mProgressBar, false);
        this.setVisibility((View)this.mStateBtn, false);
        this.mDetailView.setText((CharSequence)this.getContext().getString(R.string.success));
    }

    private void setError(AppItem item) {
        this.setVisibility((View)this.mProgressBar, true);
        this.setVisibility((View)this.mStateBtn, true);
        this.setProgressAndBtnState(true);
        this.mDetailView.setText((CharSequence)this.getErrorText(item.errorType));
        this.mProgressBar.setProgress(this.getPercent(item.downloadSize, item.allSize));
        this.mStateBtn.setImageResource(R.drawable.ic_install_vector);
    }

    private String getErrorText(int errorType) {
        String errorStr = this.getContext().getString(R.string.download_fail);
        switch (errorType) {
            case 1: {
                return this.getContext().getString(R.string.network_error);
            }
            case 2: {
                return this.getContext().getString(R.string.lack_space);
            }
            case 3: {
                return this.getContext().getString(R.string.download_fail);
            }
            case 4: {
                return this.getContext().getString(R.string.install_fail);
            }
        }
        return errorStr;
    }

    private void setProgressAndBtnState(boolean isAble) {
        if (isAble) {
            this.mStateBtn.setAlpha(1.0f);
            this.mStateBtn.setEnabled(true);
            this.mProgressBar.setIndeterminate(false);
        } else {
            this.mStateBtn.setAlpha(0.3f);
            this.mStateBtn.setEnabled(false);
            this.mProgressBar.setIndeterminate(true);
        }
    }
}

