/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.transsion.appupdate.R;
import com.transsion.appupdate.entity.AppItem;
import com.transsion.appupdate.entity.InfoItem;
import com.transsion.appupdate.entity.ListItem;
import com.transsion.appupdate.ui.main.AppItemView;
import com.transsion.appupdate.ui.main.viewholder.AppViewHolder;
import com.transsion.appupdate.ui.main.viewholder.BaseViewHolder;
import com.transsion.appupdate.ui.main.viewholder.InfoViewHolder;
import java.util.ArrayList;
import java.util.List;

public class AppUpdateAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private ArrayList<ListItem> mList;
    private final int VIEWTYPE_APP = 1;
    private final int VIEWTYPE_INFO = 2;
    private LayoutInflater mInflater;
    private OnDownloadListener mDownListener;
    private OnUpdateAllClickListener mUpdateAllListener;

    public AppUpdateAdapter(ArrayList<ListItem> list, LayoutInflater inflater, OnDownloadListener downListener, OnUpdateAllClickListener updateAllListener) {
        this.mList = list;
        this.mInflater = inflater;
        this.mDownListener = downListener;
        this.mUpdateAllListener = updateAllListener;
    }

    public int getItemViewType(int position) {
        if (this.mList == null) {
            throw new NullPointerException("Items datasource is null!");
        }
        if (this.mList.get(position) instanceof AppItem) {
            return 1;
        }
        return 2;
    }

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return new AppViewHolder((View)new AppItemView(parent.getContext()));
        }
        return new InfoViewHolder(this.mInflater.inflate(R.layout.info_item_layout, parent, false));
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        if (holder instanceof AppViewHolder) {
            holder.bindView(position, (AppItem)this.mList.get(position), this.mDownListener);
        } else if (holder instanceof InfoViewHolder) {
            holder.bindView((InfoItem)this.mList.get(position), this.mUpdateAllListener);
        }
    }

    public void onBindViewHolder(BaseViewHolder holder, int position, List payloads) {
        this.onBindViewHolder(holder, position);
        if (payloads.isEmpty()) {
            return;
        }
        int type = (Integer)payloads.get(0);
        switch (type) {
            case 1: {
                holder.changeOptText((InfoItem)this.mList.get(position));
                break;
            }
            case 2: {
                holder.changeCountText((InfoItem)this.mList.get(position));
                break;
            }
            case 3: {
                holder.changeState((AppItem)this.mList.get(position));
                break;
            }
        }
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public void updateList(ArrayList<ListItem> list) {
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public static interface OnUpdateAllClickListener {
        public void onUpdateAll(boolean var1);
    }

    public static interface OnDownloadListener {
        public void onDownload(int var1, AppItem var2);
    }
}

