/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.ui.main.viewholder;

import android.view.View;
import android.widget.TextView;
import com.transsion.appupdate.R;
import com.transsion.appupdate.entity.InfoItem;
import com.transsion.appupdate.ui.main.AppUpdateAdapter;
import com.transsion.appupdate.ui.main.viewholder.BaseViewHolder;

public class InfoViewHolder
extends BaseViewHolder {
    private TextView mTextCount;
    private TextView mTextOptAll;

    public InfoViewHolder(View itemView) {
        super(itemView);
        this.mTextCount = (TextView)itemView.findViewById(R.id.text_count);
        this.mTextOptAll = (TextView)itemView.findViewById(R.id.text_opt_all);
    }

    @Override
    public void bindView(InfoItem item, AppUpdateAdapter.OnUpdateAllClickListener listener) {
        this.changeCountText(item);
        if (item.showUpdate) {
            this.mTextOptAll.setVisibility(0);
            this.mTextOptAll.setText(item.isUpdate ? R.string.cancel_all : R.string.update_all);
            this.mTextOptAll.setOnClickListener(v -> {
                if (listener != null) {
                    listener.onUpdateAll(!item.isUpdate);
                }
            });
        } else {
            this.mTextOptAll.setVisibility(8);
        }
    }

    @Override
    public void changeOptText(InfoItem item) {
        if (item.showUpdate) {
            this.mTextOptAll.setText(item.isUpdate ? R.string.cancel_all : R.string.update_all);
        }
    }

    @Override
    public void changeCountText(InfoItem item) {
        int count;
        int n = count = item.count < 0 ? 0 : item.count;
        String countText = item.showUpdate ? this.itemView.getContext().getString(count <= 1 ? R.string.update_info : R.string.update_info_s, new Object[]{count}) : this.itemView.getContext().getString(count <= 1 ? R.string.recommend_info : R.string.recommend_info_s, new Object[]{count});
        this.mTextCount.setText((CharSequence)countText);
    }
}

