/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

public class Base64Codec {
    private static final int MASK_2BITS = 3;
    private static final int MASK_4BITS = 15;
    private static final int MASK_6BITS = 63;
    private static final byte PAD = 61;
    private final byte[] alphabets = this.toBytesDirect("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");

    public static String encodeAsString(byte[] digest) {
        byte[] bytes = new Base64Codec().encode(digest);
        char[] dest = new char[bytes.length];
        int i = 0;
        for (byte b : bytes) {
            dest[i++] = (char)b;
        }
        return new String(dest);
    }

    private byte[] toBytesDirect(String singleOctets) {
        char[] src = singleOctets.toCharArray();
        byte[] dest = new byte[src.length];
        for (int i = 0; i < dest.length; ++i) {
            char c = src[i];
            if (c > '\u007f') {
                throw new IllegalArgumentException("Invalid character found at position " + i + " for " + singleOctets);
            }
            dest[i] = (byte)c;
        }
        return dest;
    }

    private byte[] encode(byte[] src) {
        int num3bytes = src.length / 3;
        int remainder = src.length % 3;
        if (remainder == 0) {
            byte[] dest = new byte[num3bytes * 4];
            int s = 0;
            int d = 0;
            while (s < src.length) {
                this.encode3bytes(src, s, dest, d);
                s += 3;
                d += 4;
            }
            return dest;
        }
        byte[] dest = new byte[(num3bytes + 1) * 4];
        int s = 0;
        int d = 0;
        while (s < src.length - remainder) {
            this.encode3bytes(src, s, dest, d);
            s += 3;
            d += 4;
        }
        switch (remainder) {
            case 1: {
                this.encode1byte(src, s, dest, d);
                break;
            }
            case 2: {
                this.encode2bytes(src, s, dest, d);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return dest;
    }

    private void encode3bytes(byte[] src, int s, byte[] dest, int d) {
        int n = d++;
        byte p = src[s++];
        dest[n] = this.alphabets[p >>> 2 & 0x3F];
        int n2 = d++;
        int n3 = (p & 3) << 4;
        p = src[s++];
        dest[n2] = this.alphabets[n3 | p >>> 4 & 0xF];
        int n4 = d++;
        int n5 = (p & 0xF) << 2;
        p = src[s];
        dest[n4] = this.alphabets[n5 | p >>> 6 & 3];
        dest[d] = this.alphabets[p & 0x3F];
    }

    private void encode2bytes(byte[] src, int s, byte[] dest, int d) {
        int n = d++;
        byte p = src[s++];
        dest[n] = this.alphabets[p >>> 2 & 0x3F];
        int n2 = d++;
        int n3 = (p & 3) << 4;
        p = src[s];
        dest[n2] = this.alphabets[n3 | p >>> 4 & 0xF];
        dest[d++] = this.alphabets[(p & 0xF) << 2];
        dest[d] = 61;
    }

    private void encode1byte(byte[] src, int s, byte[] dest, int d) {
        int n = d++;
        byte p = src[s];
        dest[n] = this.alphabets[p >>> 2 & 0x3F];
        dest[d++] = this.alphabets[(p & 3) << 4];
        dest[d++] = 61;
        dest[d] = 61;
    }
}

