/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.content.FileProvider;
import com.transsion.core.log.LogUtils;
import java.io.File;

public class FileProviderUtil {
    public static Uri getUriByFile(Context context, @NonNull File file) {
        Uri uri = null;
        if (file != null && file.exists()) {
            uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
        } else {
            LogUtils.e((String)"TMS_SERVER", (Object[])new Object[]{"file is not exists"});
        }
        return uri;
    }

    public static String getUriByPath(Context context, @NonNull String filePath) {
        File file = new File(filePath);
        Uri uri = FileProviderUtil.getUriByFile(context, file);
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public static void grantUriPermission(Context context, Uri uri, String targetPackageName) {
        context.grantUriPermission(targetPackageName, uri, 1);
    }
}

