/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.os.AsyncTask;
import android.os.Looper;
import android.text.TextUtils;
import com.android.internal.content.PackageHelper;
import com.transsion.appupdate.utils.PackageUtil;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class InstallUtil {
    public static final int IGNORE_REQUEST_CODE = 1;
    private static int REQUEST_CODE = 2;

    private static Object getFieldValue(Object obj, Class<?> c, String name) throws Throwable {
        Field f = c.getField(name);
        return f.get(obj);
    }

    public static boolean pmInstall(Context ctx, String apkPath) {
        return InstallUtil.pmInstall(ctx, apkPath, null);
    }

    public static boolean tryInstall(String apkPath) {
        for (int i = 0; i < 3; ++i) {
            if (!InstallUtil.pmInstall(CoreUtil.getContext(), apkPath)) continue;
            return true;
        }
        return false;
    }

    public static void tryInstall(String apkPath, final InstallCallback callback) {
        if (Looper.getMainLooper() == Looper.myLooper()) {
            new AsyncTask<String, Void, Boolean>(){

                protected Boolean doInBackground(String ... strings) {
                    return InstallUtil.pmInstall(CoreUtil.getContext(), strings[0]);
                }

                protected void onPostExecute(Boolean aBoolean) {
                    super.onPostExecute((Object)aBoolean);
                    if (callback != null) {
                        callback.onResult(aBoolean);
                    }
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new String[]{apkPath});
            return;
        }
        boolean result = InstallUtil.pmInstall(CoreUtil.getContext(), apkPath);
        if (callback != null) {
            callback.onResult(result);
        }
    }

    private static synchronized boolean pmInstall(Context ctx, String apkPath, Intent intent) {
        boolean result = true;
        PackageInstaller.Session session = null;
        PackageManager pm = ctx.getPackageManager();
        PackageInstaller installer = pm.getPackageInstaller();
        int sessionId = 0;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new RuntimeException("func must not run in main thread");
        }
        try {
            File file = new File(apkPath);
            if (!file.exists()) {
                return false;
            }
            PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(1);
            Field f = PackageInstaller.SessionParams.class.getField("installFlags");
            int INSTALL_FULL_APP = 0;
            try {
                INSTALL_FULL_APP = (Integer)InstallUtil.getFieldValue(null, PackageManager.class, "INSTALL_FULL_APP");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int INSTALL_REPLACE_EXISTING = (Integer)InstallUtil.getFieldValue(null, PackageManager.class, "INSTALL_REPLACE_EXISTING");
            f.set(params, INSTALL_FULL_APP | INSTALL_REPLACE_EXISTING);
            String pkgName = null;
            try {
                PackageParser.PackageLite pkg = PackageParser.parsePackageLite((File)file, (int)0);
                params.setAppPackageName(pkg.packageName);
                pkgName = pkg.packageName;
                params.setInstallLocation(pkg.installLocation);
                params.setSize(PackageHelper.calculateInstalledSize((PackageParser.PackageLite)pkg, (boolean)false, (String)((String)InstallUtil.getFieldValue(params, PackageInstaller.SessionParams.class, "abiOverride"))));
            }
            catch (Exception e) {
                params.setSize(file.length());
            }
            if (intent != null && TextUtils.isEmpty(pkgName)) {
                return false;
            }
            sessionId = installer.createSession(params);
            session = installer.openSession(sessionId);
            try (FileInputStream in = new FileInputStream(file);){
                long sizeBytes = file.length();
                try (OutputStream out = session.openWrite("PackageInstaller", 0L, sizeBytes);){
                    byte[] buffer = new byte[0x100000];
                    while (true) {
                        int numRead;
                        if ((numRead = ((InputStream)in).read(buffer)) == -1) {
                            session.fsync(out);
                            break;
                        }
                        out.write(buffer, 0, numRead);
                    }
                }
            }
            int requestCode = 1;
            if (intent == null) {
                intent = new Intent("com.transsion.appupdate.ACTION_INSTALL_COMMIT");
            } else {
                intent.putExtra("pkg_name", pkgName);
                requestCode = REQUEST_CODE++;
            }
            intent.setFlags(0x10000000);
            intent.setPackage(ctx.getPackageName());
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)ctx, (int)requestCode, (Intent)intent, (int)0x8000000);
            session.commit(pendingIntent.getIntentSender());
        }
        catch (Throwable e) {
            if (session != null) {
                session.close();
            }
            if (sessionId != 0) {
                installer.abandonSession(sessionId);
            }
            result = false;
        }
        return result;
    }

    public static boolean pmuninstall(Context ctx, String pkg) {
        CS.log.d("TMS_SERVER", "pkg:" + pkg + ", \u662f\u5426\u5b58\u5728\uff1a" + PackageUtil.checkApkExist(ctx, pkg));
        boolean result = true;
        PackageManager pm = ctx.getPackageManager();
        try {
            Class<?> pmClass = Class.forName(pm.getClass().getName());
            Method method = pmClass.getMethod("deletePackage", String.class, IPackageDeleteObserver.class, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)pm, pkg, null, (Integer)InstallUtil.getFieldValue(null, PackageManager.class, "DELETE_ALL_USERS"));
        }
        catch (Throwable e) {
            e.printStackTrace();
            CS.log.d("TMS_SERVER", "packageDeleted e:" + e.getMessage());
            return true;
        }
        return result;
    }

    public static interface InstallCallback {
        public void onResult(boolean var1);
    }
}

