/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.transsion.appupdate.ui.main.AppUpdateActivity;

public class NotifyUtils {
    public static void sendNormalNotification(Context context, String title, String text, int notificationId) {
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, AppUpdateActivity.class);
        intent.putExtra("enterType", "notification");
        intent.addFlags(0x10000000);
        NotifyUtils.sendIntentNotification(context, title, text, notificationId, intent);
    }

    public static void sendIntentNotification(Context context, String title, String text, int notificationId, Intent intent) {
        Notification.Builder builder;
        if (context == null) {
            return;
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (nm == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = "appUpdate";
            String channelName = "appUpdate";
            NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, 2);
            notificationChannel.enableVibration(false);
            nm.createNotificationChannel(notificationChannel);
            builder = new Notification.Builder(context, channelId).setSmallIcon(17301589).setContentIntent(pendingIntent).setChannelId(channelId).setGroup("appUpdate").setAutoCancel(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text);
        } else {
            builder = new Notification.Builder(context).setSmallIcon(17301589).setContentIntent(pendingIntent).setGroup("appUpdate").setAutoCancel(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text);
        }
        nm.notify(notificationId, builder.build());
    }

    public static void sendBigTextNotification(Context context, String title, String text, int notificationId) {
        Notification.Builder builder;
        if (context == null) {
            return;
        }
        Intent intent = new Intent(context, AppUpdateActivity.class);
        intent.putExtra("enterType", "notification");
        intent.addFlags(0x10000000);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (nm == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = "appUpdate";
            String channelName = "appUpdate";
            NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, 2);
            notificationChannel.enableVibration(false);
            nm.createNotificationChannel(notificationChannel);
            builder = new Notification.Builder(context, channelId).setSmallIcon(17301589).setContentIntent(pendingIntent).setChannelId(channelId).setGroup("appUpdate").setAutoCancel(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)text));
        } else {
            builder = new Notification.Builder(context).setSmallIcon(17301589).setContentIntent(pendingIntent).setGroup("appUpdate").setAutoCancel(true).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)text));
        }
        nm.notify(notificationId, builder.build());
    }

    public static void cancelNotification(Context context, int notificationId) {
        if (context == null) {
            return;
        }
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        if (nm == null) {
            return;
        }
        nm.cancel(notificationId);
    }
}

