/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.app.ActivityManager;
import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.appupdate.utils.GzipUtil;
import com.transsion.common.bean.AppInfo;
import com.transsion.common.log.CS;
import com.transsion.core.CoreUtil;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class PackageUtil {
    public static final int REMOVE_TASK_KILL_PROCESS = 1;
    public static final int MOVE_TASK_WITH_HOME = 1;

    private static boolean isBuildinApp(Context context, String packageName) {
        try {
            PackageManager pm = context.getPackageManager();
            ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
            if (info != null) {
                return (info.flags & 1) != 0 || (info.flags & 0x80) != 0;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static String getSignWrap(Context context, String packageName) {
        if (packageName.contains("|")) {
            return GzipUtil.stringToMD5(GzipUtil.stringToMD5(packageName.substring(packageName.indexOf("|") + 1)));
        }
        if (PackageUtil.isBuildinApp(context, packageName)) {
            return GzipUtil.stringToMD5(GzipUtil.stringToMD5(packageName));
        }
        return PackageUtil.getSignature_SHA1(context, packageName);
    }

    public static String getPackageName(String packageName) {
        if (packageName.contains("|")) {
            return packageName.substring(0, packageName.lastIndexOf("|"));
        }
        return packageName;
    }

    public static String getSignature_SHA1(Context context, String packageName) {
        StringBuilder builder = new StringBuilder();
        Signature[] signs = PackageUtil.getSignatures(context, packageName);
        if (signs == null) {
            return "";
        }
        for (Signature sig : signs) {
            String tmp = null;
            tmp = PackageUtil.getSignatureString(sig, "SHA1");
            builder.append(tmp);
        }
        return builder.toString();
    }

    private static String getSignatureString(Signature sig, String type) {
        byte[] hexBytes = sig.toByteArray();
        String fingerprint = "";
        try {
            MessageDigest digest = MessageDigest.getInstance(type);
            if (digest != null) {
                byte[] digestBytes = digest.digest(hexBytes);
                StringBuilder sb = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    sb.append(Integer.toHexString(digestByte & 0xFF | 0x100).substring(1, 3));
                }
                fingerprint = sb.toString();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return fingerprint;
    }

    private static Signature[] getSignatures(Context context, String packageName) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
            return packageInfo.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPkgNameByAPKFile(Context mContext, String filePath) {
        String pkgName;
        try {
            PackageManager packageManager = mContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(filePath, 1);
            pkgName = packageInfo.packageName;
        }
        catch (Exception e) {
            pkgName = null;
        }
        return pkgName;
    }

    public static PackageInfo getPackageInfo(Context context, String pkgName) {
        try {
            return context.getPackageManager().getPackageInfo(pkgName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppName(Context context, String packageName) {
        String appName = "";
        try {
            PackageManager manager = context.getPackageManager();
            if (manager != null) {
                PackageInfo packageInfo = manager.getPackageInfo(packageName, 0);
                appName = packageInfo.applicationInfo.loadLabel(manager).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appName;
    }

    public static String getVersionName(Context appContext) {
        PackageManager packageManager = appContext.getPackageManager();
        String versionName = "";
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(appContext.getPackageName(), 0);
            versionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static int getVersionCode(Context appContext) {
        PackageManager packageManager = appContext.getPackageManager();
        int versionCode = 0;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(appContext.getPackageName(), 0);
            versionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    public static Drawable getAppIcon(Context context, String packageName) {
        Drawable appIcon = null;
        try {
            PackageManager manager = context.getPackageManager();
            if (manager != null) {
                PackageInfo packageInfo = manager.getPackageInfo(packageName, 0);
                appIcon = packageInfo.applicationInfo.loadIcon(manager);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appIcon;
    }

    public static List<AppInfo> initAppList(Context context) {
        ArrayList<AppInfo> appInfoList = new ArrayList<AppInfo>();
        try {
            List packageInfoList = context.getPackageManager().getInstalledPackages(0);
            if (packageInfoList != null) {
                for (PackageInfo info : packageInfoList) {
                    if (info.packageName.contains("keyboard") || info.packageName.contains("inputmethod") || info.packageName.contains("com.mediatek") || info.packageName.contains("com.google") || TextUtils.isEmpty((CharSequence)info.packageName)) continue;
                    AppInfo appInfo = new AppInfo(info.packageName, info.versionName, info.versionCode);
                    appInfoList.add(appInfo);
                }
            }
        }
        catch (Exception e) {
            appInfoList = null;
            e.printStackTrace();
        }
        return appInfoList;
    }

    public static boolean checkApkExist(Context context, String packageName, int minCode) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (packageInfo != null) {
            int code = packageInfo.versionCode;
            return code >= minCode;
        }
        return false;
    }

    public static boolean checkApkUpdate(Context context, String packageName, int minCode) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            if (null == packageInfo) {
                return false;
            }
            int code = packageInfo.versionCode;
            return code < minCode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean checkApkExist(Context context, String packageName) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return packageInfo != null;
    }

    public static boolean checkApkExist(Context context, String packageName, String version) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (packageInfo != null) {
            String versionName = packageInfo.versionName;
            return versionName.equals(version);
        }
        return false;
    }

    public static void startApp(Context context, String pkgName) {
        if (!TextUtils.isEmpty((CharSequence)pkgName)) {
            try {
                Intent intent = context.getPackageManager().getLaunchIntentForPackage(pkgName);
                context.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void startRecent() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Instrumentation inst = new Instrumentation();
                inst.sendKeyDownUpSync(187);
            }
        }).start();
    }

    public static void killApp(Context context, String pkgName) {
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return;
        }
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            List recentTasks = am.getRecentTasks(5, 1);
            for (ActivityManager.RecentTaskInfo rt : recentTasks) {
                if (am == null) continue;
                String pkg = "";
                if (rt.baseIntent != null) {
                    pkg = rt.baseIntent.getComponent().getPackageName();
                }
                CS.log.d("recent", "killApp: list---" + pkg);
                if (!pkgName.equals(pkg)) continue;
                if (Build.VERSION.SDK_INT < 21) {
                    Method clearAll = am.getClass().getMethod("removeTask", Integer.TYPE, Integer.TYPE);
                    clearAll.setAccessible(true);
                    clearAll.invoke((Object)am, rt.persistentId, 1);
                } else {
                    Method clearAll = am.getClass().getMethod("removeTask", Integer.TYPE);
                    clearAll.setAccessible(true);
                    clearAll.invoke((Object)am, rt.persistentId);
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TopActivityInfo getTopActivityInfo() {
        ActivityManager manager = (ActivityManager)CoreUtil.getContext().getSystemService("activity");
        TopActivityInfo info = new TopActivityInfo();
        if (Build.VERSION.SDK_INT >= 21) {
            List pis = manager.getRunningAppProcesses();
            ActivityManager.RunningAppProcessInfo topAppProcess = (ActivityManager.RunningAppProcessInfo)pis.get(0);
            if (topAppProcess != null && topAppProcess.importance == 100) {
                info.packageName = topAppProcess.processName;
                info.topActivityName = "";
            }
        } else {
            List localList = manager.getRunningTasks(1);
            ActivityManager.RunningTaskInfo localRunningTaskInfo = (ActivityManager.RunningTaskInfo)localList.get(0);
            info.packageName = localRunningTaskInfo.topActivity.getPackageName();
            info.topActivityName = localRunningTaskInfo.topActivity.getClassName();
        }
        return info;
    }

    public static String getSelfPackageName(Context context) {
        String pkgName = null;
        try {
            if (context == null) {
                context = CoreUtil.getContext();
            }
            if (context != null) {
                pkgName = context.getPackageName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pkgName;
    }

    public static class TopActivityInfo {
        public String packageName = "";
        public String topActivityName = "";
    }
}

