/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.appupdate.utils;

import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Build;
import android.os.PowerManager;
import android.support.v7.app.AppCompatDelegate;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.transsion.appupdate.R;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;

public class PhoneUtil {
    private static final String CUSTOM_BUILD_VERSION_PROPERTY = "ro.mediatek.version.release";

    public static boolean isScreenOn(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        boolean isScreenOn = Build.VERSION.SDK_INT >= 20 ? powerManager.isInteractive() : powerManager.isScreenOn();
        return isScreenOn;
    }

    public static boolean isCalling(Context context) {
        boolean calling = false;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (2 == telephonyManager.getCallState() || 1 == telephonyManager.getCallState()) {
            calling = true;
        }
        return calling;
    }

    public static boolean isScreenLock(Context context) {
        KeyguardManager mKeyguard = (KeyguardManager)context.getSystemService("keyguard");
        return mKeyguard != null ? mKeyguard.isKeyguardLocked() : false;
    }

    public static String getTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        if (null != tz) {
            return tz.getDisplayName(false, 0);
        }
        return "";
    }

    public static String getLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public static String getPlatform() {
        return "AndroidPhone";
    }

    public static String getScreenSize(Context context) {
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getRealMetrics(dm);
        return dm.heightPixels + "x" + dm.widthPixels;
    }

    public static String[] getLaunchInfo(Context context) {
        String[] launchInfo = new String[2];
        try {
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.HOME");
            ResolveInfo res = context.getPackageManager().resolveActivity(intent, 0);
            if (null != res && null != res.activityInfo && null != res.activityInfo.packageName && !TextUtils.equals((CharSequence)"android", (CharSequence)res.activityInfo.packageName)) {
                launchInfo[0] = res.activityInfo.packageName;
                launchInfo[1] = context.getPackageManager().getPackageInfo((String)launchInfo[0], (int)0).versionName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return launchInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCid(Context context) {
        int cid = -1;
        TelephonyManager telephonyManager = null;
        try {
            telephonyManager = (TelephonyManager)context.getSystemService("phone");
            GsmCellLocation location = (GsmCellLocation)telephonyManager.getCellLocation();
            cid = location.getCid();
        }
        catch (Exception location_cdma) {
        }
        finally {
            if (cid == -1) {
                try {
                    CdmaCellLocation location_cdma = (CdmaCellLocation)telephonyManager.getCellLocation();
                    cid = location_cdma.getBaseStationId();
                }
                catch (Exception location_cdma) {}
            }
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLac(Context context) {
        int lac = -1;
        TelephonyManager telephonyManager = null;
        try {
            telephonyManager = (TelephonyManager)context.getSystemService("phone");
            GsmCellLocation location = (GsmCellLocation)telephonyManager.getCellLocation();
            lac = location.getLac();
        }
        catch (Exception location_cdma) {
        }
        finally {
            if (lac == -1) {
                try {
                    CdmaCellLocation location_cdma = (CdmaCellLocation)telephonyManager.getCellLocation();
                    lac = location_cdma.getNetworkId();
                }
                catch (Exception location_cdma) {}
            }
        }
        return lac;
    }

    public static String getBuildVersion() {
        String value = null;
        try {
            Class<?> c = Class.forName("android.os.SystemProperties");
            Method get = c.getMethod("get", String.class, String.class);
            value = (String)get.invoke(c, CUSTOM_BUILD_VERSION_PROPERTY, "");
        }
        catch (Exception e) {
            value = null;
            e.printStackTrace();
        }
        finally {
            if (null == value || value.isEmpty()) {
                value = Build.DISPLAY;
            }
        }
        return value;
    }

    public static void setStatusBarAndNavigation(Activity activity, boolean transparent) {
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 28 && AppCompatDelegate.getDefaultNightMode() == -1) {
            View decorView = window.getDecorView();
            window.setStatusBarColor(transparent ? 0 : activity.getResources().getColor(R.color.status_bar_color, null));
            window.setNavigationBarColor(transparent ? 0 : activity.getResources().getColor(R.color.navigation_bar_color, null));
        }
    }
}

