/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslibs.widgets;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.transsion.appupdate.R;

public class FootOptBar
extends FrameLayout {
    private static final float ONE_BUTTON_WIDTH = 0.3f;
    private static final float TWO_BUTTON_WIDTH = 0.7f;
    private static final float THREE_BUTTON_WIDTH = 0.8f;
    private int mScreenWidth;
    private LinearLayout mContainer;
    private OnFootItemClickListener mItemClickListener;

    public FootOptBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setBackgroundResource(R.drawable.foot_opt_background);
        this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.foot_opt_min_height));
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        LayoutInflater.from((Context)context).inflate(R.layout.foot_opt_root_layout, (ViewGroup)this);
        this.mContainer = (LinearLayout)this.findViewById(R.id.foot_opt_container);
    }

    public void addItemViews(int[] imgIds, int[] titleIds) {
        this.mContainer.removeAllViews();
        int count = imgIds.length;
        this.setContainerWidth(count);
        int i = 0;
        while (i < count) {
            View itemView = this.addItemView(imgIds[i], titleIds[i]);
            int index = i++;
            itemView.setOnClickListener(v -> {
                if (this.mItemClickListener != null) {
                    this.mItemClickListener.onItemClick(index);
                }
            });
            this.mContainer.addView(itemView);
        }
    }

    private View addItemView(int imgId, int strId) {
        View itemRoot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.foot_opt_item_layout, (ViewGroup)this.mContainer, false);
        ImageView icon = (ImageView)itemRoot.findViewById(R.id.foot_opt_item_icon);
        TextView text = (TextView)itemRoot.findViewById(R.id.foot_opt_item_text);
        if (imgId != 0) {
            icon.setImageResource(imgId);
        }
        if (strId != 0) {
            text.setText((CharSequence)this.getResources().getString(strId));
        }
        return itemRoot;
    }

    private void setContainerWidth(int count) {
        int width;
        switch (count) {
            case 1: {
                width = (int)((float)this.mScreenWidth * 0.3f);
                break;
            }
            case 2: {
                width = (int)((float)this.mScreenWidth * 0.7f);
                break;
            }
            case 3: {
                width = (int)((float)this.mScreenWidth * 0.8f);
                break;
            }
            default: {
                width = -1;
            }
        }
        ViewGroup.LayoutParams lp = this.mContainer.getLayoutParams();
        lp.width = width;
        this.mContainer.setLayoutParams(lp);
    }

    public void changeItemsEnable(boolean[] enables) {
        for (int i = 0; i < enables.length; ++i) {
            this.changeItemEnable(i, enables[i]);
        }
    }

    public void changeItemEnable(int position, boolean enable) {
        this.viewEnable(this.mContainer.getChildAt(position), enable);
    }

    private void viewEnable(View view, boolean enable) {
        view.setEnabled(enable);
        view.setAlpha(enable ? 1.0f : 0.3f);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.updateFootBarView();
    }

    public void updateFootBarView() {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.setContainerWidth(this.mContainer.getChildCount());
    }

    public void setOnFootItemClickListener(OnFootItemClickListener l) {
        this.mItemClickListener = l;
    }

    public static interface OnFootItemClickListener {
        public void onItemClick(int var1);
    }
}

