/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.bean.ImgInfo;
import com.transsion.newphonerecommend.database.DBData;
import com.transsion.newphonerecommend.database.DBHelper;
import com.transsion.newphonerecommend.log.CS;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class DBManager {
    private static volatile DBManager sInstance;
    private DBHelper mHelper;
    private SQLiteDatabase mDB;

    private DBManager(Context context) {
        this.mHelper = new DBHelper(context);
        this.mDB = this.mHelper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<DBManager> clazz = DBManager.class;
        synchronized (DBManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DBManager(CoreUtil.getContext());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private synchronized void closeDB() {
        if (this.mDB != null) {
            this.mDB.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveOrUpdateAppDetailList(List<AppDetailInfo> appDetailInfoList) {
        if (appDetailInfoList != null && appDetailInfoList.size() > 0 && this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                for (AppDetailInfo appDetailInfo : appDetailInfoList) {
                    if (appDetailInfo == null || appDetailInfo.getAppId() <= 0 || TextUtils.isEmpty((CharSequence)appDetailInfo.getPkgName()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getDownloadUrl()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getMd5()) || TextUtils.isEmpty((CharSequence)appDetailInfo.getTitle()) || appDetailInfo.getIcon() == null) continue;
                    ContentValues values = new ContentValues();
                    values.put("app_id", Integer.valueOf(appDetailInfo.getAppId()));
                    values.put("title", appDetailInfo.getTitle());
                    values.put("desc_version", Integer.valueOf(appDetailInfo.getDescVersion()));
                    values.put("sub_desc", appDetailInfo.getSubDescription());
                    values.put("desc", appDetailInfo.getDescription());
                    values.put("icon", Tson.toJson((Object)appDetailInfo.getIcon()));
                    try {
                        values.put("screenshots", Tson.toJson(appDetailInfo.getApkScreenshotImgList()));
                    }
                    catch (Exception e) {
                        CS.log.e("Recommend", e.getMessage());
                    }
                    try {
                        values.put("images", Tson.toJson(appDetailInfo.getImages()));
                    }
                    catch (Exception e) {
                        CS.log.e("Recommend", e.getMessage());
                    }
                    values.put("category", Integer.valueOf(appDetailInfo.getCategory()));
                    values.put("website", appDetailInfo.getWebsite());
                    values.put("email", appDetailInfo.getEmail());
                    values.put("phone", appDetailInfo.getPhone());
                    values.put("policy", appDetailInfo.getPolicy());
                    values.put("whats_new", appDetailInfo.getWhatNew());
                    values.put("download_url", appDetailInfo.getDownloadUrl());
                    values.put("pkg_name", appDetailInfo.getPkgName());
                    values.put("version_name", appDetailInfo.getVersionName());
                    values.put("version_code", Integer.valueOf(appDetailInfo.getVersionCode()));
                    values.put("size", Long.valueOf(appDetailInfo.getSize()));
                    values.put("md5", appDetailInfo.getMd5());
                    values.put("star_level", appDetailInfo.getStarLevel());
                    values.put("plan_id", Integer.valueOf(appDetailInfo.getPlanId()));
                    this.saveOrUpdate("app_detail", "app_id", String.valueOf(appDetailInfo.getAppId()), values);
                }
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("Recommend", e.toString());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    public List<AppDetailInfo> getAllAppDetails() {
        Cursor cursor;
        ArrayList<AppDetailInfo> appDetailList = null;
        if (this.mDB != null && (cursor = this.mDB.query("app_detail", DBData.AppDetail.ALL_COLUMNS, null, null, null, null, null)) != null) {
            if (cursor.getCount() > 0) {
                appDetailList = new ArrayList<AppDetailInfo>();
                while (cursor.moveToNext()) {
                    AppDetailInfo app = new AppDetailInfo();
                    app.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                    app.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                    app.setDescVersion(cursor.getInt(cursor.getColumnIndex("desc_version")));
                    app.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                    app.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                    app.setIcon((ImgInfo)Tson.fromJson((String)cursor.getString(cursor.getColumnIndex("icon")), ImgInfo.class));
                    ArrayList<ImgInfo> screenshotList = null;
                    try {
                        screenshotList = new ArrayList<ImgInfo>();
                        JSONArray screenshotJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("screenshots")));
                        for (int i = 0; i < screenshotJsonArray.length(); ++i) {
                            ImgInfo img = (ImgInfo)Tson.fromJson((String)screenshotJsonArray.getString(i), ImgInfo.class);
                            screenshotList.add(img);
                        }
                    }
                    catch (Exception e) {
                        CS.log.e("Recommend", "screenshot parse exception");
                    }
                    app.setApkScreenshotImgList(screenshotList);
                    ArrayList<ImgInfo> imageList = null;
                    try {
                        imageList = new ArrayList<ImgInfo>();
                        JSONArray imageJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("images")));
                        for (int i = 0; i < imageJsonArray.length(); ++i) {
                            ImgInfo img = (ImgInfo)Tson.fromJson((String)imageJsonArray.getString(i), ImgInfo.class);
                            imageList.add(img);
                        }
                    }
                    catch (Exception e) {
                        CS.log.e("Recommend", "image list parse exception");
                    }
                    app.setImages(imageList);
                    app.setCategory(cursor.getInt(cursor.getColumnIndex("category")));
                    app.setWebsite(cursor.getString(cursor.getColumnIndex("website")));
                    app.setEmail(cursor.getString(cursor.getColumnIndex("email")));
                    app.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                    app.setPolicy(cursor.getString(cursor.getColumnIndex("policy")));
                    app.setWhatNew(cursor.getString(cursor.getColumnIndex("whats_new")));
                    app.setDownloadUrl(cursor.getString(cursor.getColumnIndex("download_url")));
                    app.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                    app.setVersionName(cursor.getString(cursor.getColumnIndex("version_name")));
                    app.setVersionCode(cursor.getInt(cursor.getColumnIndex("version_code")));
                    app.setSize(cursor.getLong(cursor.getColumnIndex("size")));
                    app.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                    app.setStarLevel(cursor.getString(cursor.getColumnIndex("star_level")));
                    app.setPlanId(cursor.getInt(cursor.getColumnIndex("plan_id")));
                    appDetailList.add(app);
                }
            }
            cursor.close();
        }
        return appDetailList;
    }

    public AppDetailInfo getAppDetailByAppId(int appId) {
        String[] selectionArgs;
        String selection;
        Cursor cursor;
        AppDetailInfo app = null;
        if (this.mDB != null && (cursor = this.mDB.query("app_detail", DBData.AppDetail.ALL_COLUMNS, selection = "app_id = ?", selectionArgs = new String[]{String.valueOf(appId)}, null, null, null)) != null) {
            if (cursor.getCount() > 0 && cursor.moveToNext()) {
                app = new AppDetailInfo();
                app.setAppId(cursor.getInt(cursor.getColumnIndex("app_id")));
                app.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                app.setDescVersion(cursor.getInt(cursor.getColumnIndex("desc_version")));
                app.setSubDescription(cursor.getString(cursor.getColumnIndex("sub_desc")));
                app.setDescription(cursor.getString(cursor.getColumnIndex("desc")));
                app.setIcon((ImgInfo)Tson.fromJson((String)cursor.getString(cursor.getColumnIndex("icon")), ImgInfo.class));
                ArrayList<ImgInfo> screenshotList = null;
                try {
                    screenshotList = new ArrayList<ImgInfo>();
                    JSONArray screenshotJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("screenshots")));
                    for (int i = 0; i < screenshotJsonArray.length(); ++i) {
                        ImgInfo img = (ImgInfo)Tson.fromJson((String)screenshotJsonArray.getString(i), ImgInfo.class);
                        screenshotList.add(img);
                    }
                }
                catch (Exception e) {
                    CS.log.e("Recommend", "screenshot parse exception");
                }
                app.setApkScreenshotImgList(screenshotList);
                ArrayList<ImgInfo> imageList = null;
                try {
                    imageList = new ArrayList<ImgInfo>();
                    JSONArray imageJsonArray = new JSONArray(cursor.getString(cursor.getColumnIndex("images")));
                    for (int i = 0; i < imageJsonArray.length(); ++i) {
                        ImgInfo img = (ImgInfo)Tson.fromJson((String)imageJsonArray.getString(i), ImgInfo.class);
                        imageList.add(img);
                    }
                }
                catch (Exception e) {
                    CS.log.e("Recommend", "image list parse exception");
                }
                app.setImages(imageList);
                app.setCategory(cursor.getInt(cursor.getColumnIndex("category")));
                app.setWebsite(cursor.getString(cursor.getColumnIndex("website")));
                app.setEmail(cursor.getString(cursor.getColumnIndex("email")));
                app.setPhone(cursor.getString(cursor.getColumnIndex("phone")));
                app.setPolicy(cursor.getString(cursor.getColumnIndex("policy")));
                app.setWhatNew(cursor.getString(cursor.getColumnIndex("whats_new")));
                app.setDownloadUrl(cursor.getString(cursor.getColumnIndex("download_url")));
                app.setPkgName(cursor.getString(cursor.getColumnIndex("pkg_name")));
                app.setVersionName(cursor.getString(cursor.getColumnIndex("version_name")));
                app.setVersionCode(cursor.getInt(cursor.getColumnIndex("version_code")));
                app.setSize(cursor.getLong(cursor.getColumnIndex("size")));
                app.setMd5(cursor.getString(cursor.getColumnIndex("md5")));
                app.setStarLevel(cursor.getString(cursor.getColumnIndex("star_level")));
                app.setPlanId(cursor.getInt(cursor.getColumnIndex("plan_id")));
            }
            cursor.close();
        }
        return app;
    }

    public void deleteAllAppDetails() {
        if (this.mDB != null) {
            this.mDB.beginTransaction();
            try {
                this.mDB.delete("app_detail", null, null);
                this.mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                CS.log.e("Recommend", e.getMessage());
            }
            finally {
                this.mDB.endTransaction();
            }
        }
    }

    private int saveOrUpdate(String table, String keyField, String keyValue, ContentValues values) {
        int result = -1;
        if (this.mDB != null && !TextUtils.isEmpty((CharSequence)table) && values != null) {
            String[] args;
            String whereClause = keyField + " = ?";
            String sql = "select * from " + table + " where " + whereClause;
            Cursor cursor = this.mDB.rawQuery(sql, args = new String[]{keyValue});
            if (cursor != null && cursor.getCount() > 0) {
                this.mDB.update(table, values, whereClause, args);
                result = 2;
            } else {
                this.mDB.insert(table, null, values);
                result = 1;
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }
}

