/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.manager;

import android.content.Context;
import android.os.Build;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.json.Tson;
import com.transsion.newphonerecommend.bean.PhoneInfo;
import com.transsion.newphonerecommend.utils.MeasureUtil;
import com.transsion.newphonerecommend.utils.NetworkUtil;
import com.transsion.newphonerecommend.utils.PackageUtil;
import com.transsion.newphonerecommend.utils.PhoneUtil;
import java.util.Locale;

public class PhoneInfoManager {
    private static PhoneInfo phoneInfo;
    private static PhoneInfoManager phoneInfoManager;
    Context appContext = CoreUtil.getContext();

    public static PhoneInfoManager getInstance() {
        if (null == phoneInfoManager) {
            phoneInfoManager = new PhoneInfoManager();
        }
        return phoneInfoManager;
    }

    private PhoneInfoManager() {
        phoneInfo = new PhoneInfo();
        phoneInfo.setPkgName(CoreUtil.getContext().getPackageName());
        phoneInfo.setVersionName(PackageUtil.getVersionName(this.appContext));
        phoneInfo.setVersionCode(PackageUtil.getVersionCode(this.appContext));
        phoneInfo.setGaid(DeviceInfo.getGAId());
        phoneInfo.setIuid(DeviceInfo.getIMEI());
        phoneInfo.setAndroidID(DeviceInfo.getAndroidID());
        phoneInfo.setScreenWidth(MeasureUtil.getDisplayWidth(this.appContext));
        phoneInfo.setScreenHeight(MeasureUtil.getDisplayHeight(this.appContext));
        phoneInfo.setDpi(MeasureUtil.getDensityDpi(this.appContext));
        phoneInfo.setModel(Build.MODEL);
        phoneInfo.setBrand(Build.BRAND);
        phoneInfo.setOsVersion(Build.VERSION.SDK_INT);
        phoneInfo.setBuildVersion(PhoneUtil.getBuildVersion());
    }

    public PhoneInfo getPhoneInfo() {
        phoneInfo.setMmc(DeviceInfo.getIMSI());
        phoneInfo.setLatitude("");
        phoneInfo.setLongitude("");
        phoneInfo.setLac(PhoneUtil.getLac(this.appContext));
        phoneInfo.setCid(PhoneUtil.getCid(this.appContext));
        phoneInfo.setCountry(this.appContext.getResources().getConfiguration().locale.getCountry());
        phoneInfo.setLanguage(Locale.getDefault().getLanguage());
        phoneInfo.setNetwork(NetworkUtil.getNetworkType());
        return phoneInfo;
    }

    public String getPhoneInfoJson() {
        this.getPhoneInfo();
        String paramJson = Tson.toJson((Object)phoneInfo);
        return paramJson;
    }
}

