/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.report;

import android.os.Bundle;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.newphonerecommend.report.AthenaCust;
import java.util.ArrayList;

public class Tracker {
    public static final int PV_TYPE_ENTER = 0;
    public static final int PV_TYPE_EXIT = 1;
    private static AthenaAnalytics mAthenaAnalytics;

    public static void trackBundle(Event event, Bundle bundle) {
        if (bundle != null) {
            new AthenaCust(event.name, event.tid).trackCommon(bundle, null).submit();
        }
    }

    public static void trackListBundle(Event event, ArrayList<Bundle> bundleList, Bundle bundle) {
        if (bundleList != null && bundle != null) {
            new AthenaCust(event.name, event.tid).trackCommon(bundleList, bundle).submit();
        }
    }

    public static void trackPV(Event event, int pvType) {
        long pageEnter = 0L;
        long pageExit = 0L;
        if (pvType == 0) {
            pageEnter = System.currentTimeMillis();
        } else if (pvType == 1) {
            pageExit = System.currentTimeMillis();
        } else {
            return;
        }
        new AthenaCust(event.name, event.tid).trackPV(pageEnter, pageExit, 0, null).submit();
    }

    public static void enableTrackData() {
        AthenaAnalytics.enable((boolean)true);
    }

    public static void disableTrackData() {
        AthenaAnalytics.enable((boolean)false);
    }

    public static enum Event {
        RECOMMEND_REQUEST("aud_null_rq_ep", 10517001),
        RECOMMEND_RESPONSE("aud_null_rl_ep", 10517001),
        UPDATE_BTN_CLICK("aud_pre_dc_cl", 10518001),
        DOWNLOAD_BEGIN("aud_null_sd_ep", 10517001),
        DOWNLOAD_END("aud_null_dr_ep", 10517001),
        INSTALL_BEGIN("aud_null_si_ep", 10517001),
        INSTALL_END("aud_null_ir_ep", 10517001),
        APP_LIST_SHOW("aud_pre_ps_ep", 10517001),
        SKIP_BTN_CLICK("aud_pre_sc_cl", 10518001),
        NOTIFICATION_CLICK("aud_pre_nc_cl", 10518001),
        APP_LIST_SHOW_PV("aud_pre_pv", 10519001);

        public final String name;
        public final int tid;

        private Event(String name, int tid) {
            this.name = name;
            this.tid = tid;
        }
    }
}

