/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.ui;

import android.os.AsyncTask;
import android.os.Bundle;
import android.text.format.DateFormat;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.database.DBManager;
import com.transsion.newphonerecommend.log.CS;
import com.transsion.newphonerecommend.report.Tracker;
import com.transsion.newphonerecommend.ui.NewPhoneRecommendContract;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class NewPhoneRecommendPresenter
implements NewPhoneRecommendContract.Presenter {
    private NewPhoneRecommendContract.View mView;

    public NewPhoneRecommendPresenter(NewPhoneRecommendContract.View view) {
        this.mView = view;
    }

    @Override
    public void loadData() {
        Tracker.trackPV(Tracker.Event.APP_LIST_SHOW_PV, 0);
        new LoadDataTask(this).execute(new Object[0]);
    }

    @Override
    public void onDestroy() {
        Tracker.trackPV(Tracker.Event.APP_LIST_SHOW_PV, 1);
        this.mView = null;
    }

    @Override
    public void trackAppList(Tracker.Event event, List<AppDetailInfo> appDetailInfoList) {
        ArrayList<Bundle> appList = new ArrayList<Bundle>();
        if (appDetailInfoList != null) {
            for (AppDetailInfo appDetailInfo : appDetailInfoList) {
                if (event == Tracker.Event.UPDATE_BTN_CLICK && !appDetailInfo.isChecked()) continue;
                Bundle appData = new Bundle();
                appData.putString("qg", appDetailInfo.getPkgName());
                appData.putInt("ve", appDetailInfo.getVersionCode());
                appData.putInt("plid", appDetailInfo.getPlanId());
                appList.add(appData);
            }
        }
        Bundle trackData = new Bundle();
        trackData.putString("te", DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", (long)System.currentTimeMillis()) + "");
        Tracker.trackListBundle(event, appList, trackData);
    }

    static class LoadDataTask
    extends AsyncTask<Object, Object, List<AppDetailInfo>> {
        WeakReference<NewPhoneRecommendPresenter> mPresenter;

        LoadDataTask(NewPhoneRecommendPresenter presenter) {
            this.mPresenter = new WeakReference<NewPhoneRecommendPresenter>(presenter);
        }

        protected List<AppDetailInfo> doInBackground(Object ... objects) {
            List<AppDetailInfo> allAppDetails = null;
            try {
                allAppDetails = DBManager.getInstance().getAllAppDetails();
            }
            catch (Exception e) {
                CS.log.e("Recommend", e.getMessage());
            }
            return allAppDetails;
        }

        protected void onPostExecute(List<AppDetailInfo> appDetailInfoList) {
            if (this.mPresenter != null && this.mPresenter.get() != null && ((NewPhoneRecommendPresenter)this.mPresenter.get()).mView != null) {
                ((NewPhoneRecommendPresenter)this.mPresenter.get()).mView.showData(appDetailInfoList);
                ((NewPhoneRecommendPresenter)this.mPresenter.get()).trackAppList(Tracker.Event.APP_LIST_SHOW, appDetailInfoList);
            }
        }
    }
}

