/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.transsion.newphonerecommend.R;
import com.transsion.newphonerecommend.bean.AppDetailInfo;
import com.transsion.newphonerecommend.log.CS;
import com.transsion.newphonerecommend.ui.NewPhoneRecommendContract;
import java.util.List;

public class RecommendListAdapter
extends RecyclerView.Adapter<AppInfoViewHolder> {
    private Context mContext;
    private NewPhoneRecommendContract.View mView;
    private List<AppDetailInfo> mData;

    RecommendListAdapter(Context context, NewPhoneRecommendContract.View view, List<AppDetailInfo> appDetailInfoList) {
        this.mContext = context;
        this.mView = view;
        this.mData = appDetailInfoList;
    }

    @NonNull
    public AppInfoViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_app_info, parent, false);
        return new AppInfoViewHolder(itemView);
    }

    public void onBindViewHolder(@NonNull AppInfoViewHolder holder, int position) {
        AppDetailInfo appDetailInfo;
        if (this.mData != null && position < this.mData.size() && (appDetailInfo = this.mData.get(position)) != null) {
            if (appDetailInfo.getIcon() != null && !TextUtils.isEmpty((CharSequence)appDetailInfo.getIcon().getUrl())) {
                Glide.with((Context)this.mContext.getApplicationContext()).load(appDetailInfo.getIcon().getUrl()).into(holder.ivAppIcon);
            }
            holder.tvAppName.setText((CharSequence)appDetailInfo.getTitle());
            holder.tvAppDesc.setText((CharSequence)appDetailInfo.getSubDescription());
            try {
                int starLevel = Integer.parseInt(appDetailInfo.getStarLevel());
                holder.rbAppStar.setRating((float)starLevel);
            }
            catch (Exception e) {
                CS.log.e("Recommend", e.getMessage());
            }
            String[] categoryDictionary = this.mContext.getApplicationContext().getResources().getStringArray(R.array.category_dictionary);
            StringBuilder builder = new StringBuilder();
            int categoryIndex = appDetailInfo.getCategory() - 1;
            if (categoryIndex >= 0 && categoryIndex < categoryDictionary.length) {
                builder.append(categoryDictionary[categoryIndex]);
                builder.append(" / ");
            }
            builder.append(Formatter.formatFileSize((Context)this.mContext.getApplicationContext(), (long)appDetailInfo.getSize()));
            holder.tvAppCategorySize.setText((CharSequence)builder.toString());
            holder.cbAppSelectStatus.setChecked(appDetailInfo.isChecked());
            holder.cbAppSelectStatus.setOnClickListener(v -> {
                if (v instanceof CheckBox) {
                    CheckBox cb = (CheckBox)v;
                    appDetailInfo.setChecked(cb.isChecked());
                    this.mView.updateDownloadButton();
                }
            });
        }
    }

    public int getItemCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    static class AppInfoViewHolder
    extends RecyclerView.ViewHolder {
        CardView cvAppIcon;
        ImageView ivAppIcon;
        TextView tvAppName;
        TextView tvAppDesc;
        RatingBar rbAppStar;
        TextView tvAppCategorySize;
        CheckBox cbAppSelectStatus;

        AppInfoViewHolder(View itemView) {
            super(itemView);
            this.cvAppIcon = (CardView)itemView.findViewById(R.id.cv_app_icon);
            this.ivAppIcon = (ImageView)itemView.findViewById(R.id.iv_app_icon);
            this.tvAppName = (TextView)itemView.findViewById(R.id.tv_app_name);
            this.tvAppDesc = (TextView)itemView.findViewById(R.id.tv_app_desc);
            this.rbAppStar = (RatingBar)itemView.findViewById(R.id.rb_app_star);
            this.tvAppCategorySize = (TextView)itemView.findViewById(R.id.tv_app_category_size);
            this.cbAppSelectStatus = (CheckBox)itemView.findViewById(R.id.cb_app_select_status);
        }
    }
}

