/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.newphonerecommend.utils;

import android.app.ActivityManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.newphonerecommend.log.CS;
import com.transsion.newphonerecommend.utils.Constants;
import com.transsion.newphonerecommend.utils.PhoneUtil;
import java.util.ArrayList;
import java.util.List;

public class ProcessUtil {
    public static String getCurrentProcessPackageName() {
        String currentProcessPackageName = ProcessUtil.getCurrentNameByUsageStatsService();
        if (TextUtils.isEmpty((CharSequence)currentProcessPackageName)) {
            currentProcessPackageName = ProcessUtil.getCurrentNameByRunningTask();
        }
        return currentProcessPackageName;
    }

    public static boolean isLauncher() {
        boolean result = false;
        if (TextUtils.isEmpty((CharSequence)Constants.sLauncherPkgName)) {
            String[] launcherInfos = PhoneUtil.getLaunchInfo(CoreUtil.getContext());
            Constants.sLauncherPkgName = launcherInfos[0];
            CS.log.d("Recommend", "get launcher packageName: " + launcherInfos[0]);
        }
        String currentPackageName = ProcessUtil.getCurrentProcessPackageName();
        CS.log.d("Recommend", "packageName:" + currentPackageName);
        if (currentPackageName != null && currentPackageName.equals(Constants.sLauncherPkgName)) {
            result = true;
        }
        return result;
    }

    public static List<String> getPackagesForHalfHour() {
        return ProcessUtil.getPackagesForMin(30);
    }

    public static List<String> getPackagesForMin(int min) {
        long now = System.currentTimeMillis();
        List<String> results = ProcessUtil.getPackagesByTime(now - (long)(min * 60 * 1000), now);
        return results;
    }

    public static List<String> getPackagesByTime(long beginTime, long endTime) {
        List stats;
        ArrayList<String> results = new ArrayList<String>();
        UsageStatsManager m = (UsageStatsManager)CoreUtil.getContext().getSystemService("usagestats");
        if (m != null && (stats = m.queryUsageStats(4, beginTime, endTime)) != null && !stats.isEmpty()) {
            for (int i = 0; i < stats.size(); ++i) {
                String pkg = ((UsageStats)stats.get(i)).getPackageName();
                CS.log.d("Recommend", "\u5728\u89c4\u5b9a\u65f6\u95f4\u5185\u6253\u5f00\u7684\u5e94\u7528: " + pkg);
                results.add(pkg);
            }
        }
        return results;
    }

    private static String getCurrentNameByRunningTask() {
        String packageName = "";
        Context context = CoreUtil.getContext();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List taskInfos = activityManager.getRunningTasks(1);
        if (taskInfos.size() == 0) {
            return null;
        }
        ComponentName cn = ((ActivityManager.RunningTaskInfo)taskInfos.get((int)0)).topActivity;
        packageName = cn.getPackageName();
        return packageName;
    }

    private static String getCurrentNameByUsageStatsService() {
        long now;
        List stats;
        String result = "";
        UsageStatsManager m = (UsageStatsManager)CoreUtil.getContext().getSystemService("usagestats");
        if (m != null && (stats = m.queryUsageStats(4, (now = System.currentTimeMillis()) - 60000L, now)) != null && !stats.isEmpty()) {
            int j = 0;
            for (int i = 0; i < stats.size(); ++i) {
                if (((UsageStats)stats.get(i)).getLastTimeUsed() > ((UsageStats)stats.get(j)).getLastTimeUsed()) {
                    j = i;
                }
                result = ((UsageStats)stats.get(j)).getPackageName();
            }
        }
        return result;
    }
}

