/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.athena.data.logobj;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.athena.data.Config;
import com.transsion.athena.data.LogBuilder;
import com.transsion.athena.data.MultiApps;
import com.transsion.athena.data.logobj.AppConfigCallBack;
import com.transsion.athena.data.logobj.AppDataHandler;
import com.transsion.athena.data.transfer.AthenaTransferLog;
import com.transsion.athena.entry.Track;
import com.transsion.athena.entry.config.AppConfig;
import com.transsion.athena.entry.config.GlobalConfig;
import com.transsion.athena.entry.config.TidConfigBean;
import com.transsion.athena.utils.AthenaUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.AppUtil;
import org.json.JSONObject;

public class AthenaLogHandler {
    private static final String a = AthenaLogHandler.class.getName();
    private GlobalConfig b = GlobalConfig.getInstance();
    private AppConfig c = AppConfig.getInstance();
    private AppDataHandler d = new AppDataHandler();
    private AthenaTransferLog e = new AthenaTransferLog(CoreUtil.getContext());
    private LogBuilder f = new LogBuilder(this.e);

    public void save(Track track) {
        long l = this.c.getPushDuring(track.getTid());
        this.f.setTid(track.getTid());
        this.f.setStreamFlag(this.c.queryOrGenConfigByTid(track.getTid()).getTidConfig().getStreamFlag());
        if (l >= 0L) {
            String string = track.getJsonData();
            if (!(string.contains("&add") || string.contains("&append") || string.contains(":{"))) {
                track.setFlag(0);
                this.c.changeDataFlag(track.getTid(), 0);
                this.d.saveToFile(this.f, track);
            } else {
                track.setFlag(1);
                this.c.changeDataFlag(track.getTid(), 1);
                AthenaUtils.LOG.i((Object)("SaveData succeed  tid:" + track.getTid()));
                this.d.saveToDB(track);
            }
        } else {
            track.setFlag(-1);
            AthenaUtils.LOG.w((Object)("SaveData error tid:" + track.getTid()));
        }
    }

    public void checkAthenaConfig() {
        int n = this.b.checkTimeMode();
        for (Integer n2 : MultiApps.getExtAppIds()) {
            if (n != 1 && AppConfig.getInstance().findConfigByAppId(n2.intValue()) != null && n != 2) continue;
            this.a(n2);
        }
    }

    public void checkUpload(final int n) {
        if (!AthenaUtils.isDataConnected(CoreUtil.getContext())) {
            return;
        }
        if (!this.c.checkConfig(new AppConfigCallBack(){

            @Override
            public void call(TidConfigBean tidConfigBean) {
                int n2 = AthenaLogHandler.this.c.checkTimeMode(tidConfigBean.getTid());
                boolean bl = AthenaLogHandler.this.c.checkCachedItems(tidConfigBean.getTid());
                if (bl) {
                    AthenaUtils.LOG.i((Object)"Over Cached");
                }
                if (n2 == 1 || bl) {
                    AthenaLogHandler.this.f.setTid(tidConfigBean.getTid());
                    AthenaLogHandler.this.f.setStreamFlag(tidConfigBean.getTidConfig().getStreamFlag());
                    if (n == -1 || n == tidConfigBean.getTid()) {
                        if (tidConfigBean.getTidConfig().getDataFlag() == 1) {
                            AthenaLogHandler.this.d.convertDBToFile(AthenaLogHandler.this.f);
                        }
                        if (AthenaLogHandler.this.f.submitJson()) {
                            AthenaLogHandler.this.c.resetDataFlag(tidConfigBean.getTid());
                        }
                    }
                } else {
                    AthenaUtils.LOG.i((Object)("The upload condition is not met  tid:" + tidConfigBean.getTid() + "  timeMode:" + n2 + " push during:" + tidConfigBean.getTidConfig().getPushDuration()));
                }
            }
        })) {
            AthenaUtils.LOG.i((Object)"If there is no matching value, insist that your tid exists in the cloud");
        }
    }

    private void a(int n) {
        if (AthenaUtils.isDataConnected(CoreUtil.getContext())) {
            String string = this.b(n);
            AthenaUtils.LOG.i((Object)("get Push Json:" + string + " tid:" + n));
            AthenaUtils.LOG.json(string);
            this.c.setServerData(string);
            String string2 = this.a();
            AthenaUtils.LOG.json(string2);
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                this.b.setPullTime(System.currentTimeMillis());
            }
            this.b.setServerData(string2);
        }
    }

    private String a() {
        return AthenaUtils.doPost(Config.getAthenaConfigUrl(), "");
    }

    private String b(int n) {
        if (n < 10) {
            return null;
        }
        String string = String.valueOf(n).substring(0, 4);
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("sname", (Object)string);
            jSONObject.put("appver", (Object)(AppUtil.getVersionCode() + ""));
            jSONObject.put("model", (Object)Build.MODEL);
            jSONObject.put("brand", (Object)Build.BRAND);
            jSONObject.put("anver", (Object)Build.VERSION.RELEASE);
            jSONObject.put("apppkg", (Object)AppUtil.getPkgName());
            return AthenaUtils.doPost(Config.getLogConfigUrl(), jSONObject.toString());
        }
        catch (Throwable throwable) {
            AthenaUtils.LOG.e((Object)Log.getStackTraceString((Throwable)throwable));
            return null;
        }
    }

    public TidConfigBean getTidConfig(int n) {
        return this.c.queryOrGenConfigByTid(n);
    }
}

