/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.codetabletranslator;

import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;

public class AESKeyStore {
    public static String TAG = "AESKeyStore";
    private static final String KEYSTORE_PROVIDER = "AndroidKeyStore";
    private static final String AES_MODE = "AES/GCM/NoPadding";
    private static final String RSA_MODE = "RSA/ECB/PKCS1Padding";
    private static final String KEYSTORE_ALIAS = "KEYSTORE_AES_CODE_TABLE";
    private static final String SHARED_REFS_NAME = "codeTableTranslator";
    private static final String SHARED_REFS_HAS_GEN_RSA_KEY = "hasGenRsaKey";
    private static final String SHARED_REFS_AES_KEY = "encryptedAesKey";
    private KeyStore mKeyStore;
    private Context mContext;

    public AESKeyStore(Context ctx) {
        this.mContext = ctx;
        try {
            this.mKeyStore = KeyStore.getInstance(KEYSTORE_PROVIDER);
            this.mKeyStore.load(null);
            SharedPreferences prefs = this.mContext.getSharedPreferences(SHARED_REFS_NAME, 0);
            boolean hasRSAKey = prefs.getBoolean(SHARED_REFS_HAS_GEN_RSA_KEY, false);
            if (!hasRSAKey) {
                this.generateRSAKey_AboveApi23();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveAesKey(String aesKey) {
        try {
            AESKeyStore aESKeyStore = this;
            synchronized (aESKeyStore) {
                String encryptedKey = this.encryptAesKeyByRSA(aesKey);
                SharedPreferences.Editor editor = this.mContext.getSharedPreferences(SHARED_REFS_NAME, 0).edit();
                editor.putString(SHARED_REFS_AES_KEY, encryptedKey);
                editor.apply();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAesKey() {
        try {
            AESKeyStore aESKeyStore = this;
            synchronized (aESKeyStore) {
                SharedPreferences prefs = this.mContext.getSharedPreferences(SHARED_REFS_NAME, 0);
                String encryptedAesKey = prefs.getString(SHARED_REFS_AES_KEY, "");
                String decryptedAesKey = this.decryptByRSA(encryptedAesKey);
                return decryptedAesKey;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void generateRSAKey_AboveApi23() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", KEYSTORE_PROVIDER);
        KeyGenParameterSpec keyGenParameterSpec = new KeyGenParameterSpec.Builder(KEYSTORE_ALIAS, 3).setDigests(new String[]{"SHA-256", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).build();
        keyPairGenerator.initialize((AlgorithmParameterSpec)keyGenParameterSpec);
        keyPairGenerator.generateKeyPair();
        SharedPreferences.Editor editor = this.mContext.getSharedPreferences(SHARED_REFS_NAME, 0).edit();
        editor.putBoolean(SHARED_REFS_HAS_GEN_RSA_KEY, true);
        editor.apply();
    }

    private String encryptAesKeyByRSA(String aesKey) throws Exception {
        byte[] plainText = Base64.decode((String)aesKey, (int)0);
        PublicKey publicKey = this.mKeyStore.getCertificate(KEYSTORE_ALIAS).getPublicKey();
        Cipher cipher = Cipher.getInstance(RSA_MODE);
        cipher.init(1, publicKey);
        byte[] encryptedByte = cipher.doFinal(plainText);
        return Base64.encodeToString((byte[])encryptedByte, (int)0);
    }

    private String decryptByRSA(String encryptedText) throws Exception {
        PrivateKey privateKey = (PrivateKey)this.mKeyStore.getKey(KEYSTORE_ALIAS, null);
        Cipher cipher = Cipher.getInstance(RSA_MODE);
        cipher.init(2, privateKey);
        byte[] encryptedBytes = Base64.decode((String)encryptedText, (int)0);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        String aesKey = Base64.encodeToString((byte[])decryptedBytes, (int)0);
        return aesKey;
    }
}

