/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.codetabletranslator;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.transsion.codetabletranslator.AESKeyStore;
import com.transsion.codetabletranslator.AESUtils;
import com.transsion.codetabletranslator.HttpUtils;
import com.transsion.codetabletranslator.RSAUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.json.JSONArray;
import org.json.JSONObject;

public class CodeTable {
    public static final String TAG = "CodeTable";
    Context mContext;
    private static final String SHARED_REFS_CODE_TABLE_PARAM = "codeTableParams";
    private static final String SHARED_REFS_LAST_UPDATE_TIME = "lastUpdateTime";
    private static final String SHARED_REFS_TABLE_VERSION = "tableVersion";
    private static final String SHARED_REFS_TABLE_CONTENT = "encryptTable";
    private static final long UPDATE_TABLE_INTERVAL = 43200000L;
    private static final String RSA_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCKt6BtdKUWQwNxKc6cazafELq1kSdQXwS5LUBOJHAhSF+01lzSjWIeT5KBcq0oEvYvUAUdEbIfUfQzIDRyywgsESDY5rf9Q3qP8Jm4LwkzmBlR25Cerfvd40ilEsOIVyveNTnRpE3zhllhFTwcYqlEWZf7s0tN4qwWuNm3wX0ExQIDAQAB";
    public static final String CODE_TABLE_SERVER = "https://mi-test.shalltry.com/OSCode/queryAesCodeByVersion";
    private static final String CODE_TABLE_FILE_NAME = "encryptcodetable";
    HashMap<String, String> mCodeTableMap = new HashMap();
    AESKeyStore mAesKeyStore = null;
    public String testString;
    public String testAesKey;

    public CodeTable(Context ctx) {
        this.mContext = ctx;
        this.mAesKeyStore = new AESKeyStore(ctx);
    }

    public void init() {
        if (this.isNeedUpdate()) {
            if (!this.updateCodeTableByHttp()) {
                this.loadCodeTableFromFile();
            }
        } else {
            this.loadCodeTableFromFile();
        }
    }

    public boolean isNeedUpdate() {
        SharedPreferences prefs;
        long lastUpdateTime;
        long currentTime = System.currentTimeMillis();
        return currentTime - (lastUpdateTime = (prefs = this.mContext.getSharedPreferences(SHARED_REFS_CODE_TABLE_PARAM, 0)).getLong(SHARED_REFS_LAST_UPDATE_TIME, 0L)) > 43200000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodeValue(String code) {
        CodeTable codeTable = this;
        synchronized (codeTable) {
            if (this.isNeedUpdate()) {
                this.updateCodeTableByHttp();
            }
            if (this.mCodeTableMap.containsKey(code)) {
                return this.mCodeTableMap.get(code);
            }
            return code;
        }
    }

    public boolean updateCodeTableByHttp() {
        boolean ret = false;
        try {
            String aesKey = this.getAESKey();
            Log.i((String)TAG, (String)("AES key get bytes:" + aesKey.getBytes()));
            String encryptAESStr = RSAUtils.publicEncrypt(aesKey, RSAUtils.getPublicKey(RSA_PUBLIC_KEY));
            JSONObject postJson = new JSONObject();
            postJson.put("version", (Object)this.getCodeTableVersion());
            postJson.put("password", (Object)encryptAESStr);
            HttpUtils httpConnect = new HttpUtils(CODE_TABLE_SERVER);
            String response = httpConnect.httpPost(postJson, "UTF-8");
            JSONObject responseJson = new JSONObject(response);
            String msg = responseJson.get("message").toString();
            if (msg.equals("success")) {
                this.saveVersion(responseJson.get("version").toString());
                String encryptedCodeTableStr = responseJson.get("data").toString();
                this.saveCodeTableToFile(encryptedCodeTableStr);
                Log.i((String)TAG, (String)("http dwon encrypted data:" + encryptedCodeTableStr));
                this.saveUpdateTime();
                this.mAesKeyStore.saveAesKey(aesKey);
                this.updateCodeTableMap(encryptedCodeTableStr, aesKey);
                ret = true;
            } else {
                ret = false;
                Log.w((String)TAG, (String)("get code table " + msg));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.w((String)TAG, (String)"updateCodeTableByHttp Exception");
            ret = false;
        }
        return ret;
    }

    private String getCodeTableVersion() {
        SharedPreferences prefs = this.mContext.getSharedPreferences(SHARED_REFS_CODE_TABLE_PARAM, 0);
        return prefs.getString(SHARED_REFS_TABLE_VERSION, "default");
    }

    private void saveVersion(String version) {
        SharedPreferences.Editor editor = this.mContext.getSharedPreferences(SHARED_REFS_CODE_TABLE_PARAM, 0).edit();
        editor.putString(SHARED_REFS_TABLE_VERSION, version);
        editor.apply();
    }

    private void saveUpdateTime() {
        long currentTime = System.currentTimeMillis();
        SharedPreferences.Editor editor = this.mContext.getSharedPreferences(SHARED_REFS_CODE_TABLE_PARAM, 0).edit();
        editor.putLong(SHARED_REFS_LAST_UPDATE_TIME, currentTime);
        editor.apply();
    }

    public String getAESKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(128);
        SecretKey sk = kg.generateKey();
        byte[] b = sk.getEncoded();
        return this.parseByte2HexStr(b);
    }

    public String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCodeTableToFile(String data) {
        FileOutputStream out = null;
        BufferedWriter writer = null;
        try {
            out = this.mContext.openFileOutput(CODE_TABLE_FILE_NAME, 0);
            writer = new BufferedWriter(new OutputStreamWriter(out));
            writer.write(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCodeTableFromFile() {
        FileInputStream input = null;
        BufferedReader reader = null;
        StringBuffer content = new StringBuffer();
        try {
            input = this.mContext.openFileInput(CODE_TABLE_FILE_NAME);
            reader = new BufferedReader(new InputStreamReader(input));
            String line = "";
            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
            String s = content.toString();
            String key = this.mAesKeyStore.getAesKey();
            this.updateCodeTableMap(content.toString(), key.substring(0, 32));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return content.toString();
    }

    private void updateCodeTableMap(String encryptedCodeTableStr, String aesKey) {
        try {
            String decryptedTable = AESUtils.decryptAES(aesKey, encryptedCodeTableStr);
            Log.i((String)TAG, (String)("decrypt AES data:" + decryptedTable));
            if (decryptedTable != null && !decryptedTable.equals("")) {
                this.invertJsonStrToMap(decryptedTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invertJsonStrToMap(String jsonStr) {
        try {
            Log.i((String)TAG, (String)"change json to map");
            CodeTable codeTable = this;
            synchronized (codeTable) {
                JSONArray jsonArray = new JSONArray(jsonStr);
                if (jsonArray.length() > 0) {
                    this.mCodeTableMap.clear();
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject item = jsonArray.getJSONObject(i);
                    String codeKey = item.getString("pack");
                    String codeValue = item.getString("code");
                    this.mCodeTableMap.put(codeKey, codeValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

