/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.deviceinfo;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Looper;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.AdvertisingIdClient;
import com.transsion.core.deviceinfo.SysProp;
import com.transsion.core.log.LogUtils;
import com.transsion.core.utils.EncoderUtil;
import com.transsion.core.utils.PermissionUtil;

@TargetApi(value=3)
public class DeviceInfo {
    private static String mGAId = "";
    private static String mImei = "";
    private static String mAndroidId = "";

    public static String getIMEI() {
        if (!TextUtils.isEmpty((CharSequence)mImei)) {
            return mImei;
        }
        String imei = SysProp.get("prop.sim1.imei", "");
        if (imei == null || imei.length() == 0 || imei.length() != 15) {
            try {
                imei = ((TelephonyManager)CoreUtil.getContext().getSystemService("phone")).getDeviceId();
            }
            catch (SecurityException e) {
                imei = "";
            }
        }
        mImei = TextUtils.isEmpty((CharSequence)imei) ? "" : EncoderUtil.EncoderByAlgorithm(imei);
        return mImei;
    }

    public static String getGAId() {
        if (mGAId == null || mGAId.length() == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
                        mGAId = adInfo.getId();
                        LogUtils.i("advertisingId is " + mGAId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        return mGAId;
    }

    private static boolean isCurrentMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static String getGAIdInThread() {
        if (DeviceInfo.isCurrentMainThread()) {
            return DeviceInfo.getGAId();
        }
        if (mGAId != null && mGAId.length() != 0) {
            return mGAId;
        }
        try {
            AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
            mGAId = adInfo.getId();
            LogUtils.i("advertisingId is " + mGAId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mGAId;
    }

    public static String getIMSI() {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (0 != context.getPackageManager().checkPermission("android.permission.READ_PHONE_STATE", context.getApplicationContext().getPackageName())) {
                return DeviceInfo.getSimOperator();
            }
            String subscriberId = null;
            if (null != tm) {
                subscriberId = tm.getSubscriberId();
            }
            if (null == subscriberId) {
                return "";
            }
            if (subscriberId.length() < 8) {
                return "";
            }
            return subscriberId.substring(0, 8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getSimOperator() {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (null == tm) {
                return "";
            }
            return tm.getSimOperator();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getBTMAC() {
        try {
            BluetoothAdapter m_BluetoothAdapter = null;
            m_BluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            boolean lack = PermissionUtil.lacksPermission("android.permission.BLUETOOTH");
            if (!lack && m_BluetoothAdapter != null) {
                return m_BluetoothAdapter.getAddress();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isPad() {
        Context context = CoreUtil.getContext();
        if (context.getResources() != null) {
            return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        return false;
    }

    public static String getAndroidID() {
        if (!TextUtils.isEmpty((CharSequence)mAndroidId)) {
            return mAndroidId;
        }
        Context context = CoreUtil.getContext();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        mAndroidId = TextUtils.isEmpty((CharSequence)androidId) ? "" : EncoderUtil.EncoderByAlgorithm(androidId);
        return mAndroidId;
    }
}

