/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.pool;

import com.transsion.core.pool.PoolManagerImpl;
import com.transsion.core.pool.TranssionPoolExecutor;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class HttpPoolManager
implements PoolManagerImpl {
    public static volatile HttpPoolManager mInstance;
    private ThreadPoolExecutor executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized HttpPoolManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<HttpPoolManager> clazz = HttpPoolManager.class;
        synchronized (HttpPoolManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HttpPoolManager();
            HttpPoolManager.mInstance.executor = TranssionPoolExecutor.newSourceExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public void addTask(Runnable newTask) {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor.prestartAllCoreThreads();
            }
            this.executor.execute(newTask);
        }
    }

    @Override
    public void destroy() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void purge() {
        if (this.executor != null) {
            this.executor.purge();
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void execute(WeakReference<Runnable> request) {
        Runnable runnable = (Runnable)request.get();
        if (runnable != null) {
            this.addTask(runnable);
        }
    }
}

