/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.utils;

import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;
import com.transsion.core.utils.EncoderUtil;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;

public class MacUtil {
    private static final String TAG = "MacUtil";

    public static String getLocalMacAddress() {
        String mac = "";
        if (Build.VERSION.SDK_INT >= 23) {
            mac = MacUtil.getMacAddr();
            LogUtils.i("get mac from M+");
        } else {
            WifiInfo info;
            WifiManager wifi = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                mac = info.getMacAddress();
            }
            LogUtils.i("normal get mac");
        }
        return TextUtils.isEmpty((CharSequence)mac) ? "" : EncoderUtil.EncoderByAlgorithm(mac);
    }

    private static String getMacAddr() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null || macBytes.length == 0) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b : macBytes) {
                    res1.append(String.format("%02X:", b));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Exception e) {
            LogUtils.i("get mac is error: " + e.getMessage());
        }
        return "";
    }
}

