/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.utils;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.widget.Toast;
import com.transsion.core.CoreUtil;
import java.lang.reflect.Field;

public class ToastUtil {
    private static Handler mHandler = new Handler(Looper.getMainLooper());
    private static Toast toast = null;
    private static Field sField_TN;
    private static Field sField_TN_Handler;

    public static void showToast(int resId) {
        final Context context = CoreUtil.getContext();
        final int resid = resId;
        if (resid <= 0) {
            return;
        }
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (toast != null) {
                    toast.setText(resid);
                    toast.setDuration(0);
                    ToastUtil.hook(toast);
                } else {
                    toast = Toast.makeText((Context)context.getApplicationContext(), (int)resid, (int)0);
                }
                toast.show();
            }
        });
    }

    public static void showToast(String text) {
        final Context context = CoreUtil.getContext();
        final String msg = text;
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (toast != null) {
                    toast.setText((CharSequence)msg);
                    toast.setDuration(0);
                    ToastUtil.hook(toast);
                } else {
                    toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)msg, (int)0);
                }
                toast.show();
            }
        });
    }

    public static void showLongToast(int resId) {
        final Context context = CoreUtil.getContext();
        final int resid = resId;
        if (resid <= 0) {
            return;
        }
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (toast != null) {
                    toast.setText(resid);
                    toast.setDuration(1);
                    ToastUtil.hook(toast);
                } else {
                    toast = Toast.makeText((Context)context.getApplicationContext(), (int)resid, (int)1);
                }
                toast.show();
            }
        });
    }

    public static void showLongToast(String text) {
        final Context context = CoreUtil.getContext();
        final String msg = text;
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (toast != null) {
                    toast.setText((CharSequence)msg);
                    toast.setDuration(1);
                    ToastUtil.hook(toast);
                } else {
                    toast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)msg, (int)1);
                }
                toast.show();
            }
        });
    }

    private static void hook(Toast toast) {
        try {
            Object tn = sField_TN.get(toast);
            Handler preHandler = (Handler)sField_TN_Handler.get(tn);
            if (preHandler != null && !(preHandler instanceof SafelyHandlerWrapper)) {
                sField_TN_Handler.set(tn, (Object)new SafelyHandlerWrapper(preHandler));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            sField_TN = Toast.class.getDeclaredField("mTN");
            sField_TN.setAccessible(true);
            sField_TN_Handler = sField_TN.getType().getDeclaredField("mHandler");
            sField_TN_Handler.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SafelyHandlerWrapper
    extends Handler {
        private Handler impl;

        SafelyHandlerWrapper(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void handleMessage(Message msg) {
            this.impl.handleMessage(msg);
        }
    }
}

