/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.utils;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

public class ViewBitmapRecycleUtil {
    public static void bitmapsRecycle(View contentView) {
        if (contentView instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)contentView).getChildCount(); ++i) {
                View view = ((ViewGroup)contentView).getChildAt(i);
                ViewBitmapRecycleUtil.bitmapsRecycle(view);
            }
        } else if (contentView instanceof ImageView) {
            ViewBitmapRecycleUtil.bitmapRecycle((ImageView)contentView);
        }
    }

    private static void bitmapRecycle(ImageView imageView) {
        try {
            Bitmap bitmap;
            BitmapDrawable bd;
            if (imageView.getDrawable() instanceof BitmapDrawable && (bd = (BitmapDrawable)imageView.getDrawable()) != null && (bitmap = bd.getBitmap()) != null && !bitmap.isRecycled()) {
                bitmap.recycle();
            }
            imageView.setImageBitmap(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

