/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.deviceinfo;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.AdvertisingIdClient;
import com.transsion.core.deviceinfo.SysProp;
import com.transsion.core.log.LogUtils;
import com.transsion.core.utils.EncoderUtil;
import com.transsion.core.utils.PermissionUtil;
import java.lang.reflect.Method;
import java.util.TimeZone;

@TargetApi(value=3)
public class DeviceInfo {
    private static String mGAId = "";
    private static String mImei = "";
    private static String mAndroidId = "";
    private static String osVersion = "";

    public static String getIMEI() {
        if (!TextUtils.isEmpty((CharSequence)mImei)) {
            return mImei;
        }
        String imei = SysProp.get("prop.sim1.imei", "");
        if (imei == null || imei.length() == 0 || imei.length() != 15) {
            try {
                TelephonyManager tm = (TelephonyManager)CoreUtil.getContext().getSystemService("phone");
                if (Build.VERSION.SDK_INT >= 26) {
                    return tm.getImei();
                }
                return tm.getDeviceId();
            }
            catch (SecurityException e) {
                imei = "";
            }
        }
        mImei = !TextUtils.isEmpty((CharSequence)imei) && imei.length() >= 15 ? EncoderUtil.EncoderByAlgorithm(imei) : imei;
        return mImei;
    }

    public static String getTimeZone() {
        String timeZone = "";
        try {
            TimeZone tz = TimeZone.getDefault();
            return DeviceInfo.createGmtOffsetString(true, true, tz.getRawOffset());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return timeZone;
        }
    }

    private static String createGmtOffsetString(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {
        int offsetMinutes = offsetMillis / 60000;
        char sign = '+';
        if (offsetMinutes < 0) {
            sign = '-';
            offsetMinutes = -offsetMinutes;
        }
        StringBuilder builder = new StringBuilder(9);
        if (includeGmt) {
            builder.append("GMT");
        }
        builder.append(sign);
        DeviceInfo.appendNumber(builder, 2, offsetMinutes / 60);
        if (includeMinuteSeparator) {
            builder.append(':');
        }
        DeviceInfo.appendNumber(builder, 2, offsetMinutes % 60);
        return builder.toString();
    }

    private static void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public static String getGAId() {
        if (mGAId == null || mGAId.length() == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
                        mGAId = adInfo.getId();
                        LogUtils.i("advertisingId is " + mGAId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
        }
        return mGAId;
    }

    private static boolean isCurrentMainThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    public static String getGAIdInThread() {
        if (DeviceInfo.isCurrentMainThread()) {
            return DeviceInfo.getGAId();
        }
        if (mGAId != null && mGAId.length() != 0) {
            return mGAId;
        }
        try {
            AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
            mGAId = adInfo.getId();
            LogUtils.i("advertisingId is " + mGAId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mGAId;
    }

    public static String getIMSI() {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (0 != context.getPackageManager().checkPermission("android.permission.READ_PHONE_STATE", context.getApplicationContext().getPackageName())) {
                return DeviceInfo.getSimOperator();
            }
            String subscriberId = null;
            if (null != tm) {
                subscriberId = tm.getSubscriberId();
            }
            if (null == subscriberId) {
                return "";
            }
            if (subscriberId.length() < 8) {
                return "";
            }
            return subscriberId.substring(0, 8);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getSimOperator() {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (null == tm) {
                return "";
            }
            return tm.getSimOperator();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getBTMAC() {
        try {
            BluetoothAdapter m_BluetoothAdapter = null;
            m_BluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
            boolean lack = PermissionUtil.lacksPermission("android.permission.BLUETOOTH");
            if (!lack && m_BluetoothAdapter != null) {
                return m_BluetoothAdapter.getAddress();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isPad() {
        Context context = CoreUtil.getContext();
        if (context.getResources() != null) {
            return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
        }
        return false;
    }

    public static String getAndroidID() {
        if (!TextUtils.isEmpty((CharSequence)mAndroidId)) {
            return mAndroidId;
        }
        Context context = CoreUtil.getContext();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (!TextUtils.isEmpty((CharSequence)androidId)) {
            androidId = androidId.trim();
        }
        mAndroidId = TextUtils.isEmpty((CharSequence)androidId) ? "" : EncoderUtil.EncoderByAlgorithm(androidId);
        return mAndroidId;
    }

    public static String getIMEI(int slotId) {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            Method method = manager.getClass().getMethod("getImei", Integer.TYPE);
            String imei = (String)method.invoke((Object)manager, slotId);
            if (TextUtils.isEmpty((CharSequence)imei)) {
                method = manager.getClass().getMethod("getDeviceId", Integer.TYPE);
                imei = (String)method.invoke((Object)manager, slotId);
            }
            if (!TextUtils.isEmpty((CharSequence)imei) && imei.length() >= 15) {
                return EncoderUtil.EncoderByAlgorithm(imei);
            }
            return imei;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getOSVersion() {
        if (TextUtils.isEmpty((CharSequence)osVersion)) {
            try {
                Class<?> cls = Class.forName("android.os.SystemProperties");
                Method method = cls.getMethod("get", String.class, String.class);
                osVersion = (String)method.invoke(null, "ro.tranos.version", "");
                if (TextUtils.isEmpty((CharSequence)osVersion)) {
                    osVersion = (String)method.invoke(null, "ro.os_product.version", "");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return osVersion;
    }

    public static String getIMSI(int slotId) {
        try {
            Context context = CoreUtil.getContext();
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            Method method = manager.getClass().getMethod("getSubscriberId", Integer.TYPE);
            String imsi = (String)method.invoke((Object)manager, slotId);
            if (!TextUtils.isEmpty((CharSequence)imsi)) {
                return EncoderUtil.EncoderByAlgorithm(imsi);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static long getTotalRAM(Context context) {
        try {
            ActivityManager manager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(info);
            return info.totalMem;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long getTotalROM(Context context) {
        try {
            StatFs statFs = new StatFs(Environment.getDataDirectory().getPath());
            return statFs.getBlockCountLong() * statFs.getBlockSizeLong();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String getBatteryCapacity(Context context) {
        double batteryCapacity = 0.0;
        String POWER_PROFILE_CLASS = "com.android.internal.os.PowerProfile";
        try {
            Object powerProfile = Class.forName("com.android.internal.os.PowerProfile").getConstructor(Context.class).newInstance(context);
            batteryCapacity = (Double)Class.forName("com.android.internal.os.PowerProfile").getMethod("getBatteryCapacity", new Class[0]).invoke(powerProfile, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(batteryCapacity + " mAh");
    }

    public static String getSerialNumber() {
        String serialno = null;
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                serialno = Build.getSerial();
            }
            catch (Exception e) {
                serialno = "";
            }
        } else {
            serialno = Build.SERIAL;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)serialno) || "unknown".equals(serialno)) {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method get = c.getMethod("get", String.class);
                serialno = (String)get.invoke(c, "ro.serialno");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TextUtils.isEmpty((CharSequence)serialno) ? "" : EncoderUtil.EncoderByAlgorithm(serialno);
    }
}

