/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.log;

import android.os.Environment;
import android.util.Log;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.Commutil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ObjectLogUtils {
    public static final int V = 2;
    public static final int D = 3;
    public static final int I = 4;
    public static final int W = 5;
    public static final int E = 6;
    public static final int A = 7;
    private static final char[] T = new char[]{'V', 'D', 'I', 'W', 'E', 'A'};
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final int FILE = 16;
    private final int JSON = 32;
    private final int XML = 48;
    private ExecutorService executor;
    private final String TOP_BORDER = "|---------------------------------------------------------------------------------------------------";
    private final String LEFT_BORDER = "| ";
    private final String BOTTOM_BORDER = "|---------------------------------------------------------------------------------------------------";
    private final int MAX_LEN = 4000;
    private final Format FORMAT = new SimpleDateFormat("MM-dd HH:mm:ss.SSS ", Locale.getDefault());
    private final String NULL_TIPS = "Log with null object.";
    private final String NULL = "null";
    private final String ARGS = "args";
    Builder builder = new Builder();
    private int invokeLayer = 0;

    private ObjectLogUtils(Builder builder) {
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void v(Object contents) {
        this.log(2, this.builder.sGlobalTag, contents);
    }

    public void v(String tag, Object ... contents) {
        this.log(2, tag, contents);
    }

    public void d(Object contents) {
        this.log(3, this.builder.sGlobalTag, contents);
    }

    public void d(String tag, Object ... contents) {
        this.log(3, tag, contents);
    }

    public void i(Object contents) {
        this.log(4, this.builder.sGlobalTag, contents);
    }

    public void i(String tag, Object ... contents) {
        this.log(4, tag, contents);
    }

    public void w(Object contents) {
        this.log(5, this.builder.sGlobalTag, contents);
    }

    public void w(String tag, Object ... contents) {
        this.log(5, tag, contents);
    }

    public void e(Object contents) {
        this.log(6, this.builder.sGlobalTag, contents);
    }

    public void e(String tag, Object ... contents) {
        this.log(6, tag, contents);
    }

    public void a(Object contents) {
        this.log(7, this.builder.sGlobalTag, contents);
    }

    public void a(String tag, Object ... contents) {
        this.log(7, tag, contents);
    }

    public void file(Object contents) {
        this.log(19, this.builder.sGlobalTag, contents);
    }

    public void file(int type, Object contents) {
        this.log(0x10 | type, this.builder.sGlobalTag, contents);
    }

    public void file(String tag, Object contents) {
        this.log(19, tag, contents);
    }

    public void file(int type, String tag, Object contents) {
        this.log(0x10 | type, tag, contents);
    }

    public void json(String contents) {
        this.log(35, this.builder.sGlobalTag, contents);
    }

    public void json(int type, String contents) {
        this.log(0x20 | type, this.builder.sGlobalTag, contents);
    }

    public void json(String tag, String contents) {
        this.log(35, tag, contents);
    }

    public void json(int type, String tag, String contents) {
        this.log(0x20 | type, tag, contents);
    }

    public void xml(String contents) {
        this.log(51, this.builder.sGlobalTag, contents);
    }

    public void xml(int type, String contents) {
        this.log(0x30 | type, this.builder.sGlobalTag, contents);
    }

    public void xml(String tag, String contents) {
        this.log(51, tag, contents);
    }

    public void xml(int type, String tag, String contents) {
        this.log(0x30 | type, tag, contents);
    }

    private void log(int type, String tag, Object ... contents) {
        String checkTag;
        String string = checkTag = tag.length() > 23 ? tag.substring(0, 23) : tag;
        if (!(Log.isLoggable((String)checkTag, (int)3) || this.builder.sLogSwitch && (this.builder.sLog2ConsoleSwitch || this.builder.sLog2FileSwitch))) {
            return;
        }
        int type_low = type & 0xF;
        int type_high = type & 0xF0;
        if (type_low < this.builder.sConsoleFilter && type_low < this.builder.sFileFilter) {
            return;
        }
        String[] tagAndHead = this.processTagAndHead(tag);
        String body = this.processBody(type_high, contents);
        if (this.builder.sLog2ConsoleSwitch && type_low >= this.builder.sConsoleFilter) {
            this.print2Console(type_low, tagAndHead[0], tagAndHead[1], body);
        }
        if ((this.builder.sLog2FileSwitch || type_high == 16) && type_low >= this.builder.sFileFilter) {
            this.print2File(type_low, tagAndHead[0], tagAndHead[2] + body);
        }
    }

    public void setInvokeLayer(int layer) {
        this.invokeLayer = layer;
    }

    private String[] processTagAndHead(String tag) {
        if (!this.builder.sTagIsSpace && !this.builder.sLogHeadSwitch) {
            tag = this.builder.sGlobalTag;
        } else {
            StackTraceElement targetElement = Thread.currentThread().getStackTrace()[5 + this.invokeLayer];
            String className = targetElement.getClassName();
            String[] classNameInfo = className.split("\\.");
            if (classNameInfo.length > 0) {
                className = classNameInfo[classNameInfo.length - 1];
            }
            if (className.contains("$")) {
                className = className.split("\\$")[0];
            }
            if (this.builder.sTagIsSpace) {
                String string = tag = ObjectLogUtils.isSpace(tag) ? className : tag;
            }
            if (this.builder.sLogHeadSwitch) {
                String head = new Formatter().format("%s, %s(%s.java:%d)", Thread.currentThread().getName(), targetElement.getMethodName(), className, targetElement.getLineNumber()).toString();
                return new String[]{tag, head + LINE_SEP, " [" + head + "]: "};
            }
        }
        return new String[]{tag, "", ": "};
    }

    private String processBody(int type, Object ... contents) {
        String body = "Log with null object.";
        if (contents != null) {
            if (contents.length == 1) {
                Object object = contents[0];
                String string = body = object == null ? "null" : object.toString();
                if (type == 32) {
                    body = ObjectLogUtils.formatJson(body);
                } else if (type == 48) {
                    body = this.formatXml(body);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                int len = contents.length;
                for (int i = 0; i < len; ++i) {
                    Object content = contents[i];
                    sb.append("args").append("[").append(i).append("]").append(" = ").append(content == null ? "null" : content.toString()).append(LINE_SEP);
                }
                body = sb.toString();
            }
        }
        return body;
    }

    private static String formatJson(String json) {
        try {
            if (json.startsWith("{")) {
                json = new JSONObject(json).toString(4);
            } else if (json.startsWith("[")) {
                json = new JSONArray(json).toString(4);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    private String formatXml(String xml) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(xmlInput, xmlOutput);
            xml = xmlOutput.getWriter().toString().replaceFirst(">", ">" + LINE_SEP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    private void print2Console(int type, String tag, String header, String msg) {
        int len;
        int countOfSub;
        if (this.builder.sLogHeadSwitch) {
            ObjectLogUtils.print(type, tag, "\n" + header);
        } else {
            ObjectLogUtils.print(type, tag, " \n");
        }
        if (this.builder.sLogBorderSwitch) {
            ObjectLogUtils.print(type, tag, "|---------------------------------------------------------------------------------------------------");
            msg = this.addLeftBorder(msg);
        }
        if ((countOfSub = (len = msg.length()) / 4000) > 0) {
            String sub;
            ObjectLogUtils.print(type, tag, msg.substring(0, 4000));
            int index = 4000;
            for (int i = 1; i < countOfSub; ++i) {
                sub = msg.substring(index, index + 4000);
                ObjectLogUtils.print(type, tag, this.builder.sLogBorderSwitch ? "| " + sub : sub);
                index += 4000;
            }
            sub = msg.substring(index, len);
            ObjectLogUtils.print(type, tag, this.builder.sLogBorderSwitch ? "| " + sub : sub);
        } else {
            ObjectLogUtils.print(type, tag, msg);
        }
        if (this.builder.sLogBorderSwitch) {
            ObjectLogUtils.print(type, tag, "|---------------------------------------------------------------------------------------------------");
        }
    }

    private static void print(int type, String tag, String msg) {
        Log.println((int)type, (String)tag, (String)msg);
    }

    private String addLeftBorder(String msg) {
        String[] lines;
        if (!this.builder.sLogBorderSwitch) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines = msg.split(LINE_SEP)) {
            sb.append("| ").append(line).append(LINE_SEP);
        }
        return sb.toString();
    }

    private void print2File(int type, final String tag, String msg) {
        String fullPath;
        Date now = new Date(System.currentTimeMillis());
        String format = this.FORMAT.format(now);
        String date = format.substring(0, 5);
        String time = format.substring(6);
        if (this.builder.defaultDir == null) {
            if ("mounted".equals(Environment.getExternalStorageState()) && Commutil.getExternalCacheDir(CoreUtil.getContext()) != null) {
                this.builder.defaultDir = Commutil.getExternalCacheDir(CoreUtil.getContext()) + ObjectLogUtils.FILE_SEP + "log" + ObjectLogUtils.FILE_SEP;
            } else {
                this.builder.defaultDir = CoreUtil.getContext().getCacheDir() + ObjectLogUtils.FILE_SEP + "log" + ObjectLogUtils.FILE_SEP;
            }
        }
        if (!ObjectLogUtils.createOrExistsFile(fullPath = (this.builder.dir == null ? this.builder.defaultDir : this.builder.dir) + date + ".txt")) {
            Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(time).append(T[type - 2]).append("/").append(tag).append(msg).append(LINE_SEP);
        final String content = sb.toString();
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                BufferedWriter bw = null;
                try {
                    bw = new BufferedWriter(new FileWriter(fullPath, true));
                    bw.write(content);
                    Log.d((String)tag, (String)("log to " + fullPath + " success!"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)tag, (String)("log to " + fullPath + " failed!"));
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!ObjectLogUtils.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Deflater compressor = new Deflater(1);
        try {
            compressor.setInput(input);
            compressor.finish();
            byte[] buf = new byte[2048];
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                bos.write(buf, 0, count);
            }
        }
        finally {
            compressor.end();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompress(byte[] input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Inflater decompressor = new Inflater();
        try {
            decompressor.setInput(input);
            byte[] buf = new byte[2048];
            while (!decompressor.finished()) {
                int count = 0;
                try {
                    count = decompressor.inflate(buf);
                }
                catch (DataFormatException e) {
                    e.printStackTrace();
                }
                bos.write(buf, 0, count);
            }
        }
        finally {
            decompressor.end();
        }
        return bos.toByteArray();
    }

    public static class Builder {
        private boolean sLogSwitch = false;
        private boolean sLog2ConsoleSwitch = true;
        private String sGlobalTag = null;
        private boolean sTagIsSpace = true;
        private boolean sLogHeadSwitch = true;
        private boolean sLog2FileSwitch = false;
        private boolean sLogBorderSwitch = true;
        private int sConsoleFilter = 2;
        private int sFileFilter = 2;
        private String defaultDir;
        private String dir;

        public Builder setLogSwitch(boolean logSwitch) {
            this.sLogSwitch = logSwitch;
            return this;
        }

        public Builder setConsoleSwitch(boolean consoleSwitch) {
            this.sLog2ConsoleSwitch = consoleSwitch;
            return this;
        }

        public Builder setGlobalTag(String tag) {
            if (ObjectLogUtils.isSpace(tag)) {
                this.sGlobalTag = "";
                this.sTagIsSpace = true;
            } else {
                this.sGlobalTag = tag;
                this.sTagIsSpace = false;
            }
            return this;
        }

        public Builder setLogHeadSwitch(boolean logHeadSwitch) {
            this.sLogHeadSwitch = logHeadSwitch;
            return this;
        }

        public Builder setLog2FileSwitch(boolean log2FileSwitch) {
            this.sLog2FileSwitch = log2FileSwitch;
            return this;
        }

        public Builder setDir(String dir) {
            this.dir = ObjectLogUtils.isSpace(dir) ? null : (dir.endsWith(FILE_SEP) ? dir : dir + FILE_SEP);
            return this;
        }

        public Builder setDir(File dir) {
            this.dir = dir == null ? null : dir.getAbsolutePath() + FILE_SEP;
            return this;
        }

        public Builder setBorderSwitch(boolean borderSwitch) {
            this.sLogBorderSwitch = borderSwitch;
            return this;
        }

        public Builder setConsoleFilter(int consoleFilter) {
            this.sConsoleFilter = consoleFilter;
            return this;
        }

        public Builder setFileFilter(int fileFilter) {
            this.sFileFilter = fileFilter;
            return this;
        }

        public String toString() {
            return "switch: " + this.sLogSwitch + LINE_SEP + "console: " + this.sLog2ConsoleSwitch + LINE_SEP + "tag: " + (this.sTagIsSpace ? "null" : this.sGlobalTag) + LINE_SEP + "head: " + this.sLogHeadSwitch + LINE_SEP + "file: " + this.sLog2FileSwitch + LINE_SEP + "dir: " + (this.dir == null ? this.defaultDir : this.dir) + LINE_SEP + "border: " + this.sLogBorderSwitch + LINE_SEP + "consoleFilter: " + T[this.sConsoleFilter - 2] + LINE_SEP + "fileFilter: " + T[this.sFileFilter - 2];
        }

        public ObjectLogUtils create() {
            return new ObjectLogUtils(this);
        }
    }
}

