/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.pool;

import com.transsion.core.pool.PoolManagerImpl;
import com.transsion.core.pool.TranssionPoolExecutor;
import java.lang.ref.WeakReference;
import java.util.concurrent.ThreadPoolExecutor;

public class TranssionPoolManager
implements PoolManagerImpl {
    private static volatile TranssionPoolManager mInstance;
    private ThreadPoolExecutor executor;
    private static ThreadPoolExecutor sDefaultExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TranssionPoolManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<TranssionPoolManager> clazz = TranssionPoolManager.class;
        synchronized (TranssionPoolManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new TranssionPoolManager();
            TranssionPoolManager.mInstance.executor = sDefaultExecutor != null ? sDefaultExecutor : TranssionPoolExecutor.newTranssionExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TranssionPoolManager getInstance(int poolSize) {
        if (mInstance != null) return mInstance;
        Class<TranssionPoolManager> clazz = TranssionPoolManager.class;
        synchronized (TranssionPoolManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new TranssionPoolManager();
            TranssionPoolManager.mInstance.executor = sDefaultExecutor != null ? sDefaultExecutor : TranssionPoolExecutor.newTranssionExecutor(poolSize);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public static void setDefaultExecutor(ThreadPoolExecutor executor) {
        sDefaultExecutor = executor;
    }

    @Override
    public void addTask(Runnable newTask) {
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor.prestartAllCoreThreads();
            }
            this.executor.execute(newTask);
        }
    }

    @Override
    public void destroy() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void purge() {
        if (this.executor != null) {
            this.executor.purge();
        }
    }

    @Override
    public void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Override
    public void execute(WeakReference<Runnable> request) {
        Runnable runnable = (Runnable)request.get();
        if (runnable != null) {
            this.addTask(runnable);
        }
    }
}

