/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.core.utils;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.PermissionUtil;

public class NetUtil {
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    private static final int NETWORK_TYPE_WIFI = -101;
    public static final int NETWORK_CLASS_WIFI = -101;
    public static final int NETWORK_CLASS_UNAVAILABLE = -1;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    private static final int NETWORK_TYPE_UNKNOWN = 0;
    private static final int NETWORK_TYPE_GPRS = 1;
    private static final int NETWORK_TYPE_EDGE = 2;
    private static final int NETWORK_TYPE_UMTS = 3;
    private static final int NETWORK_TYPE_CDMA = 4;
    private static final int NETWORK_TYPE_EVDO_0 = 5;
    private static final int NETWORK_TYPE_EVDO_A = 6;
    private static final int NETWORK_TYPE_1xRTT = 7;
    private static final int NETWORK_TYPE_HSDPA = 8;
    private static final int NETWORK_TYPE_HSUPA = 9;
    private static final int NETWORK_TYPE_HSPA = 10;
    private static final int NETWORK_TYPE_IDEN = 11;
    private static final int NETWORK_TYPE_EVDO_B = 12;
    private static final int NETWORK_TYPE_LTE = 13;
    private static final int NETWORK_TYPE_EHRPD = 14;
    private static final int NETWORK_TYPE_HSPAP = 15;

    public static boolean checkNetworkState() {
        if (CoreUtil.getContext().getApplicationContext() == null) {
            return false;
        }
        ConnectivityManager connectMgr = (ConnectivityManager)CoreUtil.getContext().getApplicationContext().getSystemService("connectivity");
        if (connectMgr == null) {
            return false;
        }
        NetworkInfo nwInfo = null;
        try {
            nwInfo = connectMgr.getActiveNetworkInfo();
        }
        catch (Exception e) {
            nwInfo = null;
        }
        return nwInfo != null && nwInfo.isAvailable();
    }

    public static String getWLANMAC() {
        try {
            if (CoreUtil.getContext().getApplicationContext() != null) {
                WifiManager wifi = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
                boolean lack = PermissionUtil.lacksPermission("android.permission.ACCESS_WIFI_STATE");
                if (!lack) {
                    WifiInfo info = wifi.getConnectionInfo();
                    return info.getMacAddress();
                }
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getNetworkOperatorName() {
        if (NetUtil.getTeleMgr() == null) {
            return "";
        }
        return NetUtil.getTeleMgr().getNetworkOperatorName();
    }

    public static String getNetworkOperator() {
        if (NetUtil.getTeleMgr() == null) {
            return "";
        }
        return NetUtil.getTeleMgr().getNetworkOperator();
    }

    public static String getNetworkCountryIso() {
        if (NetUtil.getTeleMgr() == null) {
            return "";
        }
        return NetUtil.getTeleMgr().getNetworkCountryIso();
    }

    private static TelephonyManager getTeleMgr() {
        if (CoreUtil.getContext().getApplicationContext() == null) {
            return null;
        }
        TelephonyManager teleMgr = (TelephonyManager)CoreUtil.getContext().getApplicationContext().getSystemService("phone");
        return teleMgr;
    }

    public static int getNetworkType() {
        int networkType = 0;
        try {
            if (CoreUtil.getContext().getApplicationContext() == null && CoreUtil.getContext().getApplicationContext().getSystemService("connectivity") == null) {
                return 0;
            }
            NetworkInfo network = ((ConnectivityManager)CoreUtil.getContext().getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected()) {
                int type = network.getType();
                if (type == 1) {
                    networkType = -101;
                } else if (type == 0) {
                    TelephonyManager telephonyManager = (TelephonyManager)CoreUtil.getContext().getApplicationContext().getSystemService("phone");
                    networkType = telephonyManager.getNetworkType();
                }
            } else {
                networkType = -1;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return NetUtil.classifyNetType(networkType);
    }

    private static int classifyNetType(int networkType) {
        switch (networkType) {
            case -1: {
                return -1;
            }
            case -101: {
                return -101;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 2;
            }
            case 13: {
                return 3;
            }
        }
        return 0;
    }
}

