/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice;

import android.content.Context;
import android.content.SharedPreferences;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;

public abstract class PeriodicSubJob
extends SubJob {
    public static final long DEFAULT_FLEX_MILLIS = 300000L;
    private long mPeroid;
    private String mTimeKey;
    private long mFlexTime;

    public PeriodicSubJob(SubJobHolder holder, Context context, long period, String tagKey) {
        this(holder, context, period, 300000L, tagKey);
    }

    public PeriodicSubJob(SubJobHolder holder, Context context, long period, long flexTime, String tagKey) {
        super(holder, context);
        this.mPeroid = period;
        this.mTimeKey = "time_key_of_" + tagKey;
        this.mFlexTime = flexTime;
    }

    @Override
    public boolean timeToDoJob() {
        SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
        long currTime = System.currentTimeMillis();
        long interval = currTime - setting.getLong(this.mTimeKey, 0L);
        if (interval < 0L) {
            return true;
        }
        return interval + this.mFlexTime > this.mPeroid;
    }

    @Override
    public void finish(boolean success) {
        super.finish(success);
        if (success) {
            long currTime = System.currentTimeMillis();
            SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
            setting.edit().putLong(this.mTimeKey, currTime).apply();
        }
    }
}

