/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.transsion.athena.data.TrackData;
import com.transsion.athenacust.AthenaCust;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import com.transsion.ga.AthenaAnalytics;
import java.util.List;
import java.util.Locale;

public class FirstBootInfoSubJob
extends SubJob {
    public static final int BOOT_TRACK_TIME = 28800000;
    public static final int BOOT_TRACK_COUNT = 8;
    public static final String KEY_TRACK_FIRST_BOOT_INFO_DONE = "track_first_boot_info_done";
    public static final String KEY_TRACK_FIRST_BOOT_TIME = "track_first_boot_time";
    public static final String KEY_TRACK_FIRST_BOOT_COUNT = "track_first_boot_count";
    public static final String KEY_TRACK_FIRST_BOOT_SIM1 = "track_first_boot_sim1";
    public static final String KEY_TRACK_FIRST_BOOT_SIM2 = "track_first_boot_sim2";

    public FirstBootInfoSubJob(SubJobHolder holder, Context context) {
        super(holder, context);
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- FirstBootInfoSubJob doJob -------");
        if (TextUtils.isEmpty((CharSequence)DCSUtils.getIMEI(0)) || TextUtils.isEmpty((CharSequence)DCSUtils.getSerialNumber())) {
            TrackData trackData = new TrackData().add("en", "device_init", 2).add("cnt", 1, 1);
            AthenaAnalytics.getInstance((int)9999).track("data_discard", trackData, 9999);
            SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
            setting.edit().putBoolean(KEY_TRACK_FIRST_BOOT_INFO_DONE, true).apply();
            this.finish(true);
            return;
        }
        Bundle eparam = new Bundle();
        eparam.putString("iid", DCSUtils.getIMEI(0));
        eparam.putString("iid2", DCSUtils.getIMEI(1));
        eparam.putString("sn", DCSUtils.getSerialNumber());
        eparam.putString("rom_size", DCSUtils.getTotalROM(CoreUtil.getContext()));
        eparam.putString("ram_size", DCSUtils.getTotalRAM(CoreUtil.getContext()));
        try {
            SubscriptionManager subscriptionManager = (SubscriptionManager)this.mContext.getSystemService("telephony_subscription_service");
            List subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
            if (subscriptionInfos != null) {
                for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
                    if (subscriptionInfo.getSimSlotIndex() == 0) {
                        eparam.putString("isd", DCSUtils.getIMSI(subscriptionInfo.getSubscriptionId()));
                        continue;
                    }
                    if (subscriptionInfo.getSimSlotIndex() != 1) continue;
                    eparam.putString("isd2", DCSUtils.getIMSI(subscriptionInfo.getSubscriptionId()));
                }
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        try {
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            if (windowManager != null) {
                DisplayMetrics dm = new DisplayMetrics();
                windowManager.getDefaultDisplay().getRealMetrics(dm);
                int screenWidth = dm.widthPixels;
                int screenHeight = dm.heightPixels;
                if (screenHeight < screenWidth) {
                    eparam.putString("resolution", screenHeight + "X" + screenWidth);
                } else {
                    eparam.putString("resolution", screenWidth + "X" + screenHeight);
                }
                double diagonalPixels = Math.sqrt(Math.pow(dm.widthPixels, 2.0) + Math.pow(dm.heightPixels, 2.0));
                eparam.putString("screen", String.format(Locale.ENGLISH, "%.1f", diagonalPixels / (double)(160.0f * dm.density)));
            }
            eparam.putString("series", DCSUtils.get(this.mContext, "ro.product.vendor.name"));
            eparam.putString("plat", DCSUtils.get(this.mContext, "ro.board.platform"));
            String fingerprint = DCSUtils.get(this.mContext, "ro.fingerprint_support");
            eparam.putString("finger", TextUtils.isEmpty((CharSequence)fingerprint) ? "0" : fingerprint);
            eparam.putString("battery", DCSUtils.getBatteryCapacity(CoreUtil.getContext()));
            eparam.putString("aid", DeviceInfo.getAndroidID());
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        new AthenaCust("device_init", 9999).trackCommon(eparam, null).submit();
        SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
        setting.edit().putBoolean(KEY_TRACK_FIRST_BOOT_INFO_DONE, true).apply();
        this.finish(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean timeToDoJob() {
        SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
        if (setting.getBoolean(KEY_TRACK_FIRST_BOOT_INFO_DONE, false)) {
            return false;
        }
        long firstBootTime = setting.getLong(KEY_TRACK_FIRST_BOOT_TIME, 0L);
        long currentTimeMillis = System.currentTimeMillis();
        try {
            boolean hitSim2;
            SubscriptionManager subscriptionManager = (SubscriptionManager)this.mContext.getSystemService("telephony_subscription_service");
            List subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
            String imsi1 = null;
            String imsi2 = null;
            if (subscriptionInfos != null) {
                for (SubscriptionInfo subscriptionInfo : subscriptionInfos) {
                    if (subscriptionInfo.getSimSlotIndex() == 0) {
                        imsi1 = DCSUtils.getIMSI(subscriptionInfo.getSubscriptionId());
                        continue;
                    }
                    if (subscriptionInfo.getSimSlotIndex() != 1) continue;
                    imsi2 = DCSUtils.getIMSI(subscriptionInfo.getSubscriptionId());
                }
            }
            DCSUtils.LOG.d((Object)("boot = " + firstBootTime + ",now = " + currentTimeMillis + ",is1 = " + imsi1 + ",is2 = " + imsi2));
            if (firstBootTime == 0L) {
                if (TextUtils.isEmpty((CharSequence)imsi1)) {
                    if (TextUtils.isEmpty((CharSequence)imsi2)) return false;
                }
                setting.edit().putLong(KEY_TRACK_FIRST_BOOT_TIME, currentTimeMillis).putInt(KEY_TRACK_FIRST_BOOT_COUNT, 1).putString(KEY_TRACK_FIRST_BOOT_SIM1, imsi1).putString(KEY_TRACK_FIRST_BOOT_SIM2, imsi2).apply();
                return false;
            }
            String sim1 = setting.getString(KEY_TRACK_FIRST_BOOT_SIM1, "");
            String sim2 = setting.getString(KEY_TRACK_FIRST_BOOT_SIM2, "");
            boolean hitSim1 = !TextUtils.isEmpty((CharSequence)sim1) && (TextUtils.equals((CharSequence)sim1, (CharSequence)imsi1) || TextUtils.equals((CharSequence)sim1, (CharSequence)imsi2));
            boolean bl = hitSim2 = !TextUtils.isEmpty((CharSequence)sim2) && (TextUtils.equals((CharSequence)sim2, (CharSequence)imsi1) || TextUtils.equals((CharSequence)sim2, (CharSequence)imsi2));
            if (hitSim1 || hitSim2) {
                int bootCount = setting.getInt(KEY_TRACK_FIRST_BOOT_COUNT, 0);
                if (bootCount <= 8) {
                    setting.edit().putInt(KEY_TRACK_FIRST_BOOT_COUNT, bootCount + 1).apply();
                    return false;
                }
                if (Math.abs(currentTimeMillis - firstBootTime) <= 28800000L) return false;
                return true;
            }
            if (TextUtils.isEmpty((CharSequence)imsi1) && TextUtils.isEmpty((CharSequence)imsi2)) {
                setting.edit().putLong(KEY_TRACK_FIRST_BOOT_TIME, 0L).putInt(KEY_TRACK_FIRST_BOOT_COUNT, 0).putString(KEY_TRACK_FIRST_BOOT_SIM1, "").putString(KEY_TRACK_FIRST_BOOT_SIM2, "").apply();
                return false;
            }
            setting.edit().putLong(KEY_TRACK_FIRST_BOOT_TIME, currentTimeMillis).putInt(KEY_TRACK_FIRST_BOOT_COUNT, 1).putString(KEY_TRACK_FIRST_BOOT_SIM1, imsi1).putString(KEY_TRACK_FIRST_BOOT_SIM2, imsi2).apply();
            return false;
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        return false;
    }
}

