/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.http;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.transsion.dataservice.http.BufferEncrypt;
import com.transsion.dataservice.http.RsaEcsPKCS1Encrypter;
import com.transsion.dataservice.http.SSLContextUtil;
import com.transsion.dataservice.util.DCSUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class HttpUtils {
    public static String PUCLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArNrm4jErOdstd1P5L1X/\nCGSS6NKf4glPrFbTM97aE9ZKGUiMALIV8W7FClAgLZdtTZkL5XEQdbX4RB/C6edc\nnN2ifla6sVu23y78FMiL6smp9ayE7Y3gSEfB3md4nvEUpyRUu4wYLIf9nVR36okK\nGCerxYdLtDbJ69Rux4lgE5C9a6qLfV6BzjJYONk/vQhGQYT6qes+TFtXV0hvF8UM\nDG+0GfA3MiQue/Ny8uIPBykDPS1dcIADzVos2fXs/o2aFTrkdVjiX8irwYBze69K\nzFx18H12iZ9gG1VztMbHetvImBoXeCOwjTc5RnGIz+Hya96pxJLK2DcSlAaHEs1H\nOQIDAQAB";
    private static SSLSocketFactory sslSocketFactory = null;

    public static String parseByte2HexStr(byte[] buf) {
        if (buf == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static String getAESKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(128);
        SecretKey sk = kg.generateKey();
        byte[] b = sk.getEncoded();
        return HttpUtils.parseByte2HexStr(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] uncompress(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream gis = null;
        try {
            int len;
            gis = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] buffer = new byte[1024];
            while ((len = gis.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        finally {
            try {
                out.close();
                if (gis != null) {
                    gis.close();
                }
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String urlString, String para, long version) {
        String out = "";
        if (para != null) {
            out = para;
        }
        HttpURLConnection urlConnection = null;
        String result = "";
        try {
            String password = HttpUtils.getAESKey();
            BufferEncrypt bufferEncrypt = new BufferEncrypt(password.getBytes());
            byte[] param = bufferEncrypt.getAESEncode(para);
            RsaEcsPKCS1Encrypter rsaCrypto = new RsaEcsPKCS1Encrypter(PUCLIC_KEY);
            String afterencrypt = Base64.encodeToString((byte[])rsaCrypto.encrypt(password), (int)2);
            out = Base64.encodeToString((byte[])param, (int)2) + "," + afterencrypt;
            URL url = new URL(urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            if (urlConnection instanceof HttpsURLConnection) {
                SSLContext sslContext;
                if (sslSocketFactory == null && (sslContext = SSLContextUtil.getSSLContext()) != null) {
                    sslSocketFactory = sslContext.getSocketFactory();
                }
                if (sslSocketFactory != null) {
                    ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslSocketFactory);
                    ((HttpsURLConnection)urlConnection).setHostnameVerifier(SSLContextUtil.myHostNameVerifier);
                }
            }
            urlConnection.setRequestProperty("accept", "*/*");
            urlConnection.setRequestProperty("Content-Length", String.valueOf(out.length()));
            urlConnection.setRequestProperty("encrypt-level", "2");
            urlConnection.setRequestProperty("ver", String.valueOf(version));
            urlConnection.setRequestProperty("vn", "1");
            urlConnection.setRequestProperty("type", "1");
            urlConnection.setRequestMethod("POST");
            urlConnection.setReadTimeout(20000);
            urlConnection.setConnectTimeout(30000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            PrintWriter printWriter = new PrintWriter(urlConnection.getOutputStream());
            printWriter.write(out);
            printWriter.flush();
            printWriter.close();
            int code = urlConnection.getResponseCode();
            DCSUtils.LOG.i((Object)("url:" + urlString + " code:" + code + " Post Data:" + para + " version:" + version));
            if (code == 200) {
                String line;
                InputStream is = urlConnection.getInputStream();
                BufferedReader bf = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
                StringBuilder buffer = new StringBuilder();
                while ((line = bf.readLine()) != null) {
                    buffer.append(line);
                }
                String httpResponse = buffer.toString();
                if (TextUtils.isEmpty((CharSequence)httpResponse) || TextUtils.equals((CharSequence)"{}", (CharSequence)httpResponse)) {
                    result = httpResponse;
                } else {
                    byte[] responseData = bufferEncrypt.getAESDecode(Base64.decode((String)httpResponse, (int)2));
                    result = new String(responseData, Charset.forName("UTF-8"));
                }
                bf.close();
                is.close();
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return result;
    }
}

