/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.http;

import android.annotation.SuppressLint;
import com.transsion.dataservice.cryper.BaseCryper;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RsaEcsPKCS1Encrypter
extends BaseCryper {
    private Cipher mDecrypter;
    private Cipher mEncrypter;
    private final byte[] mPassword;

    public RsaEcsPKCS1Encrypter(byte[] password) {
        this.mPassword = password;
    }

    public RsaEcsPKCS1Encrypter(String password) {
        this.mPassword = this.base64DecodeNoWrap(password);
    }

    @SuppressLint(value={"TrulyRandom"})
    private void ensureEncrypter() throws Exception {
        if (this.mEncrypter == null) {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.mPassword);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, pubKey);
            this.mEncrypter = cipher;
        }
    }

    private boolean ensureSignVerifier(byte[] data, byte[] sign) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(this.mPassword);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(sign);
    }

    public boolean verify(byte[] data, byte[] sign) throws Exception {
        return this.ensureSignVerifier(data, sign);
    }

    public boolean verify(String data, String sign) throws Exception {
        return this.ensureSignVerifier(data.getBytes(Charset.forName("UTF-8")), sign.getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public byte[] encrypt(byte[] data) throws Exception {
        this.ensureEncrypter();
        return this.mEncrypter.doFinal(data);
    }

    @Override
    public byte[] encrypt(String data) throws Exception {
        return this.encrypt(data.getBytes(Charset.forName("UTF-8")));
    }

    @Override
    public byte[] decrypt(byte[] data) throws Exception {
        throw new Exception("do not support decrypt mode");
    }

    @Override
    public byte[] decrypt(String data) throws Exception {
        throw new Exception("do not support decrypt mode");
    }
}

