/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.app.usage.NetworkStats;
import android.app.usage.NetworkStatsManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseLongArray;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.PeriodicSubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;

public class DataUsageSubJob
extends PeriodicSubJob {
    public static final String EVENT_DATA_USAGE = "data_use";
    public static final long PERIOD_OF_DATA_USAGE = 86400000L;
    public static final String KEY_LAST_DATAUSAGE_TIME = "last_dateusage_time";

    public DataUsageSubJob(SubJobHolder holder, Context context) {
        super(holder, context, 86400000L, "datausage");
    }

    public DataUsageSubJob(SubJobHolder holder, Context context, long period) {
        super(holder, context, period, "datausage");
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- DataUsageSubJob doJob -------");
        long currentTimeMillis = System.currentTimeMillis();
        SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
        NetworkStatsManager networkStatsManager = (NetworkStatsManager)this.mContext.getSystemService("netstats");
        if (networkStatsManager == null) {
            this.finish(true);
            return;
        }
        List<PackageInfo> packageInfoList = this.getPackageInfoList();
        LocalDate currentDate = Instant.ofEpochMilli(currentTimeMillis).atZone(ZoneId.systemDefault()).toLocalDate();
        long lastTrackTime = setting.getLong(KEY_LAST_DATAUSAGE_TIME, 0L);
        if (lastTrackTime == 0L || currentTimeMillis <= lastTrackTime) {
            LocalDateTime startDateTime = LocalDateTime.of(currentDate.minusDays(1L), LocalTime.MIN);
            long startTime = startDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            try {
                this.queryNetworkStats(networkStatsManager, packageInfoList, startTime, startTime + 86400000L - 1L);
            }
            catch (Exception e) {
                DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            }
        } else {
            LocalDate lastLocalDate;
            DCSUtils.LOG.d((Object)("track datausage last time = " + DCSUtils.transferMillisToDate(lastTrackTime) + ",current = " + DCSUtils.transferMillisToDate(currentTimeMillis)));
            if (currentTimeMillis - lastTrackTime >= 604800000L) {
                lastTrackTime = currentTimeMillis - 604800000L;
            }
            LocalDate localDate = lastLocalDate = Instant.ofEpochMilli(lastTrackTime).atZone(ZoneId.systemDefault()).toLocalDate();
            while (localDate.isBefore(currentDate)) {
                LocalDateTime startDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
                long startTime = startDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                try {
                    this.queryNetworkStats(networkStatsManager, packageInfoList, startTime, startTime + 86400000L - 1L);
                }
                catch (Exception e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
                localDate = localDate.plusDays(1L);
            }
        }
        setting.edit().putLong(KEY_LAST_DATAUSAGE_TIME, currentTimeMillis).apply();
        this.finish(true);
    }

    private void queryNetworkStats(NetworkStatsManager networkStatsManager, List<PackageInfo> packageInfoList, long startTime, long endTime) throws Exception {
        DCSUtils.LOG.i((Object)("track data usage time = " + DCSUtils.transferMillisToDate(startTime)));
        PackageManager packageManager = this.mContext.getPackageManager();
        int[] networkTypes = new int[]{1, 0};
        for (int i = 0; i < networkTypes.length; ++i) {
            SparseLongArray uidByteArray = new SparseLongArray();
            NetworkStats networkStats = networkStatsManager.querySummary(networkTypes[i], null, startTime, endTime);
            if (networkStats != null) {
                NetworkStats.Bucket bucket = new NetworkStats.Bucket();
                while (networkStats.getNextBucket(bucket)) {
                    long byteSize = bucket.getTxBytes() + bucket.getRxBytes() + uidByteArray.get(bucket.getUid(), 0L);
                    uidByteArray.put(bucket.getUid(), byteSize);
                }
            }
            for (PackageInfo packageInfo : packageInfoList) {
                long byteSize = uidByteArray.get(packageInfo.applicationInfo.uid, 0L);
                if (byteSize <= 1024L) continue;
                Bundle eparam = new Bundle();
                eparam.putString("pkg", packageInfo.packageName);
                eparam.putString("vn", packageInfo.versionName);
                eparam.putString("vc", String.valueOf(packageInfo.versionCode));
                try {
                    String installerPkg = packageManager.getInstallerPackageName(packageInfo.packageName);
                    eparam.putString("ch", installerPkg != null ? installerPkg : "");
                    eparam.putInt("is_system", DCSUtils.isSystemApp(packageInfo.packageName, packageManager) ? 1 : 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                eparam.putInt("net", i + 1);
                eparam.putLong("data", this.byteToKB(byteSize));
                eparam.putString("start_date", DCSUtils.transferMillisToDate("yyyy-MM-dd", startTime));
                new AthenaCust(EVENT_DATA_USAGE, 9999).trackCommon(eparam, null).submit();
            }
        }
    }

    private List<PackageInfo> getPackageInfoList() {
        ArrayList<PackageInfo> packageInfoList = new ArrayList<PackageInfo>();
        try {
            PackageManager packageManager = this.mContext.getPackageManager();
            List applicationInfoList = packageManager.getInstalledPackages(0);
            block4: for (PackageInfo info : applicationInfoList) {
                try {
                    PackageInfo pack = packageManager.getPackageInfo(info.packageName, 4096);
                    String[] requestedPermissions = pack.requestedPermissions;
                    if (requestedPermissions == null || info.applicationInfo.uid == 1000) continue;
                    for (String str : requestedPermissions) {
                        if (!"android.permission.INTERNET".equals(str)) continue;
                        packageInfoList.add(info);
                        continue block4;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                }
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        return packageInfoList;
    }

    private long byteToKB(long data) {
        return data / 1024L;
    }

    @Override
    public void finish(boolean success) {
        super.finish(success);
    }

    @Override
    public boolean timeToDoJob() {
        return super.timeToDoJob();
    }

    private class MergeAppDateUsage {
        long byteSize;
        PackageInfo packageInfo;

        private MergeAppDateUsage(long byteSize, PackageInfo packageInfo) {
            this.byteSize = byteSize;
            this.packageInfo = packageInfo;
        }
    }
}

