/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.app.usage.NetworkStats;
import android.app.usage.NetworkStatsManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.SubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;

public class DeviceActiveSubJob
extends SubJob {
    public static final String KEY_TRACK_ACTIVE_DAY = "track_active_day";

    public DeviceActiveSubJob(SubJobHolder holder, Context context) {
        super(holder, context);
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.i((Object)"------- DeviceActiveSubJob doJob -------");
        LocalDateTime endDate = LocalDateTime.of(LocalDate.now(), LocalTime.of(LocalTime.now().getHour(), 0, 0, 0));
        long endTime = endDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        LocalDateTime startDate = endDate.minusHours(1L);
        long startTime = startDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        try {
            int[] networkTypes;
            NetworkStatsManager networkStatsManager = (NetworkStatsManager)this.mContext.getSystemService("netstats");
            if (networkStatsManager == null) {
                this.finish(true);
                return;
            }
            for (int networkType : networkTypes = new int[]{1, 0}) {
                NetworkStats.Bucket bucket = networkStatsManager.querySummaryForDevice(networkType, null, startTime, endTime);
                if (bucket == null || bucket.getRxBytes() + bucket.getTxBytes() <= 0L) continue;
                Bundle eparam = new Bundle();
                eparam.putString("sn", DCSUtils.getSerialNumber());
                new AthenaCust("device_active", 9999).trackCommon(eparam, null).submit();
                break;
            }
        }
        catch (Exception e) {
            DCSUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        this.finish(true);
    }

    @Override
    public boolean timeToDoJob() {
        SharedPreferences setting = this.mContext.getSharedPreferences("shared_preference_of_dcs", 0);
        return setting.getBoolean("track_first_boot_info_done", false);
    }
}

