/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.dataservice.track;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import com.transsion.athenacust.AthenaCust;
import com.transsion.dataservice.PeriodicSubJob;
import com.transsion.dataservice.SubJobHolder;
import com.transsion.dataservice.util.DCSUtils;
import java.util.ArrayList;
import java.util.List;

public class IAppListSubJob
extends PeriodicSubJob {
    public static final String EVENT_IAPP = "iapp_list";
    public static final long PERIOD_OF_APP_LIST = 86400000L;

    public IAppListSubJob(SubJobHolder holder, Context context) {
        super(holder, context, 86400000L, "iapplist");
    }

    public IAppListSubJob(SubJobHolder holder, Context context, long period) {
        super(holder, context, period, "iapplist");
    }

    @Override
    public void doJob() {
        DCSUtils.LOG.d((Object)"------- IAppListSubJob doJob -------");
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList<Bundle> appList = new ArrayList<Bundle>();
        Bundle ext = null;
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        List packageInfos = pm.queryIntentActivities(intent, 0);
        for (int i = 0; i < packageInfos.size(); ++i) {
            String packageName = ((ResolveInfo)packageInfos.get((int)i)).activityInfo.packageName;
            PackageInfo pi = null;
            try {
                pi = pm.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            Bundle bundle = new Bundle();
            bundle.putString("pkg", packageName);
            bundle.putString("vn", pi != null ? pi.versionName : "0");
            bundle.putString("vc", pi != null ? String.valueOf(pi.versionCode) : "0");
            try {
                String installerPkg = pm.getInstallerPackageName(packageName);
                bundle.putString("ch", installerPkg != null ? installerPkg : "");
            }
            catch (Exception exception) {
                // empty catch block
            }
            bundle.putInt("is_system", DCSUtils.isSystemApp(packageName, pm) ? 1 : 0);
            appList.add(bundle);
        }
        if (appList.size() <= 3000) {
            new AthenaCust(EVENT_IAPP, 9999).trackCommon(appList, ext).submit();
        }
        this.finish(true);
    }
}

