/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.geoip;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.transsion.core.CoreUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class IpGetUtil {
    public static String getIPAddress() {
        NetworkInfo info = ((ConnectivityManager)CoreUtil.getContext().getSystemService("connectivity")).getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getType() == 0) {
                try {
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        NetworkInterface intf = en.nextElement();
                        Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                        while (enumIpAddr.hasMoreElements()) {
                            InetAddress inetAddress = enumIpAddr.nextElement();
                            if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                            return inetAddress.getHostAddress();
                        }
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            } else if (info.getType() == 1) {
                WifiManager wifiManager = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return IpGetUtil.intIP2StringIP(wifiInfo.getIpAddress());
            }
        }
        return null;
    }

    public static String intIP2StringIP(int ip) {
        return (ip & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 24 & 0xFF);
    }
}

