/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import com.transsin.networkmonitor.ExtensionKt;
import com.transsin.networkmonitor.MonitorData;
import com.transsin.networkmonitor.NetworkMonitor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J*\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J2\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0016J&\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0018\u00102\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\nH\u0016J\u0018\u00103\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\rH\u0016J\u0010\u00105\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u00106\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u00107\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010;\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\rH\u0016J\u0010\u0010<\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010=\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010>\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010B\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0010\u0010E\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/transsin/networkmonitor/MonitorEventListener;", "Lokhttp3/EventListener;", "listener", "usage", "", "isTest", "", "(Lokhttp3/EventListener;IZ)V", "errorCode", "errorMsg", "", "httpCode", "mCallStartTime", "", "mDnsStartTime", "mMonitorData", "Lcom/transsin/networkmonitor/MonitorData;", "mReqBodyEndTime", "mReqHeadersEndTime", "mReqHeadersStartTime", "mRespHeadersEndTime", "mRespHeadersStartTime", "mSecureConnectStartTime", "mTcpStartTime", "callEnd", "", "call", "Lokhttp3/Call;", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "dnsEnd", "domainName", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "requestBodyEnd", "byteCount", "requestBodyStart", "requestFailed", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseHeadersStart", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "lib-networkmonitor_release"})
public final class MonitorEventListener
extends EventListener {
    @Nullable
    private final EventListener listener;
    private final int usage;
    private final boolean isTest;
    private long mCallStartTime;
    private long mDnsStartTime;
    private long mSecureConnectStartTime;
    private long mTcpStartTime;
    private long mReqHeadersStartTime;
    private long mReqHeadersEndTime;
    private long mReqBodyEndTime;
    private long mRespHeadersStartTime;
    @NotNull
    private final MonitorData mMonitorData;
    private long mRespHeadersEndTime;
    private int httpCode;
    private int errorCode;
    @NotNull
    private String errorMsg;

    public MonitorEventListener(@Nullable EventListener listener, int usage, boolean isTest) {
        this.listener = listener;
        this.usage = usage;
        this.isTest = isTest;
        this.mMonitorData = MonitorData.Companion.create(this.usage, this.isTest);
        this.httpCode = -1;
        this.errorCode = -1;
        this.errorMsg = "Unknown";
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callStart(call);
        ExtensionKt.printEvent("[callStart]");
        try {
            String string;
            String host;
            String string2;
            String isDownload;
            String string3 = isDownload = call.request().headers().get("isDownload");
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                this.mMonitorData.setUsage(Intrinsics.areEqual((Object)it, (Object)"true") ? 1 : 0);
            }
            if ((string2 = (host = call.request().url().host())) == null) {
                string2 = "";
            }
            this.mMonitorData.setHost(string2);
            String string4 = call.request().url().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"call.request().url().toString()");
            String url = string4;
            if (this.usage == 0 && StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
                String string5 = url.substring(0, StringsKt.indexOf$default((CharSequence)url, (String)"?", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string5;
            } else {
                string = url;
            }
            this.mMonitorData.setServerApi(string);
        }
        catch (Exception e) {
            ExtensionKt.printErrEvent("[get header exception] " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        this.mCallStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callStart(call);
        }
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        super.dnsStart(call, domainName);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[dnsStart] domainName: ", (Object)domainName));
        this.mDnsStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.dnsStart(call, domainName);
        }
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        super.dnsEnd(call, domainName, inetAddressList);
        String addresses = CollectionsKt.joinToString$default((Iterable)inetAddressList, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[dnsEnd] inetAddressList ", (Object)addresses));
        this.mMonitorData.setDnsTime(ExtensionKt.realtimeDiff(this.mDnsStartTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.dnsEnd(call, domainName, inetAddressList);
        }
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectStart(call, inetSocketAddress, proxy);
        this.mTcpStartTime = ExtensionKt.realtime();
        String string = inetSocketAddress.getAddress().getHostAddress();
        if (string == null) {
            string = "";
        }
        this.mMonitorData.setIpAddr(string);
        ExtensionKt.printEvent("[connectStart] inetSocketAddress : " + inetSocketAddress + ", proxy : " + proxy);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectStart(call, inetSocketAddress, proxy);
        }
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectStart(call);
        ExtensionKt.printEvent("[secureConnectStart]");
        this.mSecureConnectStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.secureConnectStart(call);
        }
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectEnd(call, handshake);
        ExtensionKt.printEvent("[secureConnectEnd]");
        this.mMonitorData.setSslTime(ExtensionKt.realtimeDiff(this.mSecureConnectStartTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.secureConnectEnd(call, handshake);
        }
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[connectEnd] inetSocketAddress ", (Object)inetSocketAddress));
        this.mMonitorData.setTcpTime(ExtensionKt.realtimeDiff(this.mTcpStartTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectEnd(call, inetSocketAddress, proxy, protocol);
        }
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        ExtensionKt.printErrEvent("[connectFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        this.errorCode = 101;
        this.errorMsg = ExtensionKt.shortMsg(ioe);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        }
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionReleased(call, connection);
        ExtensionKt.printEvent("[connectionReleased]");
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectionReleased(call, connection);
        }
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionAcquired(call, connection);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[connectionAcquired] connection: ", (Object)connection));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectionAcquired(call, connection);
        }
    }

    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestHeadersStart(call);
        ExtensionKt.printEvent("[requestHeadersStart]");
        this.mReqHeadersStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestHeadersStart(call);
        }
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super.requestHeadersEnd(call, request);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[requestHeadersEnd] request :", (Object)request));
        this.mReqHeadersEndTime = ExtensionKt.realtime();
        this.mMonitorData.setSendTime(this.mReqHeadersEndTime - this.mReqHeadersStartTime);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestHeadersEnd(call, request);
        }
    }

    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestBodyStart(call);
        ExtensionKt.printEvent("[requestBodyStart]");
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestBodyStart(call);
        }
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestBodyEnd(call, byteCount);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[requestBodyEnd] byteCount: ", (Object)byteCount));
        this.mReqBodyEndTime = ExtensionKt.realtime();
        MonitorData $this$requestBodyEnd_u24lambda_u2d1 = this.mMonitorData;
        boolean bl = false;
        $this$requestBodyEnd_u24lambda_u2d1.setReqBodySize(byteCount);
        $this$requestBodyEnd_u24lambda_u2d1.setSendTime(this.mReqBodyEndTime - this.mReqHeadersStartTime);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestBodyEnd(call, byteCount);
        }
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.requestFailed(call, ioe);
        ExtensionKt.printErrEvent("[requestFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        this.errorCode = 102;
        this.errorMsg = ExtensionKt.shortMsg(ioe);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestFailed(call, ioe);
        }
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseHeadersStart(call);
        ExtensionKt.printEvent("[responseHeadersStart]");
        this.mRespHeadersStartTime = ExtensionKt.realtime();
        this.mMonitorData.setWaitTime(this.mRespHeadersStartTime - Long.max(this.mReqBodyEndTime, this.mReqHeadersEndTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseHeadersStart(call);
        }
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        super.responseHeadersEnd(call, response);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[responseHeadersEnd] code : ", (Object)response.code()));
        String string = response.headers().get("x-response-cdn");
        if (string == null) {
            string = "";
        }
        String provider = string;
        ExtensionKt.printEvent(provider);
        this.mMonitorData.setCdnProvider(provider);
        this.mRespHeadersEndTime = ExtensionKt.realtime();
        this.mMonitorData.setRecTime(ExtensionKt.realtimeDiff(this.mRespHeadersStartTime));
        this.mMonitorData.setCdnReqTime(ExtensionKt.realtimeDiff(this.mCallStartTime));
        this.httpCode = response.code();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseHeadersEnd(call, response);
        }
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyStart(call);
        ExtensionKt.printEvent("[responseBodyStart]");
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseBodyStart(call);
        }
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyEnd(call, byteCount);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[responseBodyEnd] byteCount: ", (Object)byteCount));
        MonitorData $this$responseBodyEnd_u24lambda_u2d2 = this.mMonitorData;
        boolean bl = false;
        $this$responseBodyEnd_u24lambda_u2d2.setResBodySize(byteCount);
        $this$responseBodyEnd_u24lambda_u2d2.setRecTime(ExtensionKt.realtimeDiff(this.mRespHeadersStartTime));
        $this$responseBodyEnd_u24lambda_u2d2.setCdnDownTime(ExtensionKt.realtimeDiff(this.mRespHeadersEndTime));
        $this$responseBodyEnd_u24lambda_u2d2.setCdnSpeed(String.valueOf((float)byteCount / 1024.0f / ((float)$this$responseBodyEnd_u24lambda_u2d2.getCdnDownTime() / 1000.0f)));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseBodyEnd(call, byteCount);
        }
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.responseFailed(call, ioe);
        ExtensionKt.printErrEvent("[responseFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        this.errorCode = 103;
        this.errorMsg = ExtensionKt.shortMsg(ioe);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseFailed(call, ioe);
        }
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callEnd(call);
        ExtensionKt.printEvent("[callEnd]");
        MonitorData $this$callEnd_u24lambda_u2d3 = this.mMonitorData;
        boolean bl = false;
        $this$callEnd_u24lambda_u2d3.setCallResultCode(1);
        $this$callEnd_u24lambda_u2d3.setReqTime(ExtensionKt.realtimeDiff(this.mCallStartTime));
        $this$callEnd_u24lambda_u2d3.setErrorCode(this.httpCode);
        if ($this$callEnd_u24lambda_u2d3.getErrorCode() != -1 && $this$callEnd_u24lambda_u2d3.getErrorCode() != 304 && !this.mMonitorData.isTestModel()) {
            ExtensionKt.track($this$callEnd_u24lambda_u2d3);
        }
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callEnd(call);
        }
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.callFailed(call, ioe);
        ExtensionKt.printErrEvent("[callFailed]  " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        this.mMonitorData.setCallResultCode(2);
        if (!NetworkMonitor.INSTANCE.isNetworkValid$lib_networkmonitor_release()) {
            this.errorCode = 100;
            this.errorMsg = "Fake Network";
        }
        this.mMonitorData.setErrorCode(this.errorCode == -1 ? 104 : this.errorCode);
        this.mMonitorData.setErrorMsg(Intrinsics.areEqual((Object)this.errorMsg, (Object)"Unknown") ? ExtensionKt.shortMsg(ioe) : this.errorMsg);
        if (this.errorCode != -1 && !this.mMonitorData.isTestModel()) {
            ExtensionKt.track(this.mMonitorData);
        }
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callFailed(call, ioe);
        }
    }
}

