/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.core.log.ObjectLogUtils;
import java.lang.reflect.Method;
import java.util.Locale;

public class Utils {
    public static final String GLOBAL_TAG = "NetworkMonitor";
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag("NetworkMonitor").setLogHeadSwitch(true).setBorderSwitch(false).create();

    public static String getCountry() {
        String country = "";
        try {
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            Method get = systemProperties.getMethod("get", String.class, String.class);
            country = (String)get.invoke(systemProperties, "persist.sys.oobe_country", "unknown");
        }
        catch (Exception e) {
            LOG.d((Object)Log.getStackTraceString((Throwable)e));
        }
        if (TextUtils.isEmpty((CharSequence)country) || "unknown".equals(country)) {
            country = Utils.getLocale().getCountry();
        }
        return country;
    }

    private static Locale getLocale() {
        Locale locale;
        try {
            locale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        }
        catch (Exception e) {
            locale = Locale.getDefault();
            LOG.d((Object)Log.getStackTraceString((Throwable)e));
        }
        return locale;
    }
}

