package com.transsin.networkmonitor

import java.util.*

/**
 * @Author:huangxiushuo
 * @Date: 2022-08-22 09:40
 * @Description:
 */
data class MonitorData(

    var shouldUploadData: Boolean = false,

    var usage: Int = 0,

    var callId: String = UUID.randomUUID().toString().replace("-".toRegex(), ""),

    var callResultCode: Int = 0,
    //错误码
    var errorCode: Int = 0,

    var errorMsg: String = "",

    // 1网络已连接
    var codeDetail: Int = 0,
    //serverApi 截掉参数之后的路径
    var serverApi: String = "",
    // 完整的路径
    var completeApi: String? = null,

    var ipAddr: String = "",
    //DNS解析时间
    var dnsTime: Long = 0L,
    //建立连接的耗时
    var tcpTime: Long = 0L,
    //SSL阶段耗时
    var sslTime: Long = 0L,
    //发送请求总耗时
    var sendTime: Long = 0L,
    //发送请求完毕，等待接收response过程耗时
    var waitTime: Long = 0L,
    //接收response耗时
    var recTime: Long = 0L,
    //请求总时间
    var reqTime: Long = 0L,
    //请求数据体大小 byte
    var reqBodySize: Long = 0L,
    //返回数据体大小
    var resBodySize: Long = 0L,
    //CDN请求到响应耗时
    var cdnReqTime: Long = 0L,
    //CDN下载耗时
    var cdnDownTime: Long = 0L,
    //CDN下载网速
    var cdnSpeed: String = "",
    //CDN ip地址
    var cdnIp: String = "",
    //CDN提供商
    var cdnProvider: String = "",
    //国家
    var country: String = Utils.getCountry(),
    //host
    var host: String = "",
    //是否离线广告
    var offlineAd: Int = 0,
    //渠道
    var channel: String? = "All",
    //sdk版本
    var sdkVersion: String = BuildConfig.VERSION

) {

    companion object {
        fun create(usage: Int, shouldUploadData: Boolean, channel: String?): MonitorData {
            return MonitorData().also {
                it.usage = usage
                it.shouldUploadData = shouldUploadData
                it.channel = channel
            }
        }
    }


    override fun toString(): String {
        return """{
                    shouldUploadData : $shouldUploadData
                    usage            : $usage
                    call_id          : $callId
                    call_result_code : $callResultCode
                    server_api       : $serverApi
                    complete_api     : $completeApi
                    ip_address       : $ipAddr
                    error_code       : $errorCode
                    error_msg        : ${errorMsg}
                    codeDetail       : ${codeDetail}
                    req_time         : ${reqTime}ms
                    dns_time         : ${dnsTime}ms
                    tcp_time         : ${tcpTime}ms
                    ssl_time         : ${sslTime}ms
                    send_time        : ${sendTime}ms
                    wait_time        : ${waitTime}ms
                    rec_time         : ${recTime}ms
                    req_body_size    : ${reqBodySize}b
                    res_body_size    : ${resBodySize}b
                    cdn_req_time     : ${cdnReqTime}ms
                    cdn_down_time    : ${cdnDownTime}ms
                    cdn_speed        : ${cdnSpeed}kb/s
                    cdn_provider     : ${cdnProvider}
                    country          : ${country}
                    host             : ${host}
                    channel          : ${channel}
                    sdk_version      : ${sdkVersion}
                  }"""
    }
}
