/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.os.ParcelFileDescriptor;
import android.os.SystemClock;
import android.util.Base64DataException;
import android.util.MalformedJsonException;
import com.transsin.networkmonitor.ExtensionKt;
import com.transsin.networkmonitor.MonitorData;
import com.transsin.networkmonitor.NetworkMonitor;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.SyncFailedException;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileLockInterruptionException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.jar.JarException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileSystemException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.StreamResetException;
import org.apache.http.conn.ConnectTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J*\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J2\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010*\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010+\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0016J&\u0010/\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\u0018\u00104\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\bH\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u00106\u001a\u00020\u0006H\u0002J\u0018\u00107\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\u000eH\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010:\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010?\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\u000eH\u0016J\u0010\u0010@\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010A\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010B\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010E\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010F\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010I\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/transsin/networkmonitor/MonitorEventListener;", "Lokhttp3/EventListener;", "listener", "usage", "", "notReportData", "", "channel", "", "(Lokhttp3/EventListener;IZLjava/lang/String;)V", "errorCode", "errorMsg", "httpCode", "mCallStartTime", "", "mDnsStartTime", "mMonitorData", "Lcom/transsin/networkmonitor/MonitorData;", "mReqBodyEndTime", "mReqHeadersEndTime", "mReqHeadersStartTime", "mRespHeadersEndTime", "mRespHeadersStartTime", "mSecureConnectStartTime", "mTcpStartTime", "randomNumber", "callEnd", "", "call", "Lokhttp3/Call;", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "dnsEnd", "domainName", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "fetchCode", "isNetDone", "requestBodyEnd", "byteCount", "requestBodyStart", "requestFailed", "requestHeadersEnd", "request", "Lokhttp3/Request;", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseHeadersStart", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "lib-networkmonitor_release"})
public final class MonitorEventListener
extends EventListener {
    @Nullable
    private final EventListener listener;
    private final int usage;
    private long mCallStartTime;
    private long mDnsStartTime;
    private long mSecureConnectStartTime;
    private long mTcpStartTime;
    private long mReqHeadersStartTime;
    private long mReqHeadersEndTime;
    private long mReqBodyEndTime;
    private long mRespHeadersStartTime;
    @NotNull
    private final MonitorData mMonitorData;
    private long mRespHeadersEndTime;
    private int httpCode;
    private int errorCode;
    @NotNull
    private String errorMsg;
    private final int randomNumber;

    public MonitorEventListener(@Nullable EventListener listener, int usage, boolean notReportData, @Nullable String channel) {
        this.listener = listener;
        this.usage = usage;
        this.mMonitorData = MonitorData.Companion.create(this.usage, notReportData, channel);
        this.httpCode = 480;
        this.errorCode = 480;
        this.errorMsg = "Unknown";
        this.randomNumber = RangesKt.random((IntRange)new IntRange(1, 10), (Random)((Random)Random.Default));
    }

    public /* synthetic */ MonitorEventListener(EventListener eventListener, int n, boolean bl, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string = "All";
        }
        this(eventListener, n, bl, string);
    }

    public void callStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callStart(call);
        ExtensionKt.printEvent("[callStart]");
        try {
            String string;
            String host;
            String string2;
            String offlineAd;
            String isDownload;
            String string3 = isDownload = call.request().headers().get("isDownload");
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                this.mMonitorData.setUsage(Intrinsics.areEqual((Object)it, (Object)"true") ? 1 : 0);
            }
            String string4 = offlineAd = call.request().headers().get("offlineAd");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                this.mMonitorData.setOfflineAd(Integer.parseInt(it));
            }
            if ((string2 = (host = call.request().url().host())) == null) {
                string2 = "";
            }
            this.mMonitorData.setHost(string2);
            String string5 = call.request().url().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"call.request().url().toString()");
            String url = string5;
            this.mMonitorData.setCompleteApi(this.randomNumber <= 2 ? url : "");
            if (this.usage == 0 && StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
                String string6 = url.substring(0, StringsKt.indexOf$default((CharSequence)url, (String)"?", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string6;
            } else {
                string = url;
            }
            this.mMonitorData.setServerApi(string);
        }
        catch (Exception e) {
            ExtensionKt.printErrEvent("[get header exception] " + e.getClass().getSimpleName() + " : " + e.getMessage());
        }
        this.mCallStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callStart(call);
        }
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        super.dnsStart(call, domainName);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[dnsStart] domainName: ", (Object)domainName));
        this.mDnsStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.dnsStart(call, domainName);
        }
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
        super.dnsEnd(call, domainName, inetAddressList);
        String addresses = CollectionsKt.joinToString$default((Iterable)inetAddressList, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[dnsEnd] inetAddressList ", (Object)addresses));
        this.mMonitorData.setDnsTime(ExtensionKt.realtimeDiff(this.mDnsStartTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.dnsEnd(call, domainName, inetAddressList);
        }
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectStart(call, inetSocketAddress, proxy);
        this.mTcpStartTime = ExtensionKt.realtime();
        String string = inetSocketAddress.getAddress().getHostAddress();
        if (string == null) {
            string = "";
        }
        this.mMonitorData.setIpAddr(string);
        ExtensionKt.printEvent("[connectStart] inetSocketAddress : " + inetSocketAddress + ", proxy : " + proxy);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectStart(call, inetSocketAddress, proxy);
        }
    }

    public void secureConnectStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectStart(call);
        ExtensionKt.printEvent("[secureConnectStart]");
        this.mSecureConnectStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.secureConnectStart(call);
        }
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.secureConnectEnd(call, handshake);
        ExtensionKt.printEvent("[secureConnectEnd]");
        this.mMonitorData.setSslTime(ExtensionKt.realtimeDiff(this.mSecureConnectStartTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.secureConnectEnd(call, handshake);
        }
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[connectEnd] inetSocketAddress ", (Object)inetSocketAddress));
        this.mMonitorData.setTcpTime(ExtensionKt.realtimeDiff(this.mTcpStartTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectEnd(call, inetSocketAddress, proxy, protocol);
        }
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        ExtensionKt.printErrEvent("[connectFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        }
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionReleased(call, connection);
        ExtensionKt.printEvent("[connectionReleased]");
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectionReleased(call, connection);
        }
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.connectionAcquired(call, connection);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[connectionAcquired] connection: ", (Object)connection));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.connectionAcquired(call, connection);
        }
    }

    public void requestHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestHeadersStart(call);
        ExtensionKt.printEvent("[requestHeadersStart]");
        this.mReqHeadersStartTime = ExtensionKt.realtime();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestHeadersStart(call);
        }
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super.requestHeadersEnd(call, request);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[requestHeadersEnd] request :", (Object)request));
        this.mReqHeadersEndTime = ExtensionKt.realtime();
        this.mMonitorData.setSendTime(this.mReqHeadersEndTime - this.mReqHeadersStartTime);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestHeadersEnd(call, request);
        }
    }

    public void requestBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestBodyStart(call);
        ExtensionKt.printEvent("[requestBodyStart]");
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestBodyStart(call);
        }
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.requestBodyEnd(call, byteCount);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[requestBodyEnd] byteCount: ", (Object)byteCount));
        this.mReqBodyEndTime = ExtensionKt.realtime();
        MonitorData $this$requestBodyEnd_u24lambda_u2d2 = this.mMonitorData;
        boolean bl = false;
        $this$requestBodyEnd_u24lambda_u2d2.setReqBodySize(byteCount);
        $this$requestBodyEnd_u24lambda_u2d2.setSendTime(this.mReqBodyEndTime - this.mReqHeadersStartTime);
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestBodyEnd(call, byteCount);
        }
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.requestFailed(call, ioe);
        ExtensionKt.printErrEvent("[requestFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.requestFailed(call, ioe);
        }
    }

    public void responseHeadersStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseHeadersStart(call);
        ExtensionKt.printEvent("[responseHeadersStart]");
        this.mRespHeadersStartTime = ExtensionKt.realtime();
        this.mMonitorData.setWaitTime(this.mRespHeadersStartTime - Long.max(this.mReqBodyEndTime, this.mReqHeadersEndTime));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseHeadersStart(call);
        }
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        String string;
        String provider;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        super.responseHeadersEnd(call, response);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[responseHeadersEnd] code : ", (Object)response.code()));
        String string2 = response.headers().get("x-response-cdn");
        if (string2 == null) {
            string2 = provider = "";
        }
        if ((string = response.headers().get("server-time")) == null) {
            string = "0";
        }
        long serverTime = Long.parseLong(string);
        ExtensionKt.printEvent(provider);
        this.mMonitorData.setCdnProvider(provider);
        this.mRespHeadersEndTime = ExtensionKt.realtime();
        this.mMonitorData.setRecTime(ExtensionKt.realtimeDiff(this.mRespHeadersStartTime));
        this.mMonitorData.setCdnReqTime(ExtensionKt.realtimeDiff(this.mCallStartTime));
        this.mMonitorData.setServerTime(serverTime);
        this.httpCode = response.code();
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseHeadersEnd(call, response);
        }
    }

    public void responseBodyStart(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyStart(call);
        ExtensionKt.printEvent("[responseBodyStart]");
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseBodyStart(call);
        }
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.responseBodyEnd(call, byteCount);
        ExtensionKt.printEvent(Intrinsics.stringPlus((String)"[responseBodyEnd] byteCount: ", (Object)byteCount));
        MonitorData $this$responseBodyEnd_u24lambda_u2d3 = this.mMonitorData;
        boolean bl = false;
        $this$responseBodyEnd_u24lambda_u2d3.setResBodySize(byteCount);
        $this$responseBodyEnd_u24lambda_u2d3.setRecTime(ExtensionKt.realtimeDiff(this.mRespHeadersStartTime));
        $this$responseBodyEnd_u24lambda_u2d3.setCdnDownTime(ExtensionKt.realtimeDiff(this.mRespHeadersEndTime));
        $this$responseBodyEnd_u24lambda_u2d3.setCdnSpeed(String.valueOf((float)byteCount / 1024.0f / ((float)$this$responseBodyEnd_u24lambda_u2d3.getCdnDownTime() / 1000.0f)));
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseBodyEnd(call, byteCount);
        }
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.responseFailed(call, ioe);
        ExtensionKt.printErrEvent("[responseFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.responseFailed(call, ioe);
        }
    }

    public void callEnd(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        super.callEnd(call);
        ExtensionKt.printEvent("[callEnd]");
        MonitorData $this$callEnd_u24lambda_u2d4 = this.mMonitorData;
        boolean bl = false;
        $this$callEnd_u24lambda_u2d4.setCallResultCode(1);
        $this$callEnd_u24lambda_u2d4.setReqTime(ExtensionKt.realtimeDiff(this.mCallStartTime));
        $this$callEnd_u24lambda_u2d4.setErrorCode(this.httpCode);
        if ($this$callEnd_u24lambda_u2d4.getErrorCode() != 480 && $this$callEnd_u24lambda_u2d4.getErrorCode() != 304 && !this.mMonitorData.getNotReportData()) {
            ExtensionKt.track($this$callEnd_u24lambda_u2d4);
        }
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callEnd(call);
        }
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
        super.callFailed(call, ioe);
        ExtensionKt.printErrEvent("[callFailed]  " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
        this.mMonitorData.setCallResultCode(2);
        if (this.isNetDone()) {
            if (!NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release()) {
                this.errorCode = 1020;
                this.errorMsg = "Network disconnect";
            } else if (NetworkMonitor.INSTANCE.isFakeNetwork$lib_networkmonitor_release()) {
                this.errorCode = 1021;
                this.errorMsg = "Fake Network";
            } else {
                this.errorCode = this.fetchCode(ioe);
            }
        } else {
            this.errorCode = this.fetchCode(ioe);
        }
        this.mMonitorData.setErrorCode(this.errorCode);
        this.mMonitorData.setErrorMsg(Intrinsics.areEqual((Object)this.errorMsg, (Object)"Unknown") ? ExtensionKt.shortMsg(ioe) : this.errorMsg);
        if (!this.mMonitorData.getNotReportData()) {
            ExtensionKt.track(this.mMonitorData);
        }
        EventListener eventListener = this.listener;
        if (eventListener != null) {
            eventListener.callFailed(call, ioe);
        }
    }

    private final boolean isNetDone() {
        return NetworkMonitor.INSTANCE.isNetInitDone$lib_networkmonitor_release() || SystemClock.uptimeMillis() - NetworkMonitor.INSTANCE.getInitStartTime$lib_networkmonitor_release() > 3000L;
    }

    private final int fetchCode(IOException ioe) {
        int code = this.httpCode;
        if (this.httpCode == 480) {
            IOException iOException = ioe;
            code = iOException instanceof SocketTimeoutException ? 1008 : (iOException instanceof UnknownHostException ? 1005 : (iOException instanceof NoRouteToHostException ? 1006 : (iOException instanceof ProtocolException ? 1007 : (iOException instanceof SSLHandshakeException ? 1009 : (iOException instanceof ConnectException ? 1011 : (iOException instanceof BindException ? 1045 : (iOException instanceof PortUnreachableException ? 1012 : (iOException instanceof ConnectTimeoutException ? 1013 : (iOException instanceof SSLKeyException ? 1014 : (iOException instanceof SSLPeerUnverifiedException ? 1015 : (iOException instanceof SSLProtocolException ? 1016 : (iOException instanceof FileSystemException ? 1017 : (iOException instanceof ObjectStreamException ? 1018 : (iOException instanceof AsynchronousCloseException ? 1019 : (iOException instanceof MalformedInputException ? 1043 : (iOException instanceof UnmappableCharacterException ? 1044 : (iOException instanceof JarException ? 1022 : (iOException instanceof CharConversionException ? 1023 : (iOException instanceof Base64DataException ? 1024 : (iOException instanceof ConnectionShutdownException ? 1025 : (iOException instanceof EOFException ? 1027 : (iOException instanceof ParcelFileDescriptor.FileDescriptorDetachedException ? 1028 : (iOException instanceof FileLockInterruptionException ? 1029 : (iOException instanceof FileNotFoundException ? 1030 : (iOException instanceof HttpRetryException ? 1031 : (iOException instanceof InvalidPropertiesFormatException ? 1033 : (iOException instanceof MalformedJsonException ? 1034 : (iOException instanceof MalformedURLException ? 1035 : (iOException instanceof StreamResetException ? 1037 : (iOException instanceof SyncFailedException ? 1038 : (iOException instanceof UTFDataFormatException ? 1039 : (iOException instanceof UnknownServiceException ? 1040 : (iOException instanceof UnsupportedEncodingException ? 1042 : 480)))))))))))))))))))))))))))))))));
        }
        return code;
    }
}

