/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.SystemClock;
import com.transsin.networkmonitor.HostMatcher;
import com.transsin.networkmonitor.Utils;
import com.transsion.ga.AthenaAnalytics;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\b\u0002\u0010\u0015\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0015\u001a\u00020\nH\u0007J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/transsin/networkmonitor/NetworkMonitor;", "", "()V", "initStartTime", "", "getInitStartTime$lib_networkmonitor_release", "()J", "setInitStartTime$lib_networkmonitor_release", "(J)V", "isFakeNetwork", "", "isFakeNetwork$lib_networkmonitor_release", "()Z", "setFakeNetwork$lib_networkmonitor_release", "(Z)V", "isNetInitDone", "isNetInitDone$lib_networkmonitor_release", "setNetInitDone$lib_networkmonitor_release", "isNetworkConnected", "isNetworkConnected$lib_networkmonitor_release", "setNetworkConnected$lib_networkmonitor_release", "isTest", "isTest$lib_networkmonitor_release", "setTest$lib_networkmonitor_release", "init", "", "application", "Landroid/app/Application;", "hosts", "", "", "(Landroid/app/Application;[Ljava/lang/String;Z)V", "registerNetworkCallback", "context", "Landroid/content/Context;", "lib-networkmonitor_release"})
public final class NetworkMonitor {
    @NotNull
    public static final NetworkMonitor INSTANCE = new NetworkMonitor();
    private static boolean isTest;
    private static boolean isNetworkConnected;
    private static boolean isFakeNetwork;
    private static boolean isNetInitDone;
    private static long initStartTime;

    private NetworkMonitor() {
    }

    public final boolean isTest$lib_networkmonitor_release() {
        return isTest;
    }

    public final void setTest$lib_networkmonitor_release(boolean bl) {
        isTest = bl;
    }

    public final boolean isNetworkConnected$lib_networkmonitor_release() {
        return isNetworkConnected;
    }

    public final void setNetworkConnected$lib_networkmonitor_release(boolean bl) {
        isNetworkConnected = bl;
    }

    public final boolean isFakeNetwork$lib_networkmonitor_release() {
        return isFakeNetwork;
    }

    public final void setFakeNetwork$lib_networkmonitor_release(boolean bl) {
        isFakeNetwork = bl;
    }

    public final boolean isNetInitDone$lib_networkmonitor_release() {
        return isNetInitDone;
    }

    public final void setNetInitDone$lib_networkmonitor_release(boolean bl) {
        isNetInitDone = bl;
    }

    public final long getInitStartTime$lib_networkmonitor_release() {
        return initStartTime;
    }

    public final void setInitStartTime$lib_networkmonitor_release(long l) {
        initStartTime = l;
    }

    @JvmStatic
    public static final void init(@NotNull Application application, @NotNull String[] hosts, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)hosts, (String)"hosts");
        NetworkMonitor.isTest = isTest;
        AthenaAnalytics.init((Context)((Context)application), (String)"NetworkMonitor", (int)1814, (boolean)isTest, (boolean)false);
        HostMatcher.INSTANCE.setHosts(hosts);
        INSTANCE.registerNetworkCallback((Context)application);
        initStartTime = SystemClock.uptimeMillis();
    }

    public static /* synthetic */ void init$default(Application application, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            stringArray = new String[]{};
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        NetworkMonitor.init(application, stringArray, bl);
    }

    @JvmStatic
    public static final void init(@NotNull Application application, boolean isTest) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        NetworkMonitor.init(application, new String[0], isTest);
    }

    public static /* synthetic */ void init$default(Application application, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        NetworkMonitor.init(application, bl);
    }

    private final void registerNetworkCallback(Context context) {
        Object object = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = object instanceof ConnectivityManager ? (ConnectivityManager)object : null;
        if (connectivityManager == null) {
            return;
        }
        ConnectivityManager connectivityManager2 = connectivityManager;
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkRequest request = new NetworkRequest.Builder().build();
            connectivityManager2.registerNetworkCallback(request, new ConnectivityManager.NetworkCallback(){

                public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                    super.onCapabilitiesChanged(network, networkCapabilities);
                    boolean isNetworkValid = networkCapabilities.hasCapability(16);
                    NetworkMonitor.INSTANCE.setNetworkConnected$lib_networkmonitor_release(networkCapabilities.hasCapability(12));
                    NetworkMonitor.INSTANCE.setFakeNetwork$lib_networkmonitor_release(NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release() && !isNetworkValid);
                    NetworkMonitor.INSTANCE.setNetInitDone$lib_networkmonitor_release(true);
                    Object[] objectArray = new Object[]{"isNetworkConnected : " + NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release() + ",  isFakeNetwork : " + NetworkMonitor.INSTANCE.isFakeNetwork$lib_networkmonitor_release()};
                    Utils.LOG.d("NetworkMonitor", objectArray);
                }

                public void onAvailable(@NotNull Network network) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    super.onAvailable(network);
                    Object[] objectArray = new Object[]{Intrinsics.stringPlus((String)"onAvailable : ", (Object)network)};
                    Utils.LOG.d("NetworkMonitor", objectArray);
                }

                public void onUnavailable() {
                    super.onUnavailable();
                    Object[] objectArray = new Object[]{"onUnavailable"};
                    Utils.LOG.d("NetworkMonitor", objectArray);
                }

                public void onBlockedStatusChanged(@NotNull Network network, boolean blocked) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    super.onBlockedStatusChanged(network, blocked);
                    Object[] objectArray = new Object[]{"onBlockedStatusChanged"};
                    Utils.LOG.d("NetworkMonitor", objectArray);
                }

                public void onLost(@NotNull Network network) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    super.onLost(network);
                    Object[] objectArray = new Object[]{"onLost"};
                    Utils.LOG.d("NetworkMonitor", objectArray);
                    NetworkMonitor.INSTANCE.setNetworkConnected$lib_networkmonitor_release(false);
                }

                public void onLosing(@NotNull Network network, int maxMsToLive) {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    super.onLosing(network, maxMsToLive);
                    Object[] objectArray = new Object[]{"onLosing"};
                    Utils.LOG.d("NetworkMonitor", objectArray);
                    NetworkMonitor.INSTANCE.setNetworkConnected$lib_networkmonitor_release(false);
                }
            });
        }
    }
}

