/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.os.SystemClock;
import com.transsin.networkmonitor.CodeUtil;
import com.transsin.networkmonitor.ExtensionKt;
import com.transsin.networkmonitor.MonitorData;
import com.transsin.networkmonitor.NetworkMonitor;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.chromium.net.NetworkException;
import org.chromium.net.RequestFinishedInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002JB\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lcom/transsin/networkmonitor/CronetMonitorHelper;", "", "()V", "isNetDone", "", "logMatrix", "", "requestInfo", "Lorg/chromium/net/RequestFinishedInfo;", "usage", "", "channel", "", "tag", "isTest", "notReportCancel", "notReportNoNetwork", "lib-networkmonitor_release"})
@SourceDebugExtension(value={"SMAP\nCronetMonitorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CronetMonitorHelper.kt\ncom/transsin/networkmonitor/CronetMonitorHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class CronetMonitorHelper {
    @NotNull
    public static final CronetMonitorHelper INSTANCE = new CronetMonitorHelper();

    private CronetMonitorHelper() {
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void logMatrix(@NotNull RequestFinishedInfo requestInfo, int usage, @NotNull String channel, @NotNull String tag, boolean isTest, boolean notReportCancel, boolean notReportNoNetwork) {
        block34: {
            Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (notReportCancel && requestInfo.getFinishedReason() == 2) {
                return;
            }
            v0 = requestInfo.getResponseInfo();
            v1 = v0 != null ? v0.getNegotiatedProtocol() : null;
            if (v1 == null) {
                v1 = "";
            }
            protocol = v1;
            monitorData = MonitorData.Companion.create(usage, channel);
            monitorData.setHttpType(2);
            monitorData.setProtocol(protocol);
            errorCode = 480;
            v2 = requestInfo.getResponseInfo();
            httpCode = v2 != null ? v2.getHttpStatusCode() : 480;
            matrix = requestInfo.getMetrics();
            randomNumber = RangesKt.random((IntRange)new IntRange(1, 10), (Random)((Random)Random.Default));
            url = requestInfo.getUrl().toString();
            monitorData.setCompleteApi(randomNumber <= 2 ? url : "");
            try {
                block35: {
                    block36: {
                        block37: {
                            block33: {
                                v3 = requestInfo.getAnnotations();
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"requestInfo.annotations");
                                var18_15 = v3;
                                var19_19 = var18_15.iterator();
                                while (var19_19.hasNext()) {
                                    it = var20_20 = var19_19.next();
                                    $i$a$-find-CronetMonitorHelper$logMatrix$1 = false;
                                    if (!(it instanceof Headers)) continue;
                                    v4 /* !! */  = var20_20;
                                    break block33;
                                }
                                v4 /* !! */  = null;
                            }
                            var16_27 = v4 /* !! */ ;
                            v5 = var16_27 instanceof Headers != false ? (Headers)var16_27 : null;
                            if (v5 == null) break block35;
                            $this$logMatrix_u24lambda_u243 = var16_27 = v5;
                            $i$a$-apply-CronetMonitorHelper$logMatrix$2 = false;
                            v6 = $this$logMatrix_u24lambda_u243.get("isDownload");
                            if (v6 == null) break block36;
                            it = v6;
                            $i$a$-let-CronetMonitorHelper$logMatrix$2$1 = false;
                            switch (it.hashCode()) {
                                case 84: {
                                    if (!it.equals("T")) {
                                        break;
                                    }
                                    ** GOTO lbl51
                                }
                                case 3569038: {
                                    if (!it.equals("true")) break;
lbl51:
                                    // 2 sources

                                    v7 = 1;
                                    break block37;
                                }
                            }
                            v7 = 0;
                        }
                        monitorData.setUsage(v7);
                    }
                    monitorData.setOfflineAd(Intrinsics.areEqual((Object)$this$logMatrix_u24lambda_u243.get("offlineAd"), (Object)"1") != false ? 1 : 0);
                    v8 = monitorData;
                    var21_23 = tag;
                    if (var21_23.length() == 0) {
                        $i$a$-find-CronetMonitorHelper$logMatrix$1 = v8;
                        $i$a$-ifEmpty-CronetMonitorHelper$logMatrix$2$2 = false;
                        v9 = $this$logMatrix_u24lambda_u243.get("infoeyes-tag");
                        if (v9 == null) {
                            v9 = "";
                        }
                        v10 = v9;
                        v8 = $i$a$-find-CronetMonitorHelper$logMatrix$1;
                    } else {
                        v10 = var21_23;
                    }
                    v8.setCompareTag((String)v10);
                }
                if (monitorData.getUsage() == 0 && StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
                    v11 = url.substring(0, StringsKt.indexOf$default((CharSequence)url, (String)"?", (int)0, (boolean)false, (int)6, null));
                    v12 = v11;
                    Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    v12 = url;
                }
                monitorData.setServerApi(v12);
                host = new URL(url).getHost();
                path = new URL(url).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
                monitorData.setHost(host);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                monitorData.setPath(path);
            }
            catch (Exception e) {
                v13 = e.getMessage();
                if (v13 == null) break block34;
                ExtensionKt.printEvent(v13);
            }
        }
        v14 = success = requestInfo.getFinishedReason() == 0;
        if (success) {
            monitorData.setCallResultCode(1);
            v15 = matrix.getDnsStart();
            dnsStart = v15 != null ? v15.getTime() : 0L;
            v16 = matrix.getDnsEnd();
            dnsEnd = v16 != null ? v16.getTime() : 0L;
            monitorData.setDnsTime(dnsEnd - dnsStart);
            v17 = matrix.getSslStart();
            sslStart = v17 != null ? v17.getTime() : 0L;
            v18 = matrix.getSslEnd();
            sslEnd = v18 != null ? v18.getTime() : 0L;
            monitorData.setSslTime(sslEnd - sslStart);
            v19 = matrix.getConnectStart();
            connectStart = v19 != null ? v19.getTime() : 0L;
            v20 = matrix.getConnectEnd();
            connectEnd = v20 != null ? v20.getTime() : 0L;
            monitorData.setTcpTime(connectEnd - connectStart);
            v21 = matrix.getSendingStart();
            sendStart = v21 != null ? v21.getTime() : 0L;
            v22 = matrix.getSendingEnd();
            sendEnd = v22 != null ? v22.getTime() : 0L;
            monitorData.setSendTime(sendEnd - sendStart);
            v23 = matrix.getResponseStart();
            responseStart = v23 != null ? v23.getTime() : 0L;
            v24 = matrix.getRequestEnd();
            responseEnd = v24 != null ? v24.getTime() : 0L;
            monitorData.setRecTime(responseEnd - responseStart);
            monitorData.setWaitTime(responseStart - sendEnd);
            v25 = matrix.getReceivedByteCount();
            monitorData.setResBodySize(v25 == null ? 0L : v25);
            v26 = matrix.getSentByteCount();
            monitorData.setReqBodySize(v26 == null ? 0L : v26);
            v27 = requestInfo.getResponseInfo();
            v28 = allHeaders = v27 != null ? v27.getAllHeaders() : null;
            v29 = contentEncodings = v28 != null ? (List)v28.get("Content-Encoding") : null;
            if (contentEncodings != null && (var38_43 = contentEncodings.iterator()).hasNext()) {
                contentEncoding = (String)var38_43.next();
                Intrinsics.checkNotNullExpressionValue((Object)contentEncoding, (String)"contentEncoding");
                monitorData.setContentEncoding(contentEncoding);
            }
            if (((v30 = allHeaders) != null && (v30 = (List)v30.get("server-time")) != null ? (String)v30.get(0) : (v31 = null)) == null) {
                v31 = "0";
            }
            monitorData.setServerTime(Long.parseLong(v31));
            v32 = matrix;
            v33 = v32 != null ? v32.getTotalTimeMs() : null;
            monitorData.setReqTime(v33 == null ? 0L : v33);
            if (monitorData.getUsage() == 1) {
                v34 = allHeaders;
                if ((v34 != null && (v34 = (List)v34.get("x-response-cdn")) != null ? (String)v34.get(0) : (v35 = null)) == null) {
                    v35 = "";
                }
                provider = v35;
                monitorData.setCdnProvider(provider);
                v36 = matrix;
                monitorData.setCdnReqTime(responseStart - (v36 != null && (v36 = v36.getRequestStart()) != null ? v36.getTime() : 0L));
                monitorData.setCdnDownTime(monitorData.getRecTime());
                monitorData.setCdnSpeed(String.valueOf((float)monitorData.getResBodySize() / 1024.0f / ((float)monitorData.getRecTime() / 1000.0f)));
            }
            errorCode = httpCode;
        } else {
            monitorData.setCallResultCode(2);
            isCancel = requestInfo.getFinishedReason() == 2;
            v37 = requestInfo.getException();
            v38 = v37 != null ? v37.getMessage() : null;
            if (v38 == null) {
                v38 = errorMsg = "";
            }
            if (requestInfo.getException() instanceof NetworkException) {
                v39 = requestInfo.getException();
                Intrinsics.checkNotNull((Object)v39, (String)"null cannot be cast to non-null type org.chromium.net.NetworkException");
                ioe = (NetworkException)v39;
                if (this.isNetDone()) {
                    if (!NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release()) {
                        errorCode = 1020;
                        errorMsg = "Network disconnect";
                    } else if (NetworkMonitor.INSTANCE.isFakeNetwork$lib_networkmonitor_release()) {
                        errorCode = 1021;
                        errorMsg = "Fake Network";
                    } else {
                        errorCode = CodeUtil.INSTANCE.fetchCronetException(httpCode, ioe, isCancel);
                    }
                } else {
                    errorCode = CodeUtil.INSTANCE.fetchCronetException(httpCode, ioe, isCancel);
                }
            } else {
                errorCode = isCancel != false ? 1050 : 480;
            }
            monitorData.setErrorMsg(errorMsg);
        }
        monitorData.setErrorCode(errorCode);
        if (!isTest) {
            if (errorCode == 304) {
                return;
            }
            if (notReportNoNetwork && errorCode == 1020) {
                return;
            }
            ExtensionKt.track(monitorData);
        }
    }

    public static /* synthetic */ void logMatrix$default(CronetMonitorHelper cronetMonitorHelper, RequestFinishedInfo requestFinishedInfo, int n, String string, String string2, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = false;
        }
        cronetMonitorHelper.logMatrix(requestFinishedInfo, n, string, string2, bl, bl2, bl3);
    }

    private final boolean isNetDone() {
        return NetworkMonitor.INSTANCE.isNetInitDone$lib_networkmonitor_release() || SystemClock.uptimeMillis() - NetworkMonitor.INSTANCE.getInitStartTime$lib_networkmonitor_release() > 3000L;
    }
}

