/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.os.Bundle;
import android.os.SystemClock;
import androidx.core.os.BundleKt;
import com.transsin.networkmonitor.HostMatcher;
import com.transsin.networkmonitor.MonitorData;
import com.transsin.networkmonitor.PathMatcher;
import com.transsin.networkmonitor.Utils;
import com.transsion.athenacust.AthenaCust;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\t\u001a\u000e\u0010\u000b\u001a\u00020\t*\u00060\fj\u0002`\r\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u0006\u00a8\u0006\u000f"}, d2={"realtime", "", "realtimeDiff", "time", "asBundle", "Landroid/os/Bundle;", "Lcom/transsin/networkmonitor/MonitorData;", "printErrEvent", "", "", "printEvent", "shortMsg", "Ljava/lang/Exception;", "Lkotlin/Exception;", "track", "lib-networkmonitor_release"})
public final class ExtensionKt {
    public static final void printEvent(@NotNull String $this$printEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$printEvent, (String)"<this>");
        Object[] objectArray = new Object[]{"=======/ " + $this$printEvent + " /======="};
        Utils.LOG.d("NetworkMonitor", objectArray);
    }

    public static final void printErrEvent(@NotNull String $this$printErrEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$printErrEvent, (String)"<this>");
        Object[] objectArray = new Object[]{"=======/ " + $this$printErrEvent + " /======="};
        Utils.LOG.e("NetworkMonitor", objectArray);
    }

    @NotNull
    public static final Bundle asBundle(@NotNull MonitorData $this$asBundle) {
        Intrinsics.checkNotNullParameter((Object)$this$asBundle, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"usage", (Object)$this$asBundle.getUsage()), TuplesKt.to((Object)"call_id", (Object)$this$asBundle.getCallId()), TuplesKt.to((Object)"call_result_code", (Object)$this$asBundle.getCallResultCode()), TuplesKt.to((Object)"error_code", (Object)$this$asBundle.getErrorCode()), TuplesKt.to((Object)"error_msg", (Object)$this$asBundle.getErrorMsg()), TuplesKt.to((Object)"server_api", (Object)$this$asBundle.getServerApi()), TuplesKt.to((Object)"complete_api", (Object)$this$asBundle.getCompleteApi()), TuplesKt.to((Object)"ip_address", (Object)$this$asBundle.getIpAddr()), TuplesKt.to((Object)"req_time", (Object)$this$asBundle.getReqTime()), TuplesKt.to((Object)"dns_time", (Object)$this$asBundle.getDnsTime()), TuplesKt.to((Object)"tcp_time", (Object)$this$asBundle.getTcpTime()), TuplesKt.to((Object)"ssl_time", (Object)$this$asBundle.getSslTime()), TuplesKt.to((Object)"send_time", (Object)$this$asBundle.getSendTime()), TuplesKt.to((Object)"wait_time", (Object)$this$asBundle.getWaitTime()), TuplesKt.to((Object)"rec_time", (Object)$this$asBundle.getRecTime()), TuplesKt.to((Object)"req_body_size", (Object)$this$asBundle.getReqBodySize()), TuplesKt.to((Object)"res_body_size", (Object)$this$asBundle.getResBodySize()), TuplesKt.to((Object)"cdn_req_time", (Object)$this$asBundle.getCdnReqTime()), TuplesKt.to((Object)"cdn_down_time", (Object)$this$asBundle.getCdnDownTime()), TuplesKt.to((Object)"cdn_speed", (Object)$this$asBundle.getCdnSpeed()), TuplesKt.to((Object)"cdn_provider", (Object)$this$asBundle.getCdnProvider()), TuplesKt.to((Object)"country", (Object)$this$asBundle.getCountry()), TuplesKt.to((Object)"host", (Object)$this$asBundle.getHost()), TuplesKt.to((Object)"is_offline", (Object)$this$asBundle.getOfflineAd()), TuplesKt.to((Object)"channel", (Object)$this$asBundle.getChannel()), TuplesKt.to((Object)"sdk_version", (Object)$this$asBundle.getSdkVersion()), TuplesKt.to((Object)"server_time", (Object)$this$asBundle.getServerTime()), TuplesKt.to((Object)"protocol", (Object)$this$asBundle.getProtocol()), TuplesKt.to((Object)"compare_tag", (Object)$this$asBundle.getCompareTag()), TuplesKt.to((Object)"http_type", (Object)$this$asBundle.getHttpType()), TuplesKt.to((Object)"content_encoding", (Object)$this$asBundle.getContentEncoding()), TuplesKt.to((Object)"tls_version", (Object)$this$asBundle.getTlsVersion()), TuplesKt.to((Object)"request_downgrade", (Object)$this$asBundle.getRequestDowngrade())};
        return BundleKt.bundleOf((Pair[])pairArray);
    }

    public static final void track(@NotNull MonitorData $this$track) {
        Intrinsics.checkNotNullParameter((Object)$this$track, (String)"<this>");
        Object[] objectArray = new Object[]{$this$track.toString()};
        Utils.LOG.d("NetworkMonitor", objectArray);
        String event = "process";
        float simpleRate = 0.01f;
        if (HostMatcher.matchBlackHost($this$track.getHost()) || PathMatcher.matchBlackPath($this$track.getPath())) {
            event = "process_black";
            simpleRate = 0.001f;
        } else if (HostMatcher.matchWhiteHost($this$track.getHost()) || PathMatcher.matchWhitePath($this$track.getPath())) {
            event = "process_white";
            simpleRate = 1.0f;
        }
        new AthenaCust(event, 1814).setSamplingRate(simpleRate).trackCommon(ExtensionKt.asBundle($this$track), null).submit();
    }

    @NotNull
    public static final String shortMsg(@NotNull Exception $this$shortMsg) {
        Intrinsics.checkNotNullParameter((Object)$this$shortMsg, (String)"<this>");
        if ($this$shortMsg.getMessage() == null) {
            return "";
        }
        String string = $this$shortMsg.getMessage();
        Intrinsics.checkNotNull((Object)string);
        int endIndex = Integer.min(string.length(), 200);
        String string2 = $this$shortMsg.getMessage();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2.substring(0, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    public static final long realtime() {
        return SystemClock.elapsedRealtime();
    }

    public static final long realtimeDiff(long time) {
        return ExtensionKt.realtime() - time;
    }
}

