/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import android.os.SystemClock;
import com.transsin.networkmonitor.CodeUtil;
import com.transsin.networkmonitor.ExtensionKt;
import com.transsin.networkmonitor.MonitorData;
import com.transsin.networkmonitor.NetWorkListener;
import com.transsin.networkmonitor.NetworkMonitor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J*\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J2\u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010/\u001a\u000200H\u0016J&\u00102\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00103\u001a\u00020\t2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0016J\u0018\u00107\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u00103\u001a\u00020\tH\u0016J\b\u00108\u001a\u00020\u0007H\u0002J\u0010\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010=\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010>\u001a\u00020\u0011H\u0016J\u0010\u0010?\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010@\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010A\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010B\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010C\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010>\u001a\u00020\u0011H\u0016J\u0010\u0010D\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010E\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010F\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010G\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010J\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010M\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/transsin/networkmonitor/MonitorEventListener;", "Lokhttp3/EventListener;", "Lcom/transsin/networkmonitor/NetWorkListener;", "listener", "usage", "", "notReportData", "", "channel", "", "notReportCancel", "notReportNoNetwork", "(Lokhttp3/EventListener;IZLjava/lang/String;ZZ)V", "errorCode", "errorMsg", "httpCode", "mCallStartTime", "", "mDnsStartTime", "mMonitorData", "Lcom/transsin/networkmonitor/MonitorData;", "mReqBodyEndTime", "mReqHeadersEndTime", "mReqHeadersStartTime", "mRespHeadersEndTime", "mRespHeadersStartTime", "mSecureConnectStartTime", "mTcpStartTime", "randomNumber", "callEnd", "", "call", "Lokhttp3/Call;", "callFailed", "ioe", "Ljava/io/IOException;", "callStart", "connectEnd", "inetSocketAddress", "Ljava/net/InetSocketAddress;", "proxy", "Ljava/net/Proxy;", "protocol", "Lokhttp3/Protocol;", "connectFailed", "connectStart", "connectionAcquired", "connection", "Lokhttp3/Connection;", "connectionReleased", "dnsEnd", "domainName", "inetAddressList", "", "Ljava/net/InetAddress;", "dnsStart", "isNetDone", "onDowngrade", "request", "Lokhttp3/Request;", "onRequestUpdate", "requestBodyEnd", "byteCount", "requestBodyStart", "requestFailed", "requestHeadersEnd", "requestHeadersStart", "responseBodyEnd", "responseBodyStart", "responseFailed", "responseHeadersEnd", "response", "Lokhttp3/Response;", "responseHeadersStart", "secureConnectEnd", "handshake", "Lokhttp3/Handshake;", "secureConnectStart", "lib-networkmonitor_release"})
@SourceDebugExtension(value={"SMAP\nMonitorEventListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitorEventListener.kt\ncom/transsin/networkmonitor/MonitorEventListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,349:1\n1#2:350\n*E\n"})
public final class MonitorEventListener
extends EventListener
implements NetWorkListener {
    @Nullable
    private final EventListener listener;
    private final int usage;
    private final boolean notReportData;
    private final boolean notReportCancel;
    private final boolean notReportNoNetwork;
    private long mCallStartTime;
    private long mDnsStartTime;
    private long mSecureConnectStartTime;
    private long mTcpStartTime;
    private long mReqHeadersStartTime;
    private long mReqHeadersEndTime;
    private long mReqBodyEndTime;
    private long mRespHeadersStartTime;
    @NotNull
    private final MonitorData mMonitorData;
    private long mRespHeadersEndTime;
    private int httpCode;
    private int errorCode;
    @NotNull
    private String errorMsg;
    private final int randomNumber;

    public MonitorEventListener(@Nullable EventListener listener, int usage, boolean notReportData, @Nullable String channel, boolean notReportCancel, boolean notReportNoNetwork) {
        this.listener = listener;
        this.usage = usage;
        this.notReportData = notReportData;
        this.notReportCancel = notReportCancel;
        this.notReportNoNetwork = notReportNoNetwork;
        this.mMonitorData = MonitorData.Companion.create(this.usage, channel);
        this.httpCode = 480;
        this.errorCode = 480;
        this.errorMsg = "Unknown";
        this.randomNumber = RangesKt.random((IntRange)new IntRange(1, 10), (Random)((Random)Random.Default));
    }

    public /* synthetic */ MonitorEventListener(EventListener eventListener, int n, boolean bl, String string, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string = "All";
        }
        this(eventListener, n, bl, string, bl2, bl3);
    }

    public void callStart(@NotNull Call call) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.callStart(call);
            ExtensionKt.printEvent("[callStart]");
            try {
                String string;
                String offlineAd;
                String isDownload;
                String string2 = isDownload = call.request().headers().get("isDownload");
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    this.mMonitorData.setUsage(Intrinsics.areEqual((Object)it, (Object)"true") || Intrinsics.areEqual((Object)it, (Object)"T") ? 1 : 0);
                }
                String string3 = offlineAd = call.request().headers().get("offlineAd");
                if (string3 != null) {
                    String it = string3;
                    boolean bl = false;
                    this.mMonitorData.setOfflineAd(Integer.parseInt(it));
                }
                String host = call.request().url().host();
                String path = call.request().url().encodedPath();
                String string4 = path;
                if (string4 == null) {
                    string4 = "";
                }
                this.mMonitorData.setPath(string4);
                String string5 = host;
                if (string5 == null) {
                    string5 = "";
                }
                this.mMonitorData.setHost(string5);
                String string6 = call.request().url().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"call.request().url().toString()");
                String url = string6;
                this.mMonitorData.setCompleteApi(this.randomNumber <= 2 ? url : "");
                if (this.usage == 0 && StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
                    String string7 = url.substring(0, StringsKt.indexOf$default((CharSequence)url, (String)"?", (int)0, (boolean)false, (int)6, null));
                    string = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string = url;
                }
                this.mMonitorData.setServerApi(string);
                String tag = call.request().headers().get("infoeyes-tag");
                String string8 = tag;
                if (string8 == null) {
                    string8 = "";
                }
                this.mMonitorData.setCompareTag(string8);
            }
            catch (Exception e) {
                ExtensionKt.printErrEvent("[get header exception] " + e.getClass().getSimpleName() + " : " + e.getMessage());
            }
            this.mCallStartTime = ExtensionKt.realtime();
            EventListener eventListener = this.listener;
            if (eventListener == null) break block9;
            eventListener.callStart(call);
        }
    }

    public void dnsStart(@NotNull Call call, @NotNull String domainName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
            super.dnsStart(call, domainName);
            ExtensionKt.printEvent("[dnsStart] domainName: " + domainName);
            this.mDnsStartTime = ExtensionKt.realtime();
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.dnsStart(call, domainName);
        }
    }

    public void dnsEnd(@NotNull Call call, @NotNull String domainName, @NotNull List<? extends InetAddress> inetAddressList) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
            Intrinsics.checkNotNullParameter(inetAddressList, (String)"inetAddressList");
            super.dnsEnd(call, domainName, inetAddressList);
            String addresses = CollectionsKt.joinToString$default((Iterable)inetAddressList, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
            ExtensionKt.printEvent("[dnsEnd] inetAddressList " + addresses);
            this.mMonitorData.setDnsTime(ExtensionKt.realtimeDiff(this.mDnsStartTime));
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.dnsEnd(call, domainName, inetAddressList);
        }
    }

    public void connectStart(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            super.connectStart(call, inetSocketAddress, proxy);
            this.mTcpStartTime = ExtensionKt.realtime();
            String string = inetSocketAddress.getAddress().getHostAddress();
            if (string == null) {
                string = "";
            }
            this.mMonitorData.setIpAddr(string);
            ExtensionKt.printEvent("[connectStart] inetSocketAddress : " + inetSocketAddress + ", proxy : " + proxy);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.connectStart(call, inetSocketAddress, proxy);
        }
    }

    public void secureConnectStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.secureConnectStart(call);
            ExtensionKt.printEvent("[secureConnectStart]");
            this.mSecureConnectStartTime = ExtensionKt.realtime();
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.secureConnectStart(call);
        }
    }

    public void secureConnectEnd(@NotNull Call call, @Nullable Handshake handshake) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.secureConnectEnd(call, handshake);
            ExtensionKt.printEvent("[secureConnectEnd]");
            Object object = handshake;
            if (object == null || (object = object.tlsVersion()) == null || (object = object.name()) == null) {
                object = "";
            }
            this.mMonitorData.setTlsVersion((String)object);
            this.mMonitorData.setSslTime(ExtensionKt.realtimeDiff(this.mSecureConnectStartTime));
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.secureConnectEnd(call, handshake);
        }
    }

    public void connectEnd(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            super.connectEnd(call, inetSocketAddress, proxy, protocol);
            ExtensionKt.printEvent("[connectEnd] inetSocketAddress " + inetSocketAddress);
            this.mMonitorData.setTcpTime(ExtensionKt.realtimeDiff(this.mTcpStartTime));
            Object object = protocol;
            if (object == null || (object = object.name()) == null) {
                object = "";
            }
            this.mMonitorData.setProtocol((String)object);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.connectEnd(call, inetSocketAddress, proxy, protocol);
        }
    }

    public void connectFailed(@NotNull Call call, @NotNull InetSocketAddress inetSocketAddress, @NotNull Proxy proxy, @Nullable Protocol protocol, @NotNull IOException ioe) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)inetSocketAddress, (String)"inetSocketAddress");
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
            super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
            ExtensionKt.printErrEvent("[connectFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
            Object object = protocol;
            if (object == null || (object = object.name()) == null) {
                object = "";
            }
            this.mMonitorData.setProtocol((String)object);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        }
    }

    public void connectionReleased(@NotNull Call call, @NotNull Connection connection) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            super.connectionReleased(call, connection);
            ExtensionKt.printEvent("[connectionReleased]");
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.connectionReleased(call, connection);
        }
    }

    public void connectionAcquired(@NotNull Call call, @NotNull Connection connection) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            super.connectionAcquired(call, connection);
            ExtensionKt.printEvent("[connectionAcquired] connection: " + connection);
            Object object = connection.handshake();
            if (object == null || (object = object.tlsVersion()) == null || (object = object.name()) == null) {
                object = "";
            }
            this.mMonitorData.setTlsVersion((String)object);
            this.mMonitorData.setProtocol(connection.protocol().name());
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.connectionAcquired(call, connection);
        }
    }

    public void requestHeadersStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.requestHeadersStart(call);
            ExtensionKt.printEvent("[requestHeadersStart]");
            this.mReqHeadersStartTime = ExtensionKt.realtime();
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestHeadersStart(call);
        }
    }

    public void requestHeadersEnd(@NotNull Call call, @NotNull Request request) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            super.requestHeadersEnd(call, request);
            ExtensionKt.printEvent("[requestHeadersEnd] request :" + request);
            this.mReqHeadersEndTime = ExtensionKt.realtime();
            this.mMonitorData.setSendTime(this.mReqHeadersEndTime - this.mReqHeadersStartTime);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestHeadersEnd(call, request);
        }
    }

    public void requestBodyStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.requestBodyStart(call);
            ExtensionKt.printEvent("[requestBodyStart]");
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestBodyStart(call);
        }
    }

    public void requestBodyEnd(@NotNull Call call, long byteCount) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.requestBodyEnd(call, byteCount);
            ExtensionKt.printEvent("[requestBodyEnd] byteCount: " + byteCount);
            this.mReqBodyEndTime = ExtensionKt.realtime();
            MonitorData $this$requestBodyEnd_u24lambda_u242 = this.mMonitorData;
            boolean bl = false;
            $this$requestBodyEnd_u24lambda_u242.setReqBodySize(byteCount);
            $this$requestBodyEnd_u24lambda_u242.setSendTime(this.mReqBodyEndTime - this.mReqHeadersStartTime);
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestBodyEnd(call, byteCount);
        }
    }

    public void requestFailed(@NotNull Call call, @NotNull IOException ioe) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
            super.requestFailed(call, ioe);
            ExtensionKt.printErrEvent("[requestFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.requestFailed(call, ioe);
        }
    }

    public void responseHeadersStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.responseHeadersStart(call);
            ExtensionKt.printEvent("[responseHeadersStart]");
            this.mRespHeadersStartTime = ExtensionKt.realtime();
            this.mMonitorData.setWaitTime(this.mRespHeadersStartTime - Long.max(this.mReqBodyEndTime, this.mReqHeadersEndTime));
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseHeadersStart(call);
        }
    }

    public void responseHeadersEnd(@NotNull Call call, @NotNull Response response) {
        block2: {
            String string;
            String provider;
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            super.responseHeadersEnd(call, response);
            ExtensionKt.printEvent("[responseHeadersEnd] code : " + response.code());
            String string2 = response.headers().get("x-response-cdn");
            if (string2 == null) {
                string2 = provider = "";
            }
            if ((string = response.headers().get("server-time")) == null) {
                string = "0";
            }
            long serverTime = Long.parseLong(string);
            ExtensionKt.printEvent(provider);
            this.mMonitorData.setCdnProvider(provider);
            this.mRespHeadersEndTime = ExtensionKt.realtime();
            this.mMonitorData.setRecTime(ExtensionKt.realtimeDiff(this.mRespHeadersStartTime));
            this.mMonitorData.setCdnReqTime(ExtensionKt.realtimeDiff(this.mCallStartTime));
            this.mMonitorData.setServerTime(serverTime);
            this.httpCode = response.code();
            EventListener eventListener = this.listener;
            if (eventListener == null) break block2;
            eventListener.responseHeadersEnd(call, response);
        }
    }

    public void responseBodyStart(@NotNull Call call) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.responseBodyStart(call);
            ExtensionKt.printEvent("[responseBodyStart]");
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseBodyStart(call);
        }
    }

    public void responseBodyEnd(@NotNull Call call, long byteCount) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.responseBodyEnd(call, byteCount);
            ExtensionKt.printEvent("[responseBodyEnd] byteCount: " + byteCount);
            MonitorData $this$responseBodyEnd_u24lambda_u243 = this.mMonitorData;
            boolean bl = false;
            $this$responseBodyEnd_u24lambda_u243.setResBodySize(byteCount);
            $this$responseBodyEnd_u24lambda_u243.setRecTime(ExtensionKt.realtimeDiff(this.mRespHeadersStartTime));
            $this$responseBodyEnd_u24lambda_u243.setCdnDownTime(ExtensionKt.realtimeDiff(this.mRespHeadersEndTime));
            $this$responseBodyEnd_u24lambda_u243.setCdnSpeed(String.valueOf((float)byteCount / 1024.0f / ((float)$this$responseBodyEnd_u24lambda_u243.getCdnDownTime() / 1000.0f)));
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseBodyEnd(call, byteCount);
        }
    }

    public void responseFailed(@NotNull Call call, @NotNull IOException ioe) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
            super.responseFailed(call, ioe);
            ExtensionKt.printErrEvent("[responseFailed] " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
            EventListener eventListener = this.listener;
            if (eventListener == null) break block0;
            eventListener.responseFailed(call, ioe);
        }
    }

    public void callEnd(@NotNull Call call) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            super.callEnd(call);
            ExtensionKt.printEvent("[callEnd]");
            MonitorData $this$callEnd_u24lambda_u244 = this.mMonitorData;
            boolean bl = false;
            $this$callEnd_u24lambda_u244.setCallResultCode(1);
            $this$callEnd_u24lambda_u244.setReqTime(ExtensionKt.realtimeDiff(this.mCallStartTime));
            $this$callEnd_u24lambda_u244.setErrorCode(this.httpCode);
            if ($this$callEnd_u24lambda_u244.getErrorCode() != 304 && !this.notReportData) {
                ExtensionKt.track($this$callEnd_u24lambda_u244);
            }
            EventListener eventListener = this.listener;
            if (eventListener == null) break block1;
            eventListener.callEnd(call);
        }
    }

    public void callFailed(@NotNull Call call, @NotNull IOException ioe) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
            super.callFailed(call, ioe);
            ExtensionKt.printErrEvent("[callFailed]  " + ioe.getClass().getSimpleName() + " : " + ioe.getMessage());
            this.mMonitorData.setCallResultCode(2);
            if (this.isNetDone()) {
                if (!NetworkMonitor.INSTANCE.isNetworkConnected$lib_networkmonitor_release()) {
                    this.errorCode = 1020;
                    this.errorMsg = "Network disconnect";
                } else if (NetworkMonitor.INSTANCE.isFakeNetwork$lib_networkmonitor_release()) {
                    this.errorCode = 1021;
                    this.errorMsg = "Fake Network";
                } else {
                    this.errorCode = CodeUtil.INSTANCE.fetchCode(this.httpCode, ioe);
                }
            } else {
                this.errorCode = CodeUtil.INSTANCE.fetchCode(this.httpCode, ioe);
            }
            this.mMonitorData.setErrorCode(this.errorCode);
            this.mMonitorData.setErrorMsg(Intrinsics.areEqual((Object)this.errorMsg, (Object)"Unknown") ? ExtensionKt.shortMsg(ioe) : this.errorMsg);
            if (!this.notReportData) {
                boolean isTrack = true;
                if (this.notReportCancel && this.errorCode == 1050) {
                    isTrack = false;
                }
                if (this.notReportNoNetwork && this.errorCode == 1020) {
                    isTrack = false;
                }
                if (isTrack) {
                    ExtensionKt.track(this.mMonitorData);
                }
            }
            EventListener eventListener = this.listener;
            if (eventListener == null) break block10;
            eventListener.callFailed(call, ioe);
        }
    }

    private final boolean isNetDone() {
        return NetworkMonitor.INSTANCE.isNetInitDone$lib_networkmonitor_release() || SystemClock.uptimeMillis() - NetworkMonitor.INSTANCE.getInitStartTime$lib_networkmonitor_release() > 3000L;
    }

    @Override
    public void onRequestUpdate(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ExtensionKt.printEvent("[onRequestUpdate]");
        MonitorEventListener monitorEventListener = this;
        try {
            String string;
            String string2;
            String string3;
            MonitorEventListener $this$onRequestUpdate_u24lambda_u245 = monitorEventListener;
            boolean bl = false;
            String host = request.url().host();
            String path = request.url().encodedPath();
            MonitorData monitorData = $this$onRequestUpdate_u24lambda_u245.mMonitorData;
            String string4 = path;
            if (string4 == null) {
                string3 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"path ?: \"\"");
                string3 = path;
            }
            monitorData.setPath(string3);
            MonitorData monitorData2 = $this$onRequestUpdate_u24lambda_u245.mMonitorData;
            String string5 = host;
            if (string5 == null) {
                string2 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"host ?: \"\"");
                string2 = host;
            }
            monitorData2.setHost(string2);
            String string6 = request.url().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"request.url().toString()");
            String url = string6;
            $this$onRequestUpdate_u24lambda_u245.mMonitorData.setCompleteApi($this$onRequestUpdate_u24lambda_u245.randomNumber <= 2 ? url : "");
            MonitorData monitorData3 = $this$onRequestUpdate_u24lambda_u245.mMonitorData;
            if ($this$onRequestUpdate_u24lambda_u245.usage == 0 && StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) {
                String string7 = url.substring(0, StringsKt.indexOf$default((CharSequence)url, (String)"?", (int)0, (boolean)false, (int)6, null));
                string = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = url;
            }
            monitorData3.setServerApi(string);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    @Override
    public void onDowngrade(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ExtensionKt.printEvent("[onDowngrade]");
        this.mMonitorData.setRequestDowngrade(1);
    }
}

