/*
 * Decompiled with CFR 0.152.
 */
package com.transsin.networkmonitor;

import com.transsin.networkmonitor.HostMatcher;
import com.transsin.networkmonitor.MonitorEventListener;
import com.transsin.networkmonitor.Utils;
import okhttp3.Call;
import okhttp3.EventListener;

public class MonitorFactory
implements EventListener.Factory {
    private EventListener.Factory factory;
    private int usage = 0;
    private boolean notReportData = false;
    private boolean notReportCancel = false;
    private boolean notReportNoNetwork = false;
    private String channel = "All";

    public MonitorFactory() {
    }

    public MonitorFactory(EventListener.Factory factory) {
        this.factory = factory;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData, String channel) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
        this.channel = channel;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData, String channel, boolean notReportCancel) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
        this.channel = channel;
        this.notReportCancel = notReportCancel;
    }

    public MonitorFactory(EventListener.Factory factory, int usage, boolean notReportData, String channel, boolean notReportCancel, boolean notReportNoNetwork) {
        this.factory = factory;
        this.usage = usage;
        this.notReportData = notReportData;
        this.channel = channel;
        this.notReportCancel = notReportCancel;
        this.notReportNoNetwork = notReportNoNetwork;
    }

    public EventListener create(Call call) {
        EventListener eventListener = null;
        if (this.factory != null) {
            eventListener = this.factory.create(call);
        }
        String host = call.request().url().host();
        if (HostMatcher.noHosts() || HostMatcher.match(host)) {
            Utils.LOG.d("NetworkMonitor", new Object[]{"==== MonitorFactory host : ${host} matches ===="});
            return new MonitorEventListener(eventListener, this.usage, this.notReportData, this.channel, this.notReportCancel, this.notReportNoNetwork);
        }
        Utils.LOG.d("NetworkMonitor", new Object[]{"==== MonitorFactory host : ${host} does not matche ===="});
        return eventListener == null ? EventListener.NONE : eventListener;
    }
}

